/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.NameRemapper;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRazorWire;
import blusunrize.immersiveengineering.common.crafting.MixerPotionHelper;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemIEShield;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IEVillagerHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.MerchantTradeOffersEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class EventHandler {
    public static final ArrayList<IEBlockInterfaces.ISpawnInterdiction> interdictionTiles = new ArrayList();
    public static boolean validateConnsNextTick = false;
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static final Queue<Pair<Integer, BlockPos>> requestedBlockUpdates = new LinkedList<Pair<Integer, BlockPos>>();
    public static final Set<TileEntity> REMOVE_FROM_TICKING = new HashSet<TileEntity>();
    public static List<ResourceLocation> lootInjections = Arrays.asList(new ResourceLocation("immersiveengineering", "chests/stronghold_library"), new ResourceLocation("immersiveengineering", "chests/village_blacksmith"));
    static Field f_lootEntries;
    public static HashMap<UUID, TileEntityCrusher> crusherMap;
    public static HashSet<Class<? extends EntityLiving>> listOfBoringBosses;

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
        if (Config.IEConfig.blocksBreakWires) {
            event.getWorld().func_72954_a((IWorldEventListener)ImmersiveNetHandler.INSTANCE.LISTENER);
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onCapabilitiesAttachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityMinecart) {
            event.addCapability(new ResourceLocation("immersiveengineering:shader"), (ICapabilityProvider)new CapabilityShader.ShaderWrapper_Direct("immersiveengineering:minecart"));
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("immersiveengineering", "skyhook_data"), (ICapabilityProvider)new CapabilitySkyhookData.SimpleSkyhookProvider());
        }
    }

    @SubscribeEvent
    public void onCapabilitiesAttachItem(final AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemPotion) {
            final IFluidHandlerItem potionHandler = new IFluidHandlerItem(){
                boolean isEmpty = false;
                FluidStack potion = null;

                void ensurePotionAvailable() {
                    if (this.potion == null) {
                        this.potion = MixerPotionHelper.getFluidStackForType(PotionUtils.func_185191_c((ItemStack)((ItemStack)event.getObject())), 250);
                    }
                }

                @Nonnull
                public ItemStack getContainer() {
                    if (this.isEmpty) {
                        return new ItemStack(Items.field_151069_bo);
                    }
                    return (ItemStack)event.getObject();
                }

                public IFluidTankProperties[] getTankProperties() {
                    this.ensurePotionAvailable();
                    if (this.isEmpty) {
                        return new IFluidTankProperties[0];
                    }
                    return new IFluidTankProperties[]{new FluidTankProperties(this.potion, 250, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    this.ensurePotionAvailable();
                    if (this.isEmpty) {
                        return null;
                    }
                    if (!resource.isFluidEqual(this.potion)) {
                        return null;
                    }
                    return this.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    this.ensurePotionAvailable();
                    if (maxDrain < 250) {
                        return null;
                    }
                    if (doDrain) {
                        this.isEmpty = true;
                    }
                    return new FluidStack(this.potion, 250);
                }
            };
            event.addCapability(new ResourceLocation("immersiveengineering", "potions"), new ICapabilityProvider(){

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)potionHandler);
                    }
                    return null;
                }
            });
        }
    }

    @SubscribeEvent
    public void onFurnaceBurnTime(FurnaceFuelBurnTimeEvent event) {
        FluidStack fs;
        if (Utils.isFluidRelatedItemStack(event.getItemStack()) && (fs = FluidUtil.getFluidContained((ItemStack)event.getItemStack())) != null && fs.getFluid() == IEContent.fluidCreosote) {
            event.setBurnTime((int)(0.8 * (double)fs.amount));
        }
    }

    @SubscribeEvent
    public void onMinecartInteraction(MinecartInteractEvent event) {
        CapabilityShader.ShaderWrapper wrapper;
        if (!event.getPlayer().field_70170_p.field_72995_K && !event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof IShaderItem && event.getMinecart().hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && (wrapper = (CapabilityShader.ShaderWrapper)event.getMinecart().getCapability(CapabilityShader.SHADER_CAPABILITY, null)) != null) {
            wrapper.setShaderItem(Utils.copyStackWithAmount(event.getItem(), 1));
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageMinecartShaderSync((Entity)event.getMinecart(), wrapper), (EntityPlayerMP)event.getPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        Vec3d prevPosVec;
        Vec3d movVec;
        CapabilityShader.ShaderWrapper wrapper;
        if (event.getMinecart().field_70173_aa % 3 == 0 && event.getMinecart().hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && (wrapper = (CapabilityShader.ShaderWrapper)event.getMinecart().getCapability(CapabilityShader.SHADER_CAPABILITY, null)) != null && (movVec = (prevPosVec = new Vec3d(event.getMinecart().field_70169_q, event.getMinecart().field_70167_r, event.getMinecart().field_70166_s)).func_178786_a(event.getMinecart().field_70165_t, event.getMinecart().field_70163_u, event.getMinecart().field_70161_v)).func_189985_c() > 1.0E-4) {
            movVec = movVec.func_72432_b();
            Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(wrapper);
            if (shader != null) {
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(event.getMinecart().field_70170_p, (ItemStack)shader.getLeft(), null, ((ShaderCase)shader.getRight()).getShaderType(), prevPosVec.func_72441_c(0.0, 0.25, 0.0).func_178787_e(movVec), movVec.func_186678_a(1.5), 0.25f);
            }
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (event.getName().func_110624_b().equals("minecraft")) {
            for (ResourceLocation inject : lootInjections) {
                if (!event.getName().func_110623_a().equals(inject.func_110623_a())) continue;
                LootPool injectPool = Utils.loadBuiltinLootTable(inject, event.getLootTableManager()).getPool("immersiveengineering_loot_inject");
                LootPool mainPool = event.getTable().getPool("main");
                if (injectPool == null || mainPool == null) continue;
                try {
                    if (f_lootEntries == null) {
                        f_lootEntries = LootPool.class.getDeclaredField(ObfuscationReflectionHelper.remapFieldNames((String)LootPool.class.getName(), (String[])new String[]{"field_186453_a"})[0]);
                        f_lootEntries.setAccessible(true);
                    }
                    if (f_lootEntries == null) continue;
                    List entryList = (List)f_lootEntries.get(injectPool);
                    for (LootEntry entry : entryList) {
                        mainPool.addEntry(entry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityMinecart && event.getEntity().hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageMinecartShaderSync(event.getEntity(), null));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && validateConnsNextTick && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            boolean validateConnections = Config.IEConfig.validateConnections;
            int invalidConnectionsDropped = 0;
            for (int dim : ImmersiveNetHandler.INSTANCE.getRelevantDimensions()) {
                if (!validateConnections) continue;
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
                if (world == null) {
                    ImmersiveNetHandler.INSTANCE.directConnections.remove(dim);
                    continue;
                }
                for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                    if (world.func_175625_s(con.start) instanceof IImmersiveConnectable && world.func_175625_s(con.end) instanceof IImmersiveConnectable) continue;
                    ImmersiveNetHandler.INSTANCE.removeConnection((World)world, con);
                    ++invalidConnectionsDropped;
                }
                IELogger.info("removed " + invalidConnectionsDropped + " invalid connections from world");
            }
            int invalidProxies = 0;
            HashSet<DimensionBlockPos> toRemove = new HashSet<DimensionBlockPos>();
            for (Map.Entry<DimensionBlockPos, IICProxy> e : ImmersiveNetHandler.INSTANCE.proxies.entrySet()) {
                if (!validateConnections) continue;
                DimensionBlockPos p = e.getKey();
                WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(p.dimension);
                if (w != null && w.func_175667_e((BlockPos)p)) {
                    toRemove.add(p);
                }
                if (validateConnections && w == null) {
                    ++invalidProxies;
                    toRemove.add(p);
                    continue;
                }
                if (!validateConnections || w.func_175625_s((BlockPos)p) instanceof IImmersiveConnectable) continue;
                ++invalidProxies;
                toRemove.add(p);
            }
            if (invalidProxies > 0) {
                IELogger.info("Removed " + invalidProxies + " invalid connector proxies (used to transfer power through unloaded chunks)");
            }
            validateConnsNextTick = false;
        }
        if (event.phase == TickEvent.Phase.END && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int dim = event.world.field_73011_w.getDimension();
            for (Map.Entry<ImmersiveNetHandler.Connection, Integer> e : ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).entrySet()) {
                if (e.getValue() <= e.getKey().cableType.getTransferRate()) continue;
                if (event.world instanceof WorldServer) {
                    BlockPos start = e.getKey().start;
                    for (Vec3d vec : e.getKey().getSubVertices(event.world)) {
                        ((WorldServer)event.world).func_175739_a(EnumParticleTypes.FLAME, vec.field_72450_a + (double)start.func_177958_n(), vec.field_72448_b + (double)start.func_177956_o(), vec.field_72449_c + (double)start.func_177952_p(), 0, 0.0, 0.02, 0.0, 1.0, new int[0]);
                    }
                }
                ImmersiveNetHandler.INSTANCE.removeConnection(event.world, e.getKey());
            }
            ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).clear();
            if (!REMOVE_FROM_TICKING.isEmpty()) {
                event.world.field_175730_i.removeAll(REMOVE_FROM_TICKING);
                REMOVE_FROM_TICKING.removeIf(te -> te.func_145831_w().field_73011_w.getDimension() == dim);
            }
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!currentExplosions.isEmpty()) {
                Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
                while (itExplosion.hasNext()) {
                    IEExplosion ex = itExplosion.next();
                    ex.doExplosionTick();
                    if (!ex.isExplosionFinished) continue;
                    itExplosion.remove();
                }
            }
            while (!requestedBlockUpdates.isEmpty()) {
                Pair<Integer, BlockPos> curr = requestedBlockUpdates.poll();
                WorldServer w = DimensionManager.getWorld((int)((Integer)curr.getLeft()));
                if (w == null) continue;
                IBlockState state = w.func_180495_p((BlockPos)curr.getRight());
                w.func_184138_a((BlockPos)curr.getRight(), state, state, 3);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ExcavatorHandler.allowPackets = true;
        if (!event.player.field_70170_p.field_72995_K) {
            HashMap<ExcavatorHandler.MineralMix, Integer> packetMap = new HashMap<ExcavatorHandler.MineralMix, Integer>();
            for (Map.Entry<ExcavatorHandler.MineralMix, Integer> e : ExcavatorHandler.mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ExcavatorHandler.allowPackets = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        TileEntityCrusher crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().func_76355_l()) && (crusher = crusherMap.get(event.getEntityLiving().func_110124_au())) != null) {
            for (EntityItem item : event.getDrops()) {
                if (item == null || item.func_92059_d().func_190926_b()) continue;
                crusher.doProcessOutput(item.func_92059_d());
            }
            crusherMap.remove(event.getEntityLiving().func_110124_au());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && !event.getEntityLiving().func_184222_aU()) {
            EnumRarity r = EnumRarity.EPIC;
            for (Class<? extends EntityLiving> boring : listOfBoringBosses) {
                if (!boring.isAssignableFrom(event.getEntityLiving().getClass())) continue;
                return;
            }
            ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag);
            ItemNBTHelper.setString(bag, "rarity", r.toString());
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack activeStack;
        if (event.getEntityLiving() instanceof EntityPlayer && !(activeStack = (player = (EntityPlayer)event.getEntityLiving()).func_184607_cu()).func_190926_b() && activeStack.func_77973_b() instanceof ItemIEShield && event.getAmount() >= 3.0f && Utils.canBlockDamageSource((EntityLivingBase)player, event.getSource())) {
            float amount = event.getAmount();
            ((ItemIEShield)activeStack.func_77973_b()).hitShield(activeStack, player, event.getSource(), amount, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float mod;
        int amp;
        if (event.getSource().func_76347_k() && event.getEntityLiving().func_70660_b(IEPotions.flammable) != null) {
            amp = event.getEntityLiving().func_70660_b(IEPotions.flammable).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (("flux".equals(event.getSource().func_76355_l()) || IEDamageSources.razorShock.equals(event.getSource()) || event.getSource() instanceof IEDamageSources.ElectricDamageSource) && event.getEntityLiving().func_70660_b(IEPotions.conductive) != null) {
            amp = event.getEntityLiving().func_70660_b(IEPotions.conductive).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (!event.isCanceled() && !event.getEntityLiving().func_184222_aU() && event.getAmount() >= event.getEntityLiving().func_110143_aJ() && event.getSource().func_76346_g() instanceof EntityPlayer && ((EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemDrill) {
            Utils.unlockIEAdvancement((EntityPlayer)event.getSource().func_76346_g(), "main/secret_drillbreak");
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70660_b(IEPotions.sticky) != null) {
            event.getEntityLiving().field_70181_x -= (double)((float)(event.getEntityLiving().func_70660_b(IEPotions.sticky).func_76458_c() + 1) * 0.3f);
        } else if (event.getEntityLiving().func_70660_b(IEPotions.concreteFeet) != null) {
            event.getEntityLiving().field_70159_w = 0.0;
            event.getEntityLiving().field_70181_x = 0.0;
            event.getEntityLiving().field_70179_y = 0.0;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack powerpack;
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && ItemNBTHelper.hasKey(event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), "IE:Powerpack")).func_190926_b()) {
            powerpack.func_77973_b().onArmorTick(event.getEntityLiving().func_130014_f_(), (EntityPlayer)event.getEntityLiving(), powerpack);
        }
    }

    @SubscribeEvent
    public void onMerchantTrade(MerchantTradeOffersEvent event) {
        if (event.getMerchant() instanceof EntityVillager && ((EntityVillager)event.getMerchant()).getProfessionForge() == IEVillagerHandler.PROF_ENGINEER && event.getList() != null) {
            for (MerchantRecipe recipe : event.getList()) {
                ItemStack output = recipe.func_77397_d();
                if (output.func_77973_b() == IEContent.itemMaterial && ItemNBTHelper.hasKey(output, "generatePerks")) {
                    EntityPlayer player = event.getPlayer();
                    Random random = player.func_70681_au();
                    ItemNBTHelper.remove(output, "generatePerks");
                    NBTTagCompound perksTag = ItemRevolver.RevolverPerk.generatePerkSet(random, player.func_184817_da());
                    ItemNBTHelper.setTagCompound(output, "perks", perksTag);
                    int tier = Math.max(1, ItemRevolver.RevolverPerk.calculateTier(perksTag));
                    recipe.func_77394_a().func_190920_e(5 * tier + random.nextInt(5));
                    continue;
                }
                if (output.func_77973_b() != IEContent.itemMaterial || !ItemNBTHelper.hasKey(output, "perks") || recipe.func_180321_e() < 1 || recipe.func_180320_f() <= 0) continue;
                recipe.func_82783_a(Integer.MIN_VALUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.getDimension() != event.getEntity().field_70170_p.field_73011_w.getDimension() || !(((TileEntity)interdictor).func_145835_a(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.getDimension() != event.getEntity().field_70170_p.field_73011_w.getDimension() || !(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setCanceled(true);
                }
            }
        }
        if (event.getEntityLiving().func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.isSpawner()) {
            return;
        }
        if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.getDimension() != event.getEntity().field_70170_p.field_73011_w.getDimension() || !(((TileEntity)interdictor).func_145835_a(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.getDimension() != event.getEntity().field_70170_p.field_73011_w.getDimension() || !(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        TileEntity te;
        ItemStack current = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (!current.func_190926_b() && current.func_77973_b().equals(IEContent.itemDrill) && current.func_77952_i() == 0 && event.getEntityPlayer().func_70055_a(Material.field_151586_h)) {
            if (((ItemDrill)IEContent.itemDrill).getUpgrades(current).func_74767_n("waterproof")) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().func_177230_c() == IEContent.blockMetalDecoration2 && IEContent.blockMetalDecoration2.func_176201_c(event.getState()) == BlockTypes_MetalDecoration2.RAZOR_WIRE.getMeta() && !OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 1), (ItemStack)current, (boolean)false)) {
            event.setCanceled(true);
            TileEntityRazorWire.applyDamage(event.getEntityLiving());
        }
        if ((te = event.getEntityPlayer().func_130014_f_().func_175625_s(event.getPos())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() instanceof IDrillHead && ((IDrillHead)event.getLeft().func_77973_b()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().func_190926_b() && event.getLeft().func_77973_b().func_82789_a(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().func_77946_l());
            int repair = Math.min(((IDrillHead)event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().func_190916_E(); ++cost) {
                ((IDrillHead)event.getOutput().func_77973_b()).damageHead(event.getOutput(), -repair);
                event.setCost(Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().func_82837_s()) {
                    event.setCost(event.getCost() + 5);
                    event.getOutput().func_135074_t();
                }
            } else if (!event.getName().equals(event.getLeft().func_82833_r())) {
                event.setCost(event.getCost() + 5);
                if (event.getLeft().func_82837_s()) {
                    event.setCost(event.getCost() + 2);
                }
                event.getOutput().func_151001_c(event.getName());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void breakLast(BlockEvent.BreakEvent event) {
        TileEntity te;
        if (event.getState().func_177230_c() instanceof BlockIEMultiblock && (te = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityMultiblockPart) {
            ((TileEntityMultiblockPart)te).onlyLocalDissassembly = event.getWorld().func_82737_E();
        }
    }

    @SubscribeEvent
    public void remap(RegistryEvent.MissingMappings<?> ev) {
        NameRemapper.remap(ev);
    }

    static {
        crusherMap = new HashMap();
        listOfBoringBosses = new HashSet();
        listOfBoringBosses.add(EntityWither.class);
    }
}

