/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.theme.HasBorder;

public class GridImage
implements Image,
HasBorder {
    private final Image[] images;
    private final int[] weightX;
    private final int[] weightY;
    private final Border border;
    private final int width;
    private final int height;
    private final int[] columnWidth;
    private final int[] rowHeight;
    private final int weightSumX;
    private final int weightSumY;

    GridImage(Image[] images, int[] weightX, int[] weightY, Border border) {
        if (weightX.length == 0 || weightY.length == 0) {
            throw new IllegalArgumentException("zero dimension size not allowed");
        }
        assert (weightX.length * weightY.length == images.length);
        this.images = images;
        this.weightX = weightX;
        this.weightY = weightY;
        this.border = border;
        this.columnWidth = new int[weightX.length];
        this.rowHeight = new int[weightY.length];
        int widthTmp = 0;
        for (int x = 0; x < weightX.length; ++x) {
            int widthColumn = 0;
            for (int y = 0; y < weightY.length; ++y) {
                widthColumn = Math.max(widthColumn, this.getImage(x, y).getWidth());
            }
            widthTmp += widthColumn;
            this.columnWidth[x] = widthColumn;
        }
        this.width = widthTmp;
        int heightTmp = 0;
        for (int y = 0; y < weightY.length; ++y) {
            int heightRow = 0;
            for (int x = 0; x < weightX.length; ++x) {
                heightRow = Math.max(heightRow, this.getImage(x, y).getHeight());
            }
            heightTmp += heightRow;
            this.rowHeight[y] = heightRow;
        }
        this.height = heightTmp;
        int tmpSumX = 0;
        for (int weight : weightX) {
            if (weight < 0) {
                throw new IllegalArgumentException("negative weight in weightX");
            }
            tmpSumX += weight;
        }
        this.weightSumX = tmpSumX;
        int tmpSumY = 0;
        for (int weight : weightY) {
            if (weight < 0) {
                throw new IllegalArgumentException("negative weight in weightY");
            }
            tmpSumY += weight;
        }
        this.weightSumY = tmpSumY;
        if (this.weightSumX <= 0) {
            throw new IllegalArgumentException("zero weightX not allowed");
        }
        if (this.weightSumY <= 0) {
            throw new IllegalArgumentException("zero weightX not allowed");
        }
    }

    private GridImage(Image[] images, GridImage src) {
        this.images = images;
        this.weightX = src.weightX;
        this.weightY = src.weightY;
        this.border = src.border;
        this.columnWidth = src.columnWidth;
        this.rowHeight = src.rowHeight;
        this.weightSumX = src.weightSumX;
        this.weightSumY = src.weightSumY;
        this.width = src.width;
        this.height = src.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.width, this.height);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height) {
        int deltaY = height - this.height;
        int remWeightY = this.weightSumY;
        int idx = 0;
        for (int yi = 0; yi < this.weightY.length; ++yi) {
            int heightRow = this.rowHeight[yi];
            if (remWeightY > 0) {
                int partY = deltaY * this.weightY[yi] / remWeightY;
                remWeightY -= this.weightY[yi];
                heightRow += partY;
                deltaY -= partY;
            }
            int tmpX = x;
            int deltaX = width - this.width;
            int remWeightX = this.weightSumX;
            int xi = 0;
            while (xi < this.weightX.length) {
                int widthColumn = this.columnWidth[xi];
                if (remWeightX > 0) {
                    int partX = deltaX * this.weightX[xi] / remWeightX;
                    remWeightX -= this.weightX[xi];
                    widthColumn += partX;
                    deltaX -= partX;
                }
                this.images[idx].draw(as, tmpX, y, widthColumn, heightRow);
                tmpX += widthColumn;
                ++xi;
                ++idx;
            }
            y += heightRow;
        }
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Image createTintedVersion(Color color) {
        Image[] newImages = new Image[this.images.length];
        for (int i = 0; i < newImages.length; ++i) {
            newImages[i] = this.images[i].createTintedVersion(color);
        }
        return new GridImage(newImages, this);
    }

    private Image getImage(int x, int y) {
        return this.images[x + y * this.weightX.length];
    }
}

