/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.entity.EntitySeat;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.SeatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChair
extends BlockFurniture {
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.2, 0.9);
    public static final AxisAlignedBB CHAIR_SEAT = new AxisAlignedBB(0.1, 0.5, 0.1, 0.9, 0.6, 0.9);
    public static final AxisAlignedBB CHAIR_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.825, 0.6, 0.1, 0.9, 1.2, 0.9);
    public static final AxisAlignedBB CHAIR_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.825, 0.6, 0.1, 0.9, 1.2, 0.9);
    public static final AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.825, 0.6, 0.1, 0.9, 1.2, 0.9);
    public static final AxisAlignedBB CHAIR_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.825, 0.6, 0.1, 0.9, 1.2, 0.9);
    public static final AxisAlignedBB[] LEGS = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.0, 0.8, 0.2, 0.5, 0.9), new AxisAlignedBB(0.8, 0.0, 0.8, 0.9, 0.5, 0.9), new AxisAlignedBB(0.8, 0.0, 0.1, 0.9, 0.5, 0.2), new AxisAlignedBB(0.1, 0.0, 0.1, 0.2, 0.5, 0.2)};

    public BlockChair(Material material, SoundType sound) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            Triggers.trigger(Triggers.PLACE_CHAIR, player);
            Triggers.trigger(Triggers.PLACE_CHAIR_OR_TABLE, player);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_70093_af() && SeatUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.375)) {
            worldIn.func_175666_e(pos, (Block)this);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (!(entityIn instanceof EntitySeat)) {
            List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
            for (AxisAlignedBB box : list) {
                BlockChair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
            }
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return SeatUtil.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                list.add(CHAIR_BACKREST_NORTH);
                break;
            }
            case SOUTH: {
                list.add(CHAIR_BACKREST_SOUTH);
                break;
            }
            case WEST: {
                list.add(CHAIR_BACKREST_WEST);
                break;
            }
            default: {
                list.add(CHAIR_BACKREST_EAST);
            }
        }
        list.add(CHAIR_SEAT);
        Collections.addAll(list, LEGS);
        return list;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }
}

