/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.blocks.IPowered;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModernLight
extends Block
implements IPowered {
    private static final AxisAlignedBB[] COLLISION_BOUNDS = new Bounds(14, 4, 4, 16, 12, 12).getRotatedBounds();
    private static final AxisAlignedBB[] SELECTION_BOUNDS = new Bounds(13, 3, 3, 16, 13, 13).getRotatedBounds();
    private static final AxisAlignedBB SELECTION_BOUND_DOWN = new Bounds(3, 0, 3, 13, 3, 13).toAABB();
    private static final AxisAlignedBB SELECTION_BOUND_UP = new Bounds(3, 13, 3, 13, 16, 13).toAABB();
    private static final AxisAlignedBB COLLISION_BOUND_DOWN = new Bounds(4, 0, 4, 14, 2, 14).toAABB();
    private static final AxisAlignedBB COLLISION_BOUND_UP = new Bounds(4, 14, 4, 14, 16, 14).toAABB();
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockModernLight(String id, boolean powered) {
        super(Material.field_151592_s);
        this.func_149663_c(id);
        this.setRegistryName(id);
        this.func_149711_c(0.5f);
        if (!powered) {
            this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
        } else {
            this.func_149715_a(1.0f);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        if (facing.func_176736_b() != -1) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SELECTION_BOUNDS[facing.func_176734_d().func_176736_b()]);
        } else if (facing == EnumFacing.UP) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOUND_DOWN);
        } else if (facing == EnumFacing.DOWN) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOUND_UP);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        if (facing.func_176736_b() != -1) {
            return SELECTION_BOUNDS[facing.func_176734_d().func_176736_b()];
        }
        if (facing == EnumFacing.UP) {
            return SELECTION_BOUND_DOWN;
        }
        if (facing == EnumFacing.DOWN) {
            return SELECTION_BOUND_UP;
        }
        return field_185505_j;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a(FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void setPowered(World world, BlockPos pos, boolean powered) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b(FACING);
        if (powered) {
            world.func_175656_a(pos, FurnitureBlocks.MODERN_LIGHT_ON.func_176223_P().func_177226_a(FACING, (Comparable)facing));
        } else {
            world.func_175656_a(pos, FurnitureBlocks.MODERN_LIGHT_OFF.func_176223_P().func_177226_a(FACING, (Comparable)facing));
        }
    }
}

