/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class TextInputPopup
extends Popup {
    protected Consumer<String> callback;
    protected String input = null;
    protected AdvancedTextField textField;
    protected AdvancedButton doneButton;
    protected Color color;
    protected int width = 250;
    protected String title = "";

    public TextInputPopup(Color color, String title, CharacterFilter filter, int alpha) {
        super(alpha);
        this.init(color, title, filter, null);
    }

    public TextInputPopup(Color color, String title, CharacterFilter filter, int backgroundAlpha, Consumer<String> callback) {
        super(backgroundAlpha);
        this.init(color, title, filter, callback);
    }

    protected void init(Color color, String title, CharacterFilter filter, Consumer<String> callback) {
        this.textField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, filter);
        this.textField.func_146205_d(true);
        this.textField.func_146195_b(false);
        this.textField.func_146203_f(1000);
        this.doneButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.done", new String[0]), true, press -> {
            this.input = this.textField.func_146179_b();
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(this.input);
            }
        });
        this.addButton(this.doneButton);
        if (title != null) {
            this.title = title;
        }
        this.color = color;
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    @Override
    public void render(int mouseX, int mouseY, GuiScreen renderIn) {
        super.render(mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int height = 100;
            GlStateManager.func_179147_l();
            Gui.func_73734_a((int)(renderIn.field_146294_l / 2 - this.width / 2), (int)(renderIn.field_146295_m / 2 - height / 2), (int)(renderIn.field_146294_l / 2 + this.width / 2), (int)(renderIn.field_146295_m / 2 + height / 2), (int)this.color.getRGB());
            GlStateManager.func_179084_k();
            renderIn.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.title, renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - height / 2 + 10, Color.WHITE.getRGB());
            this.textField.field_146209_f = renderIn.field_146294_l / 2 - this.textField.field_146218_h / 2;
            this.textField.field_146210_g = renderIn.field_146295_m / 2 - this.textField.field_146219_i / 2;
            this.textField.func_146194_f();
            this.doneButton.field_146128_h = renderIn.field_146294_l / 2 - this.doneButton.field_146120_f / 2;
            this.doneButton.field_146129_i = renderIn.field_146295_m / 2 + height / 2 - this.doneButton.field_146121_g - 5;
            this.renderButtons(mouseX, mouseY);
        }
    }

    public void setText(String text) {
        this.textField.func_146180_a("");
        this.textField.func_146191_b(text);
    }

    public String getInput() {
        return this.input;
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 28 && this.isDisplayed()) {
            this.input = this.textField.func_146179_b().replace("\n", "").replace("\r", "");
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(this.input);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 1 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(null);
            }
        }
    }
}

