/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import betterwithmods.api.FeatureEnabledEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class FoodTooltip
extends Feature {
    public static int divisor = 2;

    @SubscribeEvent
    @Optional.Method(modid="betterwithmods")
    public void bwmFeatureEnabled(FeatureEnabledEvent event) {
        if (event.getFeature().equals("hchunger") && event.isEnabled()) {
            divisor = 12;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemFood) {
            int pips = ((ItemFood)event.getItemStack().func_77973_b()).func_150905_g(event.getItemStack());
            int len = (int)Math.ceil((double)pips / (double)divisor);
            StringBuilder s = new StringBuilder(" ");
            for (int i = 0; i < len; ++i) {
                s.append("  ");
            }
            List tooltip = event.getToolTip();
            if (tooltip.isEmpty()) {
                tooltip.add(s.toString());
            } else {
                tooltip.add(1, s.toString());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        if (!event.getStack().func_190926_b() && event.getStack().func_77973_b() instanceof ItemFood) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(GuiIngameForge.field_110324_m);
            ItemFood food = (ItemFood)event.getStack().func_77973_b();
            int pips = food.func_150905_g(event.getStack());
            PotionEffect eff = (PotionEffect)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)food, (String)"field_77851_ca");
            boolean poison = eff != null && eff.func_188419_a().func_76398_f();
            int count = (int)Math.ceil((double)pips / (double)divisor);
            int y = FoodTooltip.shiftTextByLines(event.getLines(), event.getY() + 10);
            for (int i = 0; i < count; ++i) {
                int x = event.getX() + i * 9 - 2;
                int u = 16;
                if (poison) {
                    u += 117;
                }
                int v = 27;
                Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (float)256.0f, (float)256.0f);
                u = 52;
                if (pips % 2 != 0 && i == 0) {
                    u += 9;
                }
                if (poison) {
                    u += 36;
                }
                Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (float)256.0f, (float)256.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    public static int shiftTextByLines(List<String> lines, int y) {
        for (int i = 1; i < lines.size(); ++i) {
            String s = lines.get(i);
            if ((s = TextFormatting.func_110646_a((String)s)) == null || !s.trim().isEmpty()) continue;
            y += 10 * (i - 1) + 1;
            break;
        }
        return y;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"appleskin"};
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

