/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageItemUpdate;
import vazkii.quark.client.render.RenderItemFlashing;

public class ItemsFlashBeforeExpiring
extends Feature {
    public static int minTime;
    private static final WeakHashMap<EntityItem, Integer> AGE_MAP;
    private static final WeakHashMap<EntityItem, Integer> LIFESPAN_MAP;

    @Override
    public void setupConfig() {
        minTime = this.loadPropInt("Time To Start Flashing", "How many ticks should the item have left when it starts flashing. Default is 10 seconds (200).", 200);
    }

    public static void setItemAge(EntityItem item, int age) {
        ObfuscationReflectionHelper.setPrivateValue(EntityItem.class, (Object)item, (Object)age, (String)"field_70292_b");
    }

    public static int getItemAge(EntityItem item) {
        return (Integer)ObfuscationReflectionHelper.getPrivateValue(EntityItem.class, (Object)item, (String)"field_70292_b");
    }

    public static void updateItemInfo(EntityItem item) {
        int prev;
        if (item.field_70170_p.field_72995_K || !(item.field_70170_p instanceof WorldServer)) {
            return;
        }
        int age = ItemsFlashBeforeExpiring.getItemAge(item);
        int lifespan = item.lifespan;
        boolean anyChange = false;
        if (!AGE_MAP.containsKey(item)) {
            AGE_MAP.put(item, age);
        } else {
            prev = AGE_MAP.get(item);
            if (age != prev && age != prev + 1) {
                anyChange = true;
            }
        }
        if (!LIFESPAN_MAP.containsKey(item)) {
            LIFESPAN_MAP.put(item, lifespan);
        } else {
            prev = LIFESPAN_MAP.get(item);
            if (lifespan != prev) {
                anyChange = true;
            }
        }
        if (anyChange) {
            WorldServer server = (WorldServer)item.field_70170_p;
            for (EntityPlayer player : server.func_73039_n().getTrackingPlayers((Entity)item)) {
                if (!(player instanceof EntityPlayerMP)) continue;
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageItemUpdate(item.func_145782_y(), age, lifespan), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityItem.class, RenderItemFlashing.factory());
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        AGE_MAP = new WeakHashMap();
        LIFESPAN_MAP = new WeakHashMap();
    }
}

