/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityItemRepository;
import java.util.Arrays;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandDebug
extends CommandBase {
    public String func_71517_b() {
        return "storagedrawers";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.storagedrawers.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Entity e;
        if (args.length < 1) {
            return;
        }
        if (args[0].equals("simulate") && (e = sender.func_174793_f()) instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)e;
            this.simulateOp(server, mp, Arrays.copyOfRange(args, 1, args.length));
        }
    }

    private void simulateOp(MinecraftServer server, EntityPlayerMP player, String[] args) {
        if (args.length < 2) {
            return;
        }
        ItemStack item = player.func_184586_b(EnumHand.MAIN_HAND);
        if (item.func_190926_b()) {
            this.sendMessage((ICommandSender)player, "Need item in hand to perform simulation");
            return;
        }
        RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(player.field_71134_c.getBlockReachDistance() + 1.0));
        if (rayResult == null) {
            this.sendMessage((ICommandSender)player, "Not facing a block");
            return;
        }
        BlockPos pos = rayResult.func_178782_a();
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            this.sendMessage((ICommandSender)player, "Target block not a suitable inventory");
            return;
        }
        if (args[0].equals("itemrepo")) {
            IItemRepository repo = (IItemRepository)tile.getCapability(CapabilityItemRepository.ITEM_REPOSITORY_CAPABILITY, null);
            if (repo == null) {
                this.sendMessage((ICommandSender)player, "Target block does not have the IItemRepository capability");
                return;
            }
            if (args[1].equals("insert")) {
                if (args.length > 2) {
                    item = item.func_77946_l();
                    item.func_190920_e(Integer.parseInt(args[2]));
                }
                this.sendMessage((ICommandSender)player, "Simulate inserting " + item.toString() + " into tile " + tile.getClass().getSimpleName() + " at " + pos.toString());
                ItemStack remainder = repo.insertItem(item, true);
                this.sendMessage((ICommandSender)player, "Count = " + item.func_190916_E() + "; Accepted = " + (item.func_190916_E() - remainder.func_190916_E()) + "; Remainder = " + remainder.func_190916_E());
            }
        } else if (args[0].equals("itemhandler")) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (handler == null) {
                this.sendMessage((ICommandSender)player, "Target block does not have the IItemHandler capability");
                return;
            }
            if (args[1].equals("insert")) {
                if (args.length > 2) {
                    item = item.func_77946_l();
                    item.func_190920_e(Integer.parseInt(args[2]));
                }
                int slotCount = handler.getSlots();
                int matchCount = 0;
                this.sendMessage((ICommandSender)player, "Simulate inserting " + item.toString() + " into tile " + tile.getClass().getSimpleName() + " at " + pos.toString());
                for (int i = 0; i < slotCount; ++i) {
                    ItemStack remainder = handler.insertItem(i, item, true);
                    if (item.func_190916_E() <= remainder.func_190916_E()) continue;
                    ++matchCount;
                    this.sendMessage((ICommandSender)player, "Slot " + i + ": Count = " + item.func_190916_E() + "; Accepted = " + (item.func_190916_E() - remainder.func_190916_E()) + "; Remainder = " + remainder.func_190916_E());
                }
                this.sendMessage((ICommandSender)player, "Stack full or partial acceptance in " + matchCount + " slots");
            }
        }
    }

    private void sendMessage(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

