/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockCurtainsClosed;
import com.mrcrayfish.furniture.blocks.BlockCurtainsOpen;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.tileentity.TileEntityColoured;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCurtains
extends BlockFurniture
implements ITileEntityProvider {
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};

    public BlockCurtains(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        if (!this.isOpen()) {
            this.func_149713_g(255);
        } else {
            this.func_149713_g(0);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_BLINDS_OR_CURTAINS, (EntityPlayer)placer);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityColoured tileEntityColoured = new TileEntityColoured();
        tileEntityColoured.setColour(15 - meta);
        return tileEntityColoured;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockCurtains.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX[facing.func_176736_b()]);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (this.isOpen()) {
            worldIn.func_180501_a(pos, FurnitureBlocks.CURTAINS_CLOSED.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)COLOUR, state.func_177229_b((IProperty)COLOUR)), 3);
        } else {
            worldIn.func_180501_a(pos, FurnitureBlocks.CURTAINS.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)COLOUR, state.func_177229_b((IProperty)COLOUR)), 3);
        }
        if (tileEntity != null) {
            tileEntity.func_145829_t();
            worldIn.func_175690_a(pos, tileEntity);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            int colour = ((TileEntityColoured)tileEntity).getColour();
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(colour));
        }
        if (this.isOpen()) {
            boolean isRightClosed;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            IBlockState leftState = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
            IBlockState rightState = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
            boolean isLeftOpen = leftState.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)leftState.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean isRightOpen = rightState.func_177230_c() instanceof BlockCurtainsOpen && ((EnumFacing)rightState.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean isLeftClosed = leftState.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)leftState.func_177229_b((IProperty)FACING)).equals((Object)facing);
            boolean bl = isRightClosed = rightState.func_177230_c() instanceof BlockCurtainsClosed && ((EnumFacing)rightState.func_177229_b((IProperty)FACING)).equals((Object)facing);
            if (isRightOpen) {
                if (isLeftOpen) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.NONE));
                }
                if (isLeftClosed) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a(TYPE, (Comparable)((Object)Type.RIGHT_OPEN));
            }
            if (isLeftOpen) {
                if (isRightOpen) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.NONE));
                }
                if (isRightClosed) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.RIGHT_CLOSED));
                }
                return state.func_177226_a(TYPE, (Comparable)((Object)Type.LEFT_OPEN));
            }
            if (isRightClosed) {
                if (isLeftClosed) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (isLeftOpen) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.LEFT));
                }
                return state.func_177226_a(TYPE, (Comparable)((Object)Type.RIGHT));
            }
            if (isLeftClosed) {
                if (isRightClosed) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.BOTH));
                }
                if (isRightOpen) {
                    return state.func_177226_a(TYPE, (Comparable)((Object)Type.LEFT_CLOSED));
                }
                return state.func_177226_a(TYPE, (Comparable)((Object)Type.LEFT));
            }
            return state.func_177226_a(TYPE, (Comparable)((Object)Type.DEFAULT));
        }
        return state;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, ItemStack stack) {
        if (tileEntity instanceof TileEntityColoured) {
            TileEntityColoured couch = (TileEntityColoured)tileEntity;
            ItemStack itemstack = new ItemStack(FurnitureBlocks.CURTAINS_CLOSED, 1, couch.getColour());
            BlockCurtains.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, tileEntity, stack);
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.isOpen() ? new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, COLOUR}) : new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOUR});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(meta));
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack(FurnitureBlocks.CURTAINS_CLOSED, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = 0;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            metadata = ((TileEntityColoured)tileEntity).getColour();
        }
        return new ItemStack(FurnitureBlocks.CURTAINS_CLOSED, 1, metadata);
    }

    public abstract boolean isOpen();

    public static enum Type implements IStringSerializable
    {
        DEFAULT,
        LEFT,
        RIGHT,
        LEFT_OPEN,
        RIGHT_OPEN,
        LEFT_CLOSED,
        RIGHT_CLOSED,
        BOTH,
        NONE;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

