/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.multilayer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;

public class BakedMultiLayerModel
implements IBakedModel {
    private final Map<BlockRenderLayer, List<IBakedModel>> models;
    private final IBakedModel model;

    public BakedMultiLayerModel(Map<BlockRenderLayer, List<IBakedModel>> models) {
        BlockRenderLayer[] preferences;
        this.models = models;
        for (BlockRenderLayer layer : preferences = new BlockRenderLayer[]{BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.TRANSLUCENT}) {
            if (!models.containsKey(layer)) continue;
            List<IBakedModel> solidModels = models.get(layer);
            assert (!solidModels.isEmpty());
            this.model = solidModels.get(0);
            return;
        }
        throw new IllegalArgumentException("Can't create multi layer model without any submodels");
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer current = MinecraftForgeClient.getRenderLayer();
        if (current == null) {
            ImmutableList.Builder ret = new ImmutableList.Builder();
            for (List<IBakedModel> forLayer : this.models.values()) {
                for (IBakedModel model : forLayer) {
                    ret.addAll((Iterable)model.func_188616_a(state, side, rand));
                }
            }
            return ret.build();
        }
        if (this.models.containsKey(current)) {
            ImmutableList.Builder ret = new ImmutableList.Builder();
            for (IBakedModel model : this.models.get(current)) {
                ret.addAll((Iterable)model.func_188616_a(state, side, rand));
            }
            return ret.build();
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.model.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.model.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.model.func_188617_f();
    }
}

