/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorExtract
extends ConveyorBasic {
    private EnumFacing extractDirection;
    private int transferCooldown = -1;
    private int transferTickrate = 8;
    private float extension = -1.0f;
    static final AxisAlignedBB topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);

    public ConveyorExtract(EnumFacing conveyorDir) {
        this.extractDirection = conveyorDir.func_176734_d();
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        float extend;
        TextureAtlasSprite texture_steel = ClientUtils.getSprite(new ResourceLocation("immersiveengineering:blocks/storage_steel"));
        TextureAtlasSprite texture_casing = ClientUtils.getSprite(new ResourceLocation("immersiveengineering:blocks/wooden_device_turntable_bottom"));
        TextureAtlasSprite texture_curtain = ClientUtils.getSprite(new ResourceLocation("immersiveengineering:blocks/cloth_device_stripcurtain"));
        TextureAtlasSprite texture_assembler = ClientUtils.getSprite(new ResourceLocation("immersiveengineering:blocks/metal_multiblock_assembler"));
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(this.extractDirection);
        this.extension = extend = this.getExtensionIntoBlock(tile);
        Function<EnumFacing, TextureAtlasSprite> getCasingSprite = enumFacing -> enumFacing.func_176740_k() == EnumFacing.Axis.Z ? texture_steel : texture_casing;
        Function<Vector3f[], Vector3f[]> vertexTransformer = vertices -> {
            if (extend == 0.0f) {
                return vertices;
            }
            Vector3f[] ret = new Vector3f[((Vector3f[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vector3f(vertices[i].x, vertices[i].y, vertices[i].z - extend);
            }
            return ret;
        };
        Function<Vector3f[], Vector3f[]> casingTransformer = vertices -> {
            Vector3f[] ret = new Vector3f[((Vector3f[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vector3f(vertices[i].x, vertices[i].y - 0.25f, vertices[i].z - 0.625f - extend);
            }
            return ret;
        };
        baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0625f, 0.375f, 0.625f), new Vector3f(0.1875f, 1.0f, 1.0f), matrix, facing, casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.8125f, 0.375f, 0.625f), new Vector3f(0.9375f, 1.0f, 1.0f), matrix, facing, casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.1875f, 0.875f, 0.625f), new Vector3f(0.8125f, 1.0f, 1.0f), matrix, facing, casingTransformer, getCasingSprite, colour));
        if (tile != null && extend > 0.0f) {
            TextureAtlasSprite tex_conveyor = ClientUtils.getSprite(this.isActive(tile) ? ConveyorBasic.texture_on : ConveyorBasic.texture_off);
            Vector3f[] getExtensionSprite = enumFacing -> enumFacing.func_176740_k() == EnumFacing.Axis.Y ? null : (enumFacing.func_176740_k() == EnumFacing.Axis.Z ? texture_steel : texture_casing);
            Vector3f[] vertices2 = new Vector3f[]{new Vector3f(0.0625f, 0.0f, -extend), new Vector3f(0.0625f, 0.0f, 0.0f), new Vector3f(0.9375f, 0.0f, 0.0f), new Vector3f(0.9375f, 0.0f, -extend)};
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(EnumFacing.DOWN, facing), tex_conveyor, new double[]{15.0, extend * 16.0f, 1.0, 0.0}, colour, true));
            for (Vector3f vec : vertices2) {
                vec.setY(0.125f);
            }
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices2), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), tex_conveyor, new double[]{15.0, (1.0f - extend) * 16.0f, 1.0, 16.0}, colour, false));
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0625f, 0.25f, 0.625f), new Vector3f(0.9375f, 0.375f, 0.625f + extend), matrix, facing, casingTransformer, (Function<EnumFacing, TextureAtlasSprite>)getExtensionSprite, colour));
        }
        Vector3f[] vertices3 = new Vector3f[]{new Vector3f(0.8125f, 0.625f, 0.03125f), new Vector3f(0.8125f, 0.125f, 0.03125f), new Vector3f(0.1875f, 0.125f, 0.03125f), new Vector3f(0.1875f, 0.625f, 0.03125f)};
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(EnumFacing.NORTH, facing), texture_assembler, new double[]{15.25, 13.25, 12.75, 15.25}, colour, false));
        for (Vector3f vec : vertices3) {
            vec.setZ(0.0625f);
        }
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(EnumFacing.SOUTH, facing), texture_assembler, new double[]{12.75, 13.25, 15.25, 15.25}, colour, true));
        for (int i = 0; i < 5; ++i) {
            float off = (float)i * 0.125f;
            baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.203125f + off, 0.1875f, 0.09375f), new Vector3f(0.296875f + off, 0.625f, 0.125f), matrix, facing, vertexTransformer, facing1 -> texture_curtain, colour));
        }
        return baseModel;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = super.getModelCacheKey(tile, facing);
        key = key + "e" + this.extractDirection.ordinal();
        key = key + "ex" + this.getExtensionIntoBlock(tile);
        return key;
    }

    @Override
    public boolean renderWall(TileEntity tile, EnumFacing facing, int wall) {
        EnumFacing side = wall == 0 ? facing.func_176735_f() : facing.func_176746_e();
        return side != this.extractDirection && super.renderWall(tile, facing, wall);
    }

    private float getExtensionIntoBlock(TileEntity tile) {
        BlockPos neighbour;
        float extend = 0.0f;
        if (tile == null || !tile.func_145830_o()) {
            return extend;
        }
        World world = tile.func_145831_w();
        if (!world.func_175623_d(neighbour = tile.func_174877_v().func_177972_a(this.extractDirection))) {
            IBlockState connected = world.func_180495_p(neighbour);
            TileEntity connectedTile = world.func_175625_s(neighbour);
            if (connectedTile != null && connectedTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.extractDirection.func_176734_d()) && connected.func_193401_d((IBlockAccess)world, neighbour, this.extractDirection.func_176734_d()) != BlockFaceShape.SOLID) {
                AxisAlignedBB aabb = connected.func_185900_c((IBlockAccess)world, neighbour);
                switch (this.extractDirection) {
                    case NORTH: {
                        extend = (float)(1.0 - aabb.field_72334_f);
                        break;
                    }
                    case SOUTH: {
                        extend = (float)aabb.field_72339_c;
                        break;
                    }
                    case WEST: {
                        extend = (float)(1.0 - aabb.field_72336_d);
                        break;
                    }
                    case EAST: {
                        extend = (float)aabb.field_72340_a;
                    }
                }
                if (extend > 0.25f) {
                    return 0.25f;
                }
                float round = extend % 0.0625f;
                if (round < extend) {
                    extend = round + 0.0625f;
                }
            }
        }
        return extend;
    }

    @Override
    public boolean isActive(TileEntity tile) {
        return true;
    }

    private boolean isPowered(TileEntity tile) {
        return tile.func_145831_w().func_175687_A(tile.func_174877_v()) > 0;
    }

    @Override
    public boolean isTicking(TileEntity tile) {
        return true;
    }

    @Override
    public void onUpdate(TileEntity tile, EnumFacing facing) {
        if (!tile.func_145831_w().field_72995_K) {
            TileEntity neighbourTile;
            BlockPos neighbour;
            World world;
            if (this.transferCooldown > 0) {
                --this.transferCooldown;
            }
            if (!this.isPowered(tile) && this.transferCooldown <= 0 && !(world = tile.func_145831_w()).func_175623_d(neighbour = tile.func_174877_v().func_177972_a(this.extractDirection)) && (neighbourTile = world.func_175625_s(neighbour)) != null && neighbourTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.extractDirection.func_176734_d())) {
                IItemHandler itemHandler = (IItemHandler)neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.extractDirection.func_176734_d());
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, 1, true);
                    if (extractItem.func_190926_b()) continue;
                    extractItem = itemHandler.extractItem(i, 1, false);
                    EntityItem entity = new EntityItem(world, (double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.1875, (double)tile.func_174877_v().func_177952_p() + 0.5, extractItem);
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.0;
                    entity.field_70179_y = 0.0;
                    world.func_72838_d((Entity)entity);
                    this.onItemDeployed(tile, entity, facing);
                    this.transferCooldown = this.transferTickrate;
                    return;
                }
            }
        }
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (Utils.isHammer(heldItem) && player.func_70093_af()) {
            EnumFacing dir = this.extractDirection.func_176746_e();
            if (dir == ((ConveyorHandler.IConveyorTile)tile).getFacing()) {
                dir = dir.func_176746_e();
            }
            this.extractDirection = dir;
            return true;
        }
        if (Utils.isWirecutter(heldItem)) {
            if (this.transferTickrate == 4) {
                this.transferTickrate = 8;
            } else if (this.transferTickrate == 8) {
                this.transferTickrate = 16;
            } else if (this.transferTickrate == 16) {
                this.transferTickrate = 20;
            } else if (this.transferTickrate == 20) {
                this.transferTickrate = 4;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.tickrate", new Object[]{this.transferTickrate}), true);
            return true;
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        return list;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        if (this.extension < 0.0f) {
            this.extension = this.getExtensionIntoBlock(tile);
        }
        switch (this.extractDirection) {
            case NORTH: {
                list.add(new AxisAlignedBB(0.0625, 0.125, (double)(-this.extension), 0.9375, 0.75, 0.375 - (double)this.extension));
                break;
            }
            case SOUTH: {
                list.add(new AxisAlignedBB(0.0625, 0.125, 0.625 + (double)this.extension, 0.9375, 0.75, (double)(1.0f + this.extension)));
                break;
            }
            case WEST: {
                list.add(new AxisAlignedBB((double)(-this.extension), 0.125, 0.0625, 0.375 - (double)this.extension, 0.75, 0.9375));
                break;
            }
            case EAST: {
                list.add(new AxisAlignedBB(0.625 + (double)this.extension, 0.125, 0.0625, (double)(1.0f + this.extension), 0.75, 0.9375));
            }
        }
        return list;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        nbt.func_74768_a("extractDirection", this.extractDirection.ordinal());
        nbt.func_74768_a("transferCooldown", this.transferCooldown);
        nbt.func_74768_a("transferTickrate", this.transferTickrate);
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.extractDirection = EnumFacing.values()[nbt.func_74762_e("extractDirection")];
        this.transferCooldown = nbt.func_74762_e("transferCooldown");
        this.transferTickrate = nbt.func_74762_e("transferTickrate");
    }
}

