/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTileSync
implements IMessage {
    BlockPos pos;
    NBTTagCompound nbt;

    public MessageTileSync(TileEntityIEBase tile, NBTTagCompound nbt) {
        this.pos = tile.func_174877_v();
        this.nbt = nbt;
    }

    public MessageTileSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n()).writeInt(this.pos.func_177956_o()).writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageTileSync, IMessage> {
        public IMessage onMessage(MessageTileSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tile;
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (tile = world.func_175625_s(message.pos)) instanceof TileEntityIEBase) {
                    ((TileEntityIEBase)tile).receiveMessageFromServer(message.nbt);
                }
            });
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageTileSync, IMessage> {
        public IMessage onMessage(MessageTileSync message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                TileEntity tile;
                if (world.func_175667_e(message.pos) && (tile = world.func_175625_s(message.pos)) instanceof TileEntityIEBase) {
                    ((TileEntityIEBase)tile).receiveMessageFromClient(message.nbt);
                }
            });
            return null;
        }
    }
}

