/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;

public class BoxLayout
extends Widget {
    private Direction direction;
    private int spacing;
    private boolean scroll;
    private Alignment alignment = Alignment.TOP;

    public BoxLayout() {
        this(Direction.HORIZONTAL);
    }

    public BoxLayout(Direction direction) {
        this.direction = direction;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (this.spacing != spacing) {
            this.spacing = spacing;
            this.invalidateLayout();
        }
    }

    public boolean isScroll() {
        return this.scroll;
    }

    public void setScroll(boolean scroll) {
        if (this.scroll != scroll) {
            this.scroll = scroll;
            this.invalidateLayout();
        }
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (this.alignment != alignment) {
            this.alignment = alignment;
            this.invalidateLayout();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        if (this.direction != direction) {
            this.direction = direction;
            this.invalidateLayout();
        }
    }

    @Override
    public int getMinWidth() {
        int minWidth = this.direction == Direction.HORIZONTAL ? BoxLayout.computeMinWidthHorizontal(this, this.spacing) : BoxLayout.computeMinWidthVertical(this);
        return Math.max(super.getMinWidth(), minWidth + this.getBorderHorizontal());
    }

    @Override
    public int getMinHeight() {
        int minHeight = this.direction == Direction.HORIZONTAL ? BoxLayout.computeMinHeightHorizontal(this) : BoxLayout.computeMinHeightVertical(this, this.spacing);
        return Math.max(super.getMinHeight(), minHeight + this.getBorderVertical());
    }

    @Override
    public int getPreferredInnerWidth() {
        return this.direction == Direction.HORIZONTAL ? BoxLayout.computePreferredWidthHorizontal(this, this.spacing) : BoxLayout.computePreferredWidthVertical(this);
    }

    @Override
    public int getPreferredInnerHeight() {
        return this.direction == Direction.HORIZONTAL ? BoxLayout.computePreferredHeightHorizontal(this) : BoxLayout.computePreferredHeightVertical(this, this.spacing);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.setSpacing(themeInfo.getParameter("spacing", 0));
        this.setAlignment(themeInfo.getParameter("alignment", Alignment.TOP));
    }

    public static int computeMinWidthHorizontal(Widget container, int spacing) {
        int n = container.getNumChildren();
        int minWidth = Math.max(0, n - 1) * spacing;
        for (int i = 0; i < n; ++i) {
            minWidth += container.getChild(i).getMinWidth();
        }
        return minWidth;
    }

    public static int computeMinHeightHorizontal(Widget container) {
        int n = container.getNumChildren();
        int minHeight = 0;
        for (int i = 0; i < n; ++i) {
            minHeight = Math.max(minHeight, container.getChild(i).getMinHeight());
        }
        return minHeight;
    }

    public static int computePreferredWidthHorizontal(Widget container, int spacing) {
        int n = container.getNumChildren();
        int prefWidth = Math.max(0, n - 1) * spacing;
        for (int i = 0; i < n; ++i) {
            prefWidth += BoxLayout.getPrefChildWidth(container.getChild(i));
        }
        return prefWidth;
    }

    public static int computePreferredHeightHorizontal(Widget container) {
        int n = container.getNumChildren();
        int prefHeight = 0;
        for (int i = 0; i < n; ++i) {
            prefHeight = Math.max(prefHeight, BoxLayout.getPrefChildHeight(container.getChild(i)));
        }
        return prefHeight;
    }

    public static int computeMinWidthVertical(Widget container) {
        int n = container.getNumChildren();
        int minWidth = 0;
        for (int i = 0; i < n; ++i) {
            minWidth = Math.max(minWidth, container.getChild(i).getMinWidth());
        }
        return minWidth;
    }

    public static int computeMinHeightVertical(Widget container, int spacing) {
        int n = container.getNumChildren();
        int minHeight = Math.max(0, n - 1) * spacing;
        for (int i = 0; i < n; ++i) {
            minHeight += container.getChild(i).getMinHeight();
        }
        return minHeight;
    }

    public static int computePreferredWidthVertical(Widget container) {
        int n = container.getNumChildren();
        int prefWidth = 0;
        for (int i = 0; i < n; ++i) {
            prefWidth = Math.max(prefWidth, BoxLayout.getPrefChildWidth(container.getChild(i)));
        }
        return prefWidth;
    }

    public static int computePreferredHeightVertical(Widget container, int spacing) {
        int n = container.getNumChildren();
        int prefHeight = Math.max(0, n - 1) * spacing;
        for (int i = 0; i < n; ++i) {
            prefHeight += BoxLayout.getPrefChildHeight(container.getChild(i));
        }
        return prefHeight;
    }

    public static void layoutHorizontal(Widget container, int spacing, Alignment alignment, boolean scroll) {
        int width;
        int numChildren = container.getNumChildren();
        int height = container.getInnerHeight();
        int x = container.getInnerX();
        int y = container.getInnerY();
        if (scroll && (width = BoxLayout.computePreferredWidthHorizontal(container, spacing)) > container.getInnerWidth()) {
            x -= width - container.getInnerWidth();
        }
        for (int idx = 0; idx < numChildren; ++idx) {
            Widget child = container.getChild(idx);
            int childWidth = BoxLayout.getPrefChildWidth(child);
            int childHeight = alignment == Alignment.FILL ? height : BoxLayout.getPrefChildHeight(child);
            int yoff = (height - childHeight) * alignment.vpos / 2;
            child.setSize(childWidth, childHeight);
            child.setPosition(x, y + yoff);
            x += childWidth + spacing;
        }
    }

    public static void layoutVertical(Widget container, int spacing, Alignment alignment, boolean scroll) {
        int height;
        int numChildren = container.getNumChildren();
        int width = container.getInnerWidth();
        int x = container.getInnerX();
        int y = container.getInnerY();
        if (scroll && (height = BoxLayout.computePreferredHeightVertical(container, spacing)) > container.getInnerHeight()) {
            x -= height - container.getInnerHeight();
        }
        for (int idx = 0; idx < numChildren; ++idx) {
            Widget child = container.getChild(idx);
            int childWidth = alignment == Alignment.FILL ? width : BoxLayout.getPrefChildWidth(child);
            int childHeight = BoxLayout.getPrefChildHeight(child);
            int xoff = (width - childWidth) * alignment.hpos / 2;
            child.setSize(childWidth, childHeight);
            child.setPosition(x + xoff, y);
            y += childHeight + spacing;
        }
    }

    @Override
    protected void layout() {
        if (this.getNumChildren() > 0) {
            if (this.direction == Direction.HORIZONTAL) {
                BoxLayout.layoutHorizontal(this, this.spacing, this.alignment, this.scroll);
            } else {
                BoxLayout.layoutVertical(this, this.spacing, this.alignment, this.scroll);
            }
        }
    }

    private static int getPrefChildWidth(Widget child) {
        return BoxLayout.computeSize(child.getMinWidth(), child.getPreferredWidth(), child.getMaxWidth());
    }

    private static int getPrefChildHeight(Widget child) {
        return BoxLayout.computeSize(child.getMinHeight(), child.getPreferredHeight(), child.getMaxHeight());
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

