/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.SupportsDrawRepeat;
import de.matthiasmann.twl.theme.HasBorder;

class RepeatImage
implements Image,
HasBorder,
SupportsDrawRepeat {
    private final Image base;
    private final Border border;
    private final boolean repeatX;
    private final boolean repeatY;
    private final SupportsDrawRepeat sdr;

    RepeatImage(Image base, Border border, boolean repeatX, boolean repeatY) {
        assert (repeatX || repeatY);
        this.base = base;
        this.border = border;
        this.repeatX = repeatX;
        this.repeatY = repeatY;
        this.sdr = base instanceof SupportsDrawRepeat ? (SupportsDrawRepeat)((Object)base) : this;
    }

    @Override
    public int getWidth() {
        return this.base.getWidth();
    }

    @Override
    public int getHeight() {
        return this.base.getHeight();
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.base.draw(as, x, y);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height) {
        int countX = this.repeatX ? Math.max(1, width / this.base.getWidth()) : 1;
        int countY = this.repeatY ? Math.max(1, height / this.base.getHeight()) : 1;
        this.sdr.draw(as, x, y, width, height, countX, countY);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height, int repeatCountX, int repeatCountY) {
        while (repeatCountY > 0) {
            int rowHeight = height / repeatCountY;
            int cx = 0;
            int xi = 0;
            while (xi < repeatCountX) {
                int nx = ++xi * width / repeatCountX;
                this.base.draw(as, x + cx, y, nx - cx, rowHeight);
                cx = nx;
            }
            y += rowHeight;
            height -= rowHeight;
            --repeatCountY;
        }
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Image createTintedVersion(Color color) {
        return new RepeatImage(this.base.createTintedVersion(color), this.border, this.repeatX, this.repeatY);
    }
}

