/*
 * Decompiled with CFR 0.152.
 */
package drzhark.guiapi.setting;

import drzhark.guiapi.ModSettings;
import drzhark.guiapi.setting.Setting;

public class SettingMulti
extends Setting<Integer> {
    public String[] labelValues;

    public SettingMulti(String title, int defValue, String ... labelValues) {
        if (labelValues.length == 0) {
            return;
        }
        this.values.put("", defValue);
        this.defaultValue = defValue;
        this.labelValues = labelValues;
        this.backendName = title;
    }

    public SettingMulti(String title, String ... labelValues) {
        this(title, 0, labelValues);
    }

    @Override
    public void fromString(String s, String context) {
        int x = -1;
        for (int i = 0; i < this.labelValues.length; ++i) {
            if (!this.labelValues[i].equals(s)) continue;
            x = i;
        }
        if (x != -1) {
            this.values.put(context, x);
        } else {
            this.values.put(context, new Float(s).intValue());
        }
        ModSettings.dbgout("fromstring multi " + s);
        if (this.displayWidget != null) {
            this.displayWidget.update();
        }
    }

    @Override
    public Integer get(String context) {
        if (this.values.get(context) != null) {
            return (Integer)this.values.get(context);
        }
        if (this.values.get("") != null) {
            return (Integer)this.values.get("");
        }
        return (Integer)this.defaultValue;
    }

    public String getLabel() {
        return this.labelValues[(Integer)this.get()];
    }

    public String getLabel(String context) {
        return this.labelValues[this.get(context)];
    }

    public void next() {
        this.next(ModSettings.currentContext);
    }

    public void next(String context) {
        int tempvalue;
        for (tempvalue = this.get(context) + 1; tempvalue >= this.labelValues.length; tempvalue -= this.labelValues.length) {
        }
        this.set(tempvalue, context);
    }

    @Override
    public void set(Integer v, String context) {
        this.values.put(context, v);
        if (this.parent != null) {
            this.parent.save(context);
        }
        if (this.displayWidget != null) {
            this.displayWidget.update();
        }
    }

    @Override
    public void set(String v) {
        this.set(v, ModSettings.currentContext);
    }

    @Override
    public void set(String v, String context) {
        int x = -1;
        for (int i = 0; i < this.labelValues.length; ++i) {
            if (!this.labelValues[i].equals(v)) continue;
            x = i;
        }
        if (x != -1) {
            this.set(x, context);
        }
    }

    @Override
    public String toString(String context) {
        return this.labelValues[this.get(context)];
    }
}

