/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens.popup;

import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class YesNoPopup
extends Popup {
    private List<String> text;
    private AdvancedButton confirmButton;
    private AdvancedButton cancelButton;
    private int width;
    private Color color = new Color(76, 0, 128);
    private Consumer<Boolean> callback;

    public YesNoPopup(int width, @Nullable Color color, int backgroundAlpha, @Nullable Consumer<Boolean> callback, String ... text) {
        super(backgroundAlpha);
        this.setNotificationText(text);
        this.width = width;
        this.confirmButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.yesno.confirm", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(true);
            }
        });
        this.addButton(this.confirmButton);
        this.cancelButton = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.yesno.cancel", new String[0]), true, press -> {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(false);
            }
        });
        this.addButton(this.cancelButton);
        if (color != null) {
            this.color = color;
        }
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    @Override
    public void render(int mouseX, int mouseY, GuiScreen renderIn) {
        super.render(mouseX, mouseY, renderIn);
        if (this.isDisplayed()) {
            int i;
            int height = 50;
            for (i = 0; i < this.text.size(); ++i) {
                height += 10;
            }
            GlStateManager.func_179147_l();
            Gui.func_73734_a((int)(renderIn.field_146294_l / 2 - this.width / 2), (int)(renderIn.field_146295_m / 2 - height / 2), (int)(renderIn.field_146294_l / 2 + this.width / 2), (int)(renderIn.field_146295_m / 2 + height / 2), (int)this.color.getRGB());
            GlStateManager.func_179084_k();
            i = 0;
            for (String s : this.text) {
                renderIn.func_73732_a(Minecraft.func_71410_x().field_71466_p, s, renderIn.field_146294_l / 2, renderIn.field_146295_m / 2 - height / 2 + 10 + i, Color.WHITE.getRGB());
                i += 10;
            }
            this.confirmButton.field_146128_h = renderIn.field_146294_l / 2 - this.confirmButton.field_146120_f - 20;
            this.confirmButton.field_146129_i = renderIn.field_146295_m / 2 + height / 2 - this.confirmButton.field_146121_g - 5;
            this.cancelButton.field_146128_h = renderIn.field_146294_l / 2 + 20;
            this.cancelButton.field_146129_i = renderIn.field_146295_m / 2 + height / 2 - this.cancelButton.field_146121_g - 5;
            this.renderButtons(mouseX, mouseY);
        }
    }

    public void setNotificationText(String ... text) {
        if (text != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String s : text) {
                if (s.contains("%n%")) {
                    for (String s2 : s.split("%n%")) {
                        l.add(s2);
                    }
                    continue;
                }
                l.add(s);
            }
            this.text = l;
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 28 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(true);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 1 && this.isDisplayed()) {
            this.setDisplayed(false);
            if (this.callback != null) {
                this.callback.accept(false);
            }
        }
    }
}

