/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.model.ModelAmulet;
import artifacts.common.init.ModItems;
import artifacts.common.item.BaubleBase;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.render.IRenderBauble;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BaubleAmulet
extends BaubleBase
implements IRenderBauble {
    protected ModelBase model = new ModelAmulet();
    protected ResourceLocation textures;

    public BaubleAmulet(String name, ResourceLocation textures) {
        super(name, BaubleType.AMULET);
        this.textures = textures;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && event.getAmount() >= 1.0f) {
            Random random;
            EntityLiving attacker;
            boolean hasUltimatePendant;
            if (BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.PANIC_NECKLACE) != -1) {
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76424_c, 70, 1, true, false));
            }
            boolean bl = hasUltimatePendant = BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.ULTIMATE_PENDANT) != -1;
            if (hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.SHOCK_PENDANT) != -1) {
                if (event.getSource() == DamageSource.field_180137_b) {
                    event.setCanceled(true);
                } else if (event.getSource().func_76346_g() instanceof EntityLiving) {
                    attacker = (EntityLiving)event.getSource().func_76346_g();
                    random = ((EntityPlayer)event.getEntity()).func_70681_au();
                    if (attacker.field_70170_p.func_175678_i(attacker.func_180425_c()) && random.nextFloat() < 0.15f) {
                        attacker.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(attacker.field_70170_p, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, false));
                    }
                }
            }
            if ((hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.FLAME_PENDANT) != -1) && event.getSource().func_76346_g() instanceof EntityLiving) {
                attacker = (EntityLiving)event.getSource().func_76346_g();
                random = ((EntityPlayer)event.getEntity()).func_70681_au();
                if (!attacker.func_70045_F() && attacker.func_190631_cK() && random.nextFloat() < 0.3f) {
                    attacker.func_70015_d(4);
                    attacker.func_70097_a(new EntityDamageSource("onFire", event.getEntity()).func_76361_j(), 2.0f);
                }
            }
            if ((hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.THORN_PENDANT) != -1) && event.getSource().func_76346_g() instanceof EntityLiving) {
                attacker = (EntityLiving)event.getSource().func_76346_g();
                random = ((EntityPlayer)event.getEntity()).func_70681_au();
                if (attacker.func_190631_cK() && random.nextFloat() < 0.45f) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntity()), (float)(1 + random.nextInt(4)));
                }
            }
        }
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType == IRenderBauble.RenderType.BODY) {
            GlStateManager.func_179145_e();
            GlStateManager.func_179091_B();
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textures);
            this.model.func_78088_a((Entity)player, 0.0f, 0.0f, (float)player.field_70173_aa + partialTicks, 0.0f, 0.0f, 0.0625f);
        }
    }

    public BaubleAmulet setModel(ModelBase model) {
        this.model = model;
        return this;
    }
}

