/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import com.mrcrayfish.guns.item.GunRegistry;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.object.ServerGun;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

@Config(modid="cgm")
@Config.LangKey(value="config.cgm.title")
@Mod.EventBusSubscriber(modid="cgm")
public class GunConfig {
    @Config.Ignore
    public static final String PREFIX = "config.cgm.";
    @Config.Name(value="Client")
    @Config.Comment(value={"Client-only configs."})
    @Config.LangKey(value="config.cgm.client")
    public static final Client CLIENT = new Client();
    @Config.Name(value="Server")
    @Config.Comment(value={"Server-only configs."})
    @Config.LangKey(value="config.cgm.server")
    public static final Server SERVER = new Server();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("cgm")) {
            ConfigManager.sync((String)"cgm", (Config.Type)Config.Type.INSTANCE);
            GunConfig.SERVER.aggroMobs.setExemptionClasses();
        }
    }

    public static class SyncedData {
        private ImmutableMap<ResourceLocation, ServerGun> serverGunMap;
        private int blindnessAlphaOverlay;
        private int alphaFadeThreshold;
        private int soundFadeThreshold;
        private float soundPercentage;
        private float ringVolume;

        public void toBytes(ByteBuf buffer) {
            Map<ResourceLocation, ItemGun> guns = GunRegistry.getInstance().getGuns();
            buffer.writeInt(guns.size());
            guns.forEach((location, gun) -> {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)location.toString());
                buffer.writeFloat(gun.getGun().projectile.damage);
                buffer.writeInt(gun.getGun().general.maxAmmo);
            });
            buffer.writeInt(GunConfig.SERVER.stunGrenades.blind.alphaOverlay);
            buffer.writeInt(GunConfig.SERVER.stunGrenades.blind.alphaFadeThreshold);
            buffer.writeFloat((float)GunConfig.SERVER.stunGrenades.deafen.soundPercentage);
            buffer.writeInt(GunConfig.SERVER.stunGrenades.deafen.soundFadeThreshold);
            buffer.writeFloat((float)GunConfig.SERVER.stunGrenades.deafen.ringVolume);
        }

        public void fromBytes(ByteBuf buffer) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                ServerGun gun = new ServerGun();
                gun.damage = buffer.readFloat();
                gun.maxAmmo = buffer.readInt();
                builder.put((Object)id, (Object)gun);
            }
            this.serverGunMap = builder.build();
            this.blindnessAlphaOverlay = buffer.readInt();
            this.alphaFadeThreshold = buffer.readInt();
            this.soundPercentage = buffer.readFloat();
            this.soundFadeThreshold = buffer.readInt();
            this.ringVolume = buffer.readFloat();
        }

        public void syncClientToServer() {
            this.serverGunMap.forEach((id, serverGun) -> {
                ItemGun gun = GunRegistry.getInstance().getGun((ResourceLocation)id);
                if (gun != null) {
                    gun.getGun().serverGun = serverGun;
                }
            });
            GunConfig.SERVER.stunGrenades.blind.alphaOverlaySynced = this.blindnessAlphaOverlay;
            GunConfig.SERVER.stunGrenades.blind.alphaFadeThresholdSynced = this.alphaFadeThreshold;
            GunConfig.SERVER.stunGrenades.deafen.soundPercentageSynced = this.soundPercentage;
            GunConfig.SERVER.stunGrenades.deafen.soundFadeThresholdSynced = this.soundFadeThreshold;
            GunConfig.SERVER.stunGrenades.deafen.ringVolumeSynced = this.ringVolume;
        }
    }

    public static class ProjectileSpread {
        private static final String PREFIX = "config.cgm.server.projectile_spread";
        @Config.Name(value="Spread Threshold")
        @Config.Comment(value={"The amount of time in milliseconds before logic to apply spread is skipped. The value indicates a reasonable amount of time before a weapon is considered stable again."})
        @Config.LangKey(value="config.cgm.server.projectile_spread.spread_threshold")
        @Config.RangeInt(min=0, max=1000)
        public int spreadThreshold = 300;
        @Config.Name(value="Max Count")
        @Config.Comment(value={"The amount of times a player has too shoot within the spread threshold before the maximum amount of spread is applied. Setting the value higher means it will take longer for the spread to be applied."})
        @Config.LangKey(value="config.cgm.server.projectile_spread.max_count")
        @Config.RangeInt(min=1)
        public int maxCount = 10;
    }

    public static class EffectCriteria {
        private static final String PREFIX = "config.cgm.server.grenade.stun.effect_criteria";
        @Config.Name(value="Radius")
        @Config.Comment(value={"Grenade must be no more than this many meters away to have an effect."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.radius")
        @Config.RangeDouble(min=0.0)
        public double radius;
        @Config.Name(value="Max Duration")
        @Config.Comment(value={"Effect will have this duration (in ticks) if the grenade is directly at the player's eyes while looking directly at it."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.duration.max")
        @Config.RangeInt(min=0)
        public int durationMax;
        @Config.Name(value="Min Duration By Distance")
        @Config.Comment(value={"Effect will have this duration (in ticks) if the grenade is the maximum distance from the player's eyes while looking directly at it."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.duration.min")
        @Config.RangeInt(min=0)
        public int durationMin;
        @Config.Name(value="Angle Of Effect")
        @Config.Comment(value={"Angle between the eye/looking direction and the eye/grenade direction must be no more than half this many degrees to have an effect."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.angle.effect")
        @Config.RangeDouble(min=0.0, max=360.0)
        public double angleEffect;
        @Config.Name(value="Max Attenuation By Angle")
        @Config.Comment(value={"After duration is attenuated by distance, it will be further attenuated depending on the angle (in degrees) between the eye/looking direction and the eye/grenade direction. This is done by multiplying it by 1 (no attenuation) if the angle is 0; and by this value if the angle is the maximum within the angle of effect."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.angle.attenuation.max")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double angleAttenuationMax;
        @Config.Name(value="Raytrace Opaque Blocks")
        @Config.Comment(value={"If true, the effect is only applied if the line between the eyes and the grenade does not intersect any non-liquid blocks with an opacity greater than 0."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.raytrace.opaque")
        public boolean raytraceOpaqueBlocks;

        public EffectCriteria(double radius, int durationMax, int durationMin, double angleEffect, double angleAttenuationMax, boolean raytraceOpaqueBlocks) {
            this.radius = radius;
            this.durationMax = durationMax;
            this.durationMin = durationMin;
            this.angleEffect = angleEffect;
            this.angleAttenuationMax = angleAttenuationMax;
            this.raytraceOpaqueBlocks = raytraceOpaqueBlocks;
        }
    }

    public static class Deafen {
        private static final String PREFIX = "config.cgm.server.grenade.stun.deafen";
        @Config.Name(value="Effect Criteria")
        @Config.Comment(value={"Criteria that determines the presence/absence and duration of the deafening effect."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.deafen")
        public EffectCriteria criteria = new EffectCriteria(15.0, 280, 100, 360.0, 0.75, false);
        @Config.Name(value="Sound Percentage")
        @Config.Comment(value={"Volume of most game sounds when deafened will play at this percent, before eventually fading back to %100."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.deafen.sound.percentage")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresWorldRestart
        public double soundPercentage = 0.05;
        public float soundPercentageSynced = 0.0f;
        @Config.Name(value="Sound Fade Threshold")
        @Config.Comment(value={"After the duration drops to this many ticks, the ringing volume will gradually fade to 0 and other sound volumes will fade back to %100."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.deafen.sound.fade")
        @Config.RangeInt(min=0)
        @Config.RequiresWorldRestart
        public int soundFadeThreshold = 90;
        public int soundFadeThresholdSynced = Integer.MAX_VALUE;
        @Config.Name(value="Ring Volume")
        @Config.Comment(value={"Volume of the ringing sound when deafened will play at this volume, before eventually fading to 0."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.deafen.sound.ring")
        @Config.RangeDouble(min=0.0)
        @Config.RequiresWorldRestart
        public double ringVolume = 1.0;
        public float ringVolumeSynced = 1.0f;
    }

    public static class Blind {
        private static final String PREFIX = "config.cgm.server.grenade.stun.blind";
        @Config.Name(value="Effect Criteria")
        @Config.Comment(value={"Criteria that determines the presence/absence and duration of the blinding effect."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.effect_criteria.blind")
        public EffectCriteria criteria = new EffectCriteria(15.0, 220, 10, 170.0, 0.75, true);
        @Config.Name(value="Overlay Alpha")
        @Config.Comment(value={"After the duration drops to this many ticks, the transparency of the overlay when blinded will gradually fade to 0 alpha."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.blind.overlay.alpha")
        @Config.RangeInt(min=0, max=255)
        @Config.RequiresWorldRestart
        public int alphaOverlay = 255;
        public int alphaOverlaySynced = 255;
        @Config.Name(value="Overlay Fade Threshold")
        @Config.Comment(value={"Transparency of the overlay when blinded will be this alpha value, before eventually fading to 0 alpha."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.blind.overlay.fade")
        @Config.RangeInt(min=0)
        @Config.RequiresWorldRestart
        public int alphaFadeThreshold = 40;
        public int alphaFadeThresholdSynced = Integer.MAX_VALUE;
    }

    public static class StunGrenades {
        private static final String PREFIX = "config.cgm.server.grenade.stun";
        @Config.Name(value="Blind")
        @Config.Comment(value={"Blinding properties of stun grenades."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.blind")
        public Blind blind = new Blind();
        @Config.Name(value="Deafen")
        @Config.Comment(value={"Deafening properties of stun grenades."})
        @Config.LangKey(value="config.cgm.server.grenade.stun.deafen")
        public Deafen deafen = new Deafen();
    }

    public static class Grenades {
        private static final String PREFIX = "config.cgm.server.grenade.normal";
        @Config.Name(value="Explosion Radius")
        @Config.Comment(value={"The max distance which the explosion is effective to."})
        @Config.LangKey(value="config.cgm.server.grenade.normal.explosion_range")
        @Config.RangeDouble(min=0.0)
        public double explosionRadius = 5.0;
    }

    public static class Missiles {
        private static final String PREFIX = "config.cgm.server.missiles.normal";
        @Config.Name(value="Explosion Radius")
        @Config.Comment(value={"The max distance which the explosion is effective to."})
        @Config.LangKey(value="config.cgm.server.missiles.normal.explosion_range")
        @Config.RangeDouble(min=0.0)
        public double explosionRadius = 5.0;
    }

    public static class Controls {
        private static final String PREFIX = "config.cgm.client.controls";
        @Config.Name(value="Use Old Controls")
        @Config.Comment(value={"If true, uses the old controls in order to aim and shoot"})
        @Config.LangKey(value="config.cgm.client.controls.old_controls")
        public boolean oldControls = false;
    }

    public static class Display {
        private static final String PREFIX = "config.cgm.client.display";
        @Config.Name(value="Workbench Animation")
        @Config.Comment(value={"If true, an animation is performed while cycling items in the Workbench"})
        @Config.LangKey(value="config.cgm.client.display.workbench_animation")
        public boolean workbenchAnimation = true;
    }

    public static class AggroMobs {
        private static final String PREFIX = "config.cgm.server.aggro";
        @Config.Name(value="Aggro Mobs Enabled")
        @Config.Comment(value={"If true, nearby mobs are angered and/or scared by the firing of guns."})
        @Config.LangKey(value="config.cgm.server.aggro.enabled")
        public boolean enabled = true;
        @Config.Name(value="Anger Hostile Mobs")
        @Config.Comment(value={"If true, in addition to causing peaceful mobs to panic, firing a gun will also cause nearby hostile mobs to target the shooter."})
        @Config.LangKey(value="config.cgm.server.aggro.hostile")
        public boolean angerHostileMobs = true;
        @Config.Name(value="Range Silenced")
        @Config.Comment(value={"Any mobs within a sphere of this radius will aggro on the shooter of a silenced gun."})
        @Config.LangKey(value="config.cgm.server.aggro.silenced")
        @Config.RangeDouble(min=0.0)
        public double rangeSilenced = 10.0;
        @Config.Name(value="Range Unsilenced")
        @Config.Comment(value={"Any mobs within a sphere of this radius will aggro on the shooter of an unsilenced gun."})
        @Config.LangKey(value="config.cgm.server.aggro.unsilenced")
        @Config.RangeDouble(min=0.0)
        public double rangeUnsilenced = 20.0;
        @Config.Name(value="Exempt Mob Classes")
        @Config.Comment(value={"Any mobs of classes with class paths in this list will not aggro on shooters."})
        @Config.LangKey(value="config.cgm.server.aggro.exempt")
        public String[] exemptClassNames = new String[]{"net.minecraft.entity.passive.EntityVillager"};
        public static Set<Class> exemptClasses = Sets.newHashSet();

        public void setExemptionClasses() {
            exemptClasses.clear();
            for (String className : this.exemptClassNames) {
                String prefix = "Exempt aggro mob class '" + className;
                try {
                    Class<?> classMob = Class.forName(className);
                    if (EntityLivingBase.class.isAssignableFrom(classMob)) {
                        exemptClasses.add(classMob);
                        continue;
                    }
                    MrCrayfishGunMod.logger.warn(prefix + "' must exend EntityLivingBase.");
                }
                catch (ClassNotFoundException e) {
                    MrCrayfishGunMod.logger.warn(prefix + "' was not found:", (Throwable)e);
                }
            }
        }
    }

    public static class Network {
        private static final String PREFIX = "config.cgm.server.network";
        @Config.Name(value="Projectile Tracking Range")
        @Config.Comment(value={"The distance players need to be within to be able to track new projectiles trails. Higher values means you can see projectiles from that start from further away."})
        @Config.LangKey(value="config.cgm.server.network.projectile_tracking_range")
        @Config.RangeDouble(min=0.0)
        public double projectileTrackingRange = 200.0;
    }

    public static class Server {
        private static final String PREFIX = "config.cgm.server";
        @Config.Name(value="Network")
        @Config.Comment(value={"Properties relating to network"})
        @Config.LangKey(value="config.cgm.server.network")
        public Network network = new Network();
        @Config.Name(value="Aggro Mobs")
        @Config.Comment(value={"Nearby mobs are angered and/or scared by the firing of guns."})
        @Config.LangKey(value="config.cgm.server.aggro")
        public AggroMobs aggroMobs = new AggroMobs();
        @Config.Name(value="Missiles")
        @Config.Comment(value={"Properties relating to missiles."})
        @Config.LangKey(value="config.cgm.server.missiles.normal")
        public Missiles missiles = new Missiles();
        @Config.Name(value="Grenades")
        @Config.Comment(value={"Properties relating to grenades."})
        @Config.LangKey(value="config.cgm.server.grenade.normal")
        public Grenades grenades = new Grenades();
        @Config.Name(value="Stun Grenades")
        @Config.Comment(value={"Blinding/deafening properties of stun grenades."})
        @Config.LangKey(value="config.cgm.server.grenade.stun")
        public StunGrenades stunGrenades = new StunGrenades();
        @Config.Name(value="Projectile Spread")
        @Config.Comment(value={"Properties relating to projectile spread"})
        @Config.LangKey(value="config.cgm.server.projectile_spread")
        public ProjectileSpread projectileSpread = new ProjectileSpread();
        @Config.Name(value="Grow Bounding Box")
        @Config.Comment(value={"The extra amount to expand an entity's bounding box when checking for projectile collision. Setting this value higher will make it easier to hit players"})
        @Config.LangKey(value="config.cgm.server.grow_bounding_box")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double growBoundingBoxAmount = 0.3;
        @Config.Name(value="Enable Head Shots")
        @Config.Comment(value={"Enables the check for head shots for players. Projectiles that hit the head of a player will have increased damage."})
        @Config.LangKey(value="config.cgm.server.enabled_head_shots")
        public boolean enableHeadShots = true;
        @Config.Name(value="Head Shot Damage Multiplier")
        @Config.Comment(value={"The value to multiply the damage by if projectile hit the players head"})
        @Config.LangKey(value="config.cgm.server.head_shot_damage_multiplier")
        @Config.RangeDouble(min=1.0)
        public double headShotDamageMultiplier = 1.1;
    }

    public static class Sounds {
        private static final String PREFIX = "config.cgm.client.sounds";
        @Config.Name(value="Play Hit Sound")
        @Config.Comment(value={"If true, a ding sound will play when you successfully hit a player with a gun"})
        @Config.LangKey(value="config.cgm.client.sounds.hit_sound")
        public boolean hitSound = true;
    }

    public static class Client {
        private static final String PREFIX = "config.cgm.client";
        @Config.Name(value="Sounds")
        @Config.Comment(value={"Control sounds triggered by guns"})
        @Config.LangKey(value="config.cgm.client.sounds")
        public Sounds sound = new Sounds();
        @Config.Name(value="Display")
        @Config.Comment(value={"Configuration for display related options"})
        @Config.LangKey(value="config.cgm.client.display")
        public Display display = new Display();
        @Config.Name(value="Controls")
        @Config.Comment(value={"Configuration for control options"})
        @Config.LangKey(value="config.cgm.client.controls")
        public Controls controls = new Controls();
    }
}

