/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilitySkyhookData {
    @CapabilityInject(value=SkyhookUserData.class)
    public static Capability<SkyhookUserData> SKYHOOK_USER_DATA = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(SkyhookUserData.class, (Capability.IStorage)new Capability.IStorage<SkyhookUserData>(){

            public NBTBase writeNBT(Capability<SkyhookUserData> capability, SkyhookUserData instance, EnumFacing side) {
                return new NBTTagInt(instance.status.ordinal());
            }

            public void readNBT(Capability<SkyhookUserData> capability, SkyhookUserData instance, EnumFacing side, NBTBase nbt) {
                instance.status = SkyhookStatus.values()[((NBTTagInt)nbt).func_150287_d()];
            }
        }, SkyhookUserData::new);
    }

    public static enum SkyhookStatus {
        NONE(null, null),
        RIDING(NONE, null),
        HOLDING_CONNECTING(null, NONE),
        HOLDING_FAILED(null, NONE),
        HOLDING_RIDING(HOLDING_FAILED, RIDING);

        @Nullable
        public final SkyhookStatus dismount;
        @Nullable
        public final SkyhookStatus release;
        @Nullable
        public SkyhookStatus mount;

        private SkyhookStatus(SkyhookStatus dismount, SkyhookStatus release) {
            this.dismount = dismount;
            this.release = release;
        }

        static {
            SkyhookStatus.NONE.mount = RIDING;
            SkyhookStatus.HOLDING_CONNECTING.mount = HOLDING_RIDING;
        }
    }

    public static class SimpleSkyhookProvider
    implements ICapabilityProvider {
        SkyhookUserData data = new SkyhookUserData();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == SKYHOOK_USER_DATA && facing == EnumFacing.UP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == SKYHOOK_USER_DATA && facing == EnumFacing.UP) {
                return (T)SKYHOOK_USER_DATA.cast((Object)this.data);
            }
            return null;
        }
    }

    public static class SkyhookUserData {
        private SkyhookStatus status = SkyhookStatus.NONE;
        @Nullable
        public EntitySkylineHook hook = null;

        public void release() {
            if (this.status.release != null) {
                this.status = this.status.release;
            }
        }

        public void dismount() {
            if (this.hook != null) {
                this.hook.func_70106_y();
                this.hook = null;
            }
            if (this.status.dismount != null) {
                this.status = this.status.dismount;
            }
        }

        public SkyhookStatus getStatus() {
            return this.status;
        }

        public void startHolding() {
            this.status = SkyhookStatus.HOLDING_CONNECTING;
        }

        public void startRiding() {
            this.status = this.status.mount;
        }
    }
}

