/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.multilayer;

import blusunrize.immersiveengineering.client.models.ModelData;
import blusunrize.immersiveengineering.client.models.multilayer.BakedMultiLayerModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;

public class MultiLayerModel
implements IModel {
    public static MultiLayerModel INSTANCE = new MultiLayerModel();
    public static final Map<String, BlockRenderLayer> LAYERS_BY_NAME;
    private final Map<BlockRenderLayer, List<ModelData>> subModels;

    public MultiLayerModel(Map<BlockRenderLayer, List<ModelData>> subModels) {
        this.subModels = subModels;
    }

    public MultiLayerModel() {
        this.subModels = ImmutableMap.of();
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return (Collection)this.subModels.values().stream().flatMap(Collection::stream).map(modelData -> {
            modelData.attemptToLoad(false);
            if (modelData.getModel() != null) {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(modelData.getModel().getDependencies());
                ret.add(modelData.location);
                return ret;
            }
            return ImmutableList.of((Object)modelData.location);
        }).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return (Collection)this.subModels.values().stream().flatMap(Collection::stream).map(modelData -> {
            modelData.attemptToLoad(false);
            if (modelData.getModel() != null) {
                return modelData.getModel().getTextures();
            }
            return ImmutableList.of();
        }).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashMap<BlockRenderLayer, List<IBakedModel>> baked = new HashMap<BlockRenderLayer, List<IBakedModel>>();
        for (BlockRenderLayer layer : this.subModels.keySet()) {
            baked.put(layer, (List<IBakedModel>)this.subModels.get(layer).stream().map(modelData -> {
                modelData.attemptToLoad(false);
                assert (modelData.getModel() != null);
                return modelData.getModel().bake(state, format, bakedTextureGetter);
            }).collect(ImmutableList.toImmutableList()));
        }
        return new BakedMultiLayerModel(baked);
    }

    @Nonnull
    public IModel process(ImmutableMap<String, String> customData) {
        HashMap<BlockRenderLayer, List<ModelData>> newSubs = new HashMap<BlockRenderLayer, List<ModelData>>();
        JsonParser parser = new JsonParser();
        HashMap<String, String> unused = new HashMap<String, String>();
        for (String layerStr : customData.keySet()) {
            if (LAYERS_BY_NAME.containsKey(layerStr)) {
                BlockRenderLayer layer = LAYERS_BY_NAME.get(layerStr);
                JsonElement ele = parser.parse((String)customData.get((Object)layerStr));
                if (ele.isJsonObject()) {
                    ModelData data = ModelData.fromJson(ele.getAsJsonObject(), (Collection<String>)ImmutableList.of(), (ImmutableMap<String, String>)ImmutableMap.of());
                    newSubs.put(layer, (List<ModelData>)ImmutableList.of((Object)data));
                    continue;
                }
                if (!ele.isJsonArray()) continue;
                JsonArray array = ele.getAsJsonArray();
                ArrayList<ModelData> models = new ArrayList<ModelData>();
                for (JsonElement subEle : array) {
                    if (!subEle.isJsonObject()) continue;
                    models.add(ModelData.fromJson(ele.getAsJsonObject(), (Collection<String>)ImmutableList.of(), (ImmutableMap<String, String>)ImmutableMap.of()));
                }
                newSubs.put(layer, models);
                continue;
            }
            unused.put(layerStr, (String)customData.get((Object)layerStr));
        }
        JsonObject unusedJson = ModelData.asJsonObject(unused);
        for (Map.Entry entry : newSubs.entrySet()) {
            for (ModelData d : (List)entry.getValue()) {
                for (Map.Entry entryJ : unusedJson.entrySet()) {
                    if (d.data.has((String)entryJ.getKey())) continue;
                    d.data.add((String)entryJ.getKey(), (JsonElement)entryJ.getValue());
                }
            }
        }
        if (!newSubs.equals(this.subModels)) {
            return new MultiLayerModel(newSubs);
        }
        return this;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            builder.put((Object)layer.name(), (Object)layer);
        }
        LAYERS_BY_NAME = builder.build();
    }
}

