/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.client.models.obj.IEOBJModel;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;

public class IEOBJLoader
implements ICustomModelLoader {
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, IEOBJModel> cache = new HashMap<ResourceLocation, IEOBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();
    public static IEOBJLoader instance = new IEOBJLoader();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase(Locale.ENGLISH));
        IELogger.info("Custom OBJLoader: Domain has been added: " + domain.toLowerCase(Locale.ENGLISH));
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj.ie");
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) throws Exception {
        Object model;
        if (!this.cache.containsKey(modelLocation) && (model = OBJLoader.INSTANCE.loadModel(modelLocation)) instanceof OBJModel) {
            IEOBJModel ieobj = new IEOBJModel(((OBJModel)model).getMatLib(), modelLocation);
            this.cache.put(modelLocation, ieobj);
        }
        if ((model = this.cache.get(modelLocation)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        return model;
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }
}

