/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.client.gui.GuiAlloySmelter;
import blusunrize.immersiveengineering.client.gui.GuiArcFurnace;
import blusunrize.immersiveengineering.client.gui.GuiAutoWorkbench;
import blusunrize.immersiveengineering.client.gui.GuiBlastFurnace;
import blusunrize.immersiveengineering.client.gui.GuiCokeOven;
import blusunrize.immersiveengineering.client.gui.GuiFermenter;
import blusunrize.immersiveengineering.client.gui.GuiFluidSorter;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.GuiMixer;
import blusunrize.immersiveengineering.client.gui.GuiModWorkbench;
import blusunrize.immersiveengineering.client.gui.GuiRefinery;
import blusunrize.immersiveengineering.client.gui.GuiSqueezer;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.AssemblerRecipeTransferHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.FluidSorterGhostHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.IEFluidTooltipCallback;
import blusunrize.immersiveengineering.common.util.compat.jei.IEGhostItemHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.alloysmelter.AlloySmelterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace.ArcFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceFuelCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.bottlingmachine.BottlingMachineRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cokeoven.CokeOvenRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.crusher.CrusherRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.fermenter.FermenterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.metalpress.MetalPressRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.mixer.MixerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.refinery.RefineryRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.squeezer.SqueezerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.workbench.WorkbenchRecipeCategory;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIHelper
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IModRegistry modRegistry;
    public static IDrawable slotDrawable;
    public static ITooltipCallback fluidTooltipCallback;
    Map<Class, IERecipeCategory> categories = new LinkedHashMap<Class, IERecipeCategory>();

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a(IEContent.blockConveyor), itemStack -> {
            if (!itemStack.func_190926_b() && ItemNBTHelper.hasKey(itemStack, "conveyorType")) {
                return ItemNBTHelper.getString(itemStack, "conveyorType");
            }
            return "";
        });
        subtypeRegistry.registerSubtypeInterpreter((Item)IEContent.itemBullet, itemStack -> {
            if (!itemStack.func_190926_b() && itemStack.func_77960_j() == 2 && ItemNBTHelper.hasKey(itemStack, "bullet")) {
                return ItemNBTHelper.getString(itemStack, "bullet");
            }
            return "";
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        slotDrawable = guiHelper.getSlotDrawable();
        this.categories.put(CokeOvenRecipe.class, new CokeOvenRecipeCategory(guiHelper));
        this.categories.put(AlloyRecipe.class, new AlloySmelterRecipeCategory(guiHelper));
        this.categories.put(BlastFurnaceRecipe.class, new BlastFurnaceRecipeCategory(guiHelper));
        this.categories.put(BlastFurnaceRecipe.BlastFurnaceFuel.class, new BlastFurnaceFuelCategory(guiHelper));
        this.categories.put(MetalPressRecipe.class, new MetalPressRecipeCategory(guiHelper));
        this.categories.put(CrusherRecipe.class, new CrusherRecipeCategory(guiHelper));
        this.categories.put(BlueprintCraftingRecipe.class, new WorkbenchRecipeCategory(guiHelper));
        this.categories.put(SqueezerRecipe.class, new SqueezerRecipeCategory(guiHelper));
        this.categories.put(FermenterRecipe.class, new FermenterRecipeCategory(guiHelper));
        this.categories.put(RefineryRecipe.class, new RefineryRecipeCategory(guiHelper));
        this.categories.put(ArcFurnaceRecipe.class, ArcFurnaceRecipeCategory.getDefault(guiHelper));
        this.categories.put(ArcRecyclingRecipe.class, ArcFurnaceRecipeCategory.getRecycling(guiHelper));
        this.categories.put(BottlingMachineRecipe.class, new BottlingMachineRecipeCategory(guiHelper));
        this.categories.put(MixerRecipe.class, new MixerRecipeCategory(guiHelper));
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[0]));
    }

    public void register(IModRegistry registryIn) {
        modRegistry = registryIn;
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(IEContent.blockCrop, 1, Short.MAX_VALUE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)IEContent.itemFakeIcons, 1, Short.MAX_VALUE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(IEContent.blockStoneDevice, 1, Short.MAX_VALUE));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(IEContent.blockMetalMultiblock, 1, Short.MAX_VALUE));
        modRegistry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new AssemblerRecipeTransferHandler(), "minecraft.crafting");
        modRegistry.addGhostIngredientHandler(GuiIEContainerBase.class, (IGhostIngredientHandler)new IEGhostItemHandler());
        modRegistry.addGhostIngredientHandler(GuiFluidSorter.class, (IGhostIngredientHandler)new FluidSorterGhostHandler());
        modRegistry.addRecipeCatalyst((Object)new ItemStack(IEContent.blockMetalMultiblock, 1, BlockTypes_MetalMultiblock.ASSEMBLER.getMeta()), new String[]{"minecraft.crafting"});
        for (IERecipeCategory cat : this.categories.values()) {
            cat.addCatalysts(registryIn);
            modRegistry.handleRecipes(cat.getRecipeClass(), (IRecipeWrapperFactory)cat, cat.getRecipeCategoryUid());
        }
        IELogger.info("Adding recipes to JEI!!");
        modRegistry.addRecipes(new ArrayList<CokeOvenRecipe>(CokeOvenRecipe.recipeList), "ie.cokeoven");
        modRegistry.addRecipes(new ArrayList<AlloyRecipe>(AlloyRecipe.recipeList), "ie.alloysmelter");
        modRegistry.addRecipes(new ArrayList<BlastFurnaceRecipe>(BlastFurnaceRecipe.recipeList), "ie.blastfurnace");
        modRegistry.addRecipes(new ArrayList<BlastFurnaceRecipe.BlastFurnaceFuel>(BlastFurnaceRecipe.blastFuels), "ie.blastfurnace.fuel");
        modRegistry.addRecipes(new ArrayList(Collections2.filter((Collection)MetalPressRecipe.recipeList.values(), IJEIRecipe::listInJEI)), "ie.metalPress");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(CrusherRecipe.recipeList, IJEIRecipe::listInJEI)), "ie.crusher");
        modRegistry.addRecipes(new ArrayList(Collections2.filter((Collection)BlueprintCraftingRecipe.recipeList.values(), IJEIRecipe::listInJEI)), "ie.workbench");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(SqueezerRecipe.recipeList, IJEIRecipe::listInJEI)), "ie.squeezer");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(FermenterRecipe.recipeList, IJEIRecipe::listInJEI)), "ie.fermenter");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(RefineryRecipe.recipeList, IJEIRecipe::listInJEI)), "ie.refinery");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(ArcFurnaceRecipe.recipeList, input -> input instanceof ArcRecyclingRecipe && input.listInJEI())), "ie.arcFurnace.recycling");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(ArcFurnaceRecipe.recipeList, input -> !(input instanceof ArcRecyclingRecipe) && input.listInJEI())), "ie.arcFurnace");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(BottlingMachineRecipe.recipeList, input -> input.listInJEI())), "ie.bottlingMachine");
        modRegistry.addRecipes(new ArrayList(Collections2.filter(MixerRecipe.recipeList, input -> input.listInJEI())), "ie.mixer");
        modRegistry.addRecipeClickArea(GuiCokeOven.class, 58, 36, 11, 13, new String[]{"ie.cokeoven"});
        modRegistry.addRecipeClickArea(GuiAlloySmelter.class, 84, 35, 22, 16, new String[]{"ie.alloysmelter"});
        modRegistry.addRecipeClickArea(GuiBlastFurnace.class, 76, 35, 22, 15, new String[]{"ie.blastfurnace", "ie.blastfurnace.fuel"});
        modRegistry.addRecipeClickArea(GuiSqueezer.class, 110, 19, 20, 51, new String[]{"ie.squeezer"});
        modRegistry.addRecipeClickArea(GuiFermenter.class, 110, 19, 20, 51, new String[]{"ie.fermenter"});
        modRegistry.addRecipeClickArea(GuiRefinery.class, 83, 36, 20, 13, new String[]{"ie.refinery"});
        modRegistry.addRecipeClickArea(GuiArcFurnace.class, 81, 38, 23, 35, new String[]{"ie.arcFurnace", "ie.arcFurnace.recycling"});
        modRegistry.addRecipeClickArea(GuiMixer.class, 76, 11, 58, 47, new String[]{"ie.mixer"});
        modRegistry.addRecipeClickArea(GuiModWorkbench.class, 4, 41, 53, 18, new String[]{"ie.workbench"});
        modRegistry.addRecipeClickArea(GuiAutoWorkbench.class, 90, 12, 39, 37, new String[]{"ie.workbench"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    private IERecipeCategory getFactory(Class recipeClass) {
        IERecipeCategory factory = this.categories.get(recipeClass);
        if (factory == null && recipeClass != Object.class) {
            factory = this.getFactory(recipeClass.getSuperclass());
        }
        return factory;
    }

    static {
        fluidTooltipCallback = new IEFluidTooltipCallback();
    }
}

