/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.proxy;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.commands.HistoryCommand;
import de.maxhenkel.corpse.entities.EntityCorpse;
import de.maxhenkel.corpse.events.DeathEvents;
import de.maxhenkel.corpse.gui.GuiHandler;
import de.maxhenkel.corpse.net.MessageDeathInventory;
import de.maxhenkel.corpse.net.MessageOpenHistory;
import de.maxhenkel.corpse.net.MessageRequestDeathHistory;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import de.maxhenkel.corpse.net.MessageSwitchInventoryPage;
import de.maxhenkel.corpse.net.MessageTeleport;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    private static Map<UUID, Death> deathsToShow = new HashMap<UUID, Death>();
    public static SimpleNetworkWrapper simpleNetworkWrapper;
    public static boolean onlyOwnerAccess;

    public void preinit(FMLPreInitializationEvent event) {
        try {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            onlyOwnerAccess = config.getBoolean("only_owner_access", "corpse", false, "If only the owner of the corpse can access the inventory");
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("corpse");
        simpleNetworkWrapper.registerMessage(MessageSwitchInventoryPage.class, MessageSwitchInventoryPage.class, 0, Side.SERVER);
        simpleNetworkWrapper.registerMessage(MessageOpenHistory.class, MessageOpenHistory.class, 1, Side.CLIENT);
        simpleNetworkWrapper.registerMessage(MessageShowCorpseInventory.class, MessageShowCorpseInventory.class, 2, Side.SERVER);
        simpleNetworkWrapper.registerMessage(MessageRequestDeathHistory.class, MessageRequestDeathHistory.class, 3, Side.SERVER);
        simpleNetworkWrapper.registerMessage(MessageDeathInventory.class, MessageDeathInventory.class, 4, Side.CLIENT);
        simpleNetworkWrapper.registerMessage(MessageTeleport.class, MessageTeleport.class, 5, Side.SERVER);
    }

    public void init(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("corpse", "corpse"), EntityCorpse.class, (String)"corpse", (int)3632, (Object)Main.instance(), (int)128, (int)1, (boolean)true);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance(), (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
    }

    public void postinit(FMLPostInitializationEvent event) {
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new HistoryCommand());
    }

    public static Death getDeathToShow(EntityPlayer player) {
        return deathsToShow.get(player.func_110124_au());
    }

    public static void setDeathToShow(EntityPlayer player, Death death) {
        deathsToShow.put(player.func_110124_au(), death);
    }

    static {
        onlyOwnerAccess = false;
    }
}

