/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.Validate;
import team.chisel.Chisel;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.common.block.TileAutoChisel;
import team.chisel.common.init.ChiselItems;

public class MessageAutochiselFX
implements IMessage {
    @Nonnull
    private BlockPos pos = BlockPos.field_177992_a;
    @Nonnull
    private ItemStack chisel = new ItemStack((Item)ChiselItems.chisel_iron);
    @Nonnull
    private Item chiselitem = ChiselItems.chisel_iron;
    @Nonnull
    private ItemStack source;

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.chisel);
        buf.writeInt(Item.func_150891_b((Item)this.chiselitem));
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.source);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        ItemStack chisel = ByteBufUtils.readItemStack((ByteBuf)buf);
        Validate.notNull((Object)chisel);
        this.chisel = chisel;
        this.chiselitem = Item.func_150899_d((int)buf.readInt());
        this.source = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public MessageAutochiselFX() {
    }

    @ConstructorProperties(value={"pos", "chisel", "chiselitem", "source"})
    public MessageAutochiselFX(@Nonnull BlockPos pos, @Nonnull ItemStack chisel, @Nonnull Item chiselitem, @Nonnull ItemStack source) {
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        if (chisel == null) {
            throw new NullPointerException("chisel");
        }
        if (chiselitem == null) {
            throw new NullPointerException("chiselitem");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.pos = pos;
        this.chisel = chisel;
        this.chiselitem = chiselitem;
        this.source = source;
    }

    public static class Handler
    implements IMessageHandler<MessageAutochiselFX, IMessage> {
        public IMessage onMessage(MessageAutochiselFX message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.getClientHandler()).func_152344_a(() -> {
                TileEntity te;
                World world = Chisel.proxy.getClientWorld();
                if (world.func_175667_e(message.pos) && (te = world.func_175625_s(message.pos)) instanceof TileAutoChisel) {
                    ((TileAutoChisel)te).spawnCompletionFX(Chisel.proxy.getClientPlayer(), message.chisel, message.chiselitem, CarvingUtils.getChiselRegistry().getVariation(message.source));
                }
            });
            return null;
        }
    }
}

