/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner;

import com.google.common.collect.Lists;
import drzhark.customspawner.EventHooks;
import drzhark.customspawner.command.CommandCMS;
import drzhark.customspawner.configuration.CMSConfiguration;
import drzhark.customspawner.entity.EntityData;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.handlers.SpawnTickHandler;
import drzhark.customspawner.type.EntitySpawnType;
import drzhark.customspawner.utils.CMSLog;
import drzhark.customspawner.utils.CMSUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

@Mod(modid="customspawner", name="DrZhark's CustomSpawner", version="3.11.4", acceptedMinecraftVersions="[1.12.2]")
public final class CustomSpawner {
    @Mod.Instance(value="customspawner")
    public static CustomSpawner INSTANCE;
    public static boolean forceDespawns;
    public static boolean debug;
    public static boolean doMobSpawning;
    public static File ROOT;
    public static CMSLog globalLog;
    public static Map<Class<? extends WorldProvider>, EnvironmentSettings> environmentMap;
    public static Map<String, ArrayList<Biome>> entityDefaultSpawnBiomes;
    public static Map<String, Biome.SpawnListEntry> defaultSpawnListEntryMap;
    public static Map<String, EnumCreatureType> entityTypes;
    public static CMSConfiguration CMSGlobalConfig;
    public static final String CATEGORY_GLOBAL_SETTINGS = "global-settings";
    private static List<Biome> biomeList;
    private final LongOpenHashSet eligibleChunksForSpawning = new LongOpenHashSet();

    public static CustomSpawner instance() {
        return INSTANCE;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new SpawnTickHandler());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ROOT = new File(event.getSuggestedConfigurationFile().getParent(), "CustomSpawner");
        globalLog = new CMSLog("Global");
        CMSGlobalConfig = new CMSConfiguration(new File(ROOT, "Global.cfg"));
        CMSGlobalConfig.load();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new EventHooks());
        MinecraftForge.EVENT_BUS.register((Object)new EventHooks());
        debug = CMSGlobalConfig.get(CATEGORY_GLOBAL_SETTINGS, "debug", false, "Turns on global debug logging.").getBoolean(false);
        doMobSpawning = CMSGlobalConfig.get(CATEGORY_GLOBAL_SETTINGS, "doMobSpawning", false, "If false, turns off vanilla spawner completely to provide better compatibility with CMS. Note: if you remove CMS, set back to true and load up game at least once so it reenables vanilla spawner. You can also type /gamerule doMobSpawning true").getBoolean(false);
        CMSGlobalConfig.save();
        if (debug) {
            CustomSpawner.globalLog.logger.info("Initializing CustomSpawner Config File at " + event.getSuggestedConfigurationFile().getParent() + "Global.cfg");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        for (EnvironmentSettings environment : environmentMap.values()) {
            environment.readConfigValues();
        }
        biomeList = new ArrayList<Biome>();
        try {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null) continue;
                biomeList.add(biome);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        EnvironmentSettings overworld = environmentMap.get(WorldProviderSurface.class);
        if (overworld != null) {
            overworld.initializeEntities();
            overworld.updateSettings();
        }
        event.registerServerCommand((ICommand)new CommandCMS());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        CMSUtils.dumpEntitySpawnLists();
        CMSUtils.dumpDefaultSpawnList();
    }

    protected static BlockPos getRandomSpawningPointInChunk(Chunk chunk, World world) {
        int x = chunk.field_76635_g * 16 + world.field_73012_v.nextInt(16);
        int z = chunk.field_76647_h * 16 + world.field_73012_v.nextInt(16);
        int height = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(x, 0, z)) + 1), (int)16);
        int y = world.field_73012_v.nextInt(height > 0 ? height : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(x, y, z);
    }

    public int countEntities(WorldServer world, EntitySpawnType entitySpawnType) {
        int count = 0;
        EnvironmentSettings environment = CMSUtils.getEnvironment((World)world);
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            int z;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityData entityData = environment.classToEntityMapping.get(entity.getClass());
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            long chunkPos = CMSUtils.asLong(x >> 4, (z = MathHelper.func_76128_c((double)entity.field_70161_v)) >> 4);
            if (!this.eligibleChunksForSpawning.contains(chunkPos) || entityData == null || entityData.getLivingSpawnType() != entitySpawnType) continue;
            ++count;
        }
        return count;
    }

    public final int doCustomSpawning(WorldServer world, EntitySpawnType entitySpawnType, int mobSpawnRange) {
        this.eligibleChunksForSpawning.clear();
        Iterator iterator = world.field_73010_i.iterator();
        int chunkSpawnRadius = mobSpawnRange;
        int serverViewDistance = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72395_o();
        chunkSpawnRadius = chunkSpawnRadius > serverViewDistance ? serverViewDistance : chunkSpawnRadius;
        chunkSpawnRadius = chunkSpawnRadius > 8 ? 8 : (int)chunkSpawnRadius;
        int MOB_SPAWN_COUNT_DIV = (2 * chunkSpawnRadius + 1) * (2 * chunkSpawnRadius + 1);
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = (EntityPlayer)iterator.next();
            if (entityplayer.func_175149_v()) continue;
            int x = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int z = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int var8 = -chunkSpawnRadius; var8 <= chunkSpawnRadius; ++var8) {
                for (int var9 = -chunkSpawnRadius; var9 <= chunkSpawnRadius; ++var9) {
                    boolean flag = var8 == -chunkSpawnRadius || var8 == chunkSpawnRadius || var9 == -chunkSpawnRadius || var9 == chunkSpawnRadius;
                    long chunkPos = CMSUtils.asLong(var8 + x, var9 + z);
                    if (this.eligibleChunksForSpawning.contains(chunkPos) || flag || !CustomSpawner.isInBorderBounds(world.func_175723_af(), var8 + x, var9 + z)) continue;
                    this.eligibleChunksForSpawning.add(chunkPos);
                }
            }
        }
        int countTotal = 0;
        BlockPos chunkcoordspawn = world.func_175694_M();
        int limit = 0;
        limit = entitySpawnType.getSpawnCap();
        if (limit == 0) {
            return 0;
        }
        int mobcnt = this.countEntities(world, entitySpawnType);
        int maxcnt = this.getMax(entitySpawnType) * this.eligibleChunksForSpawning.size() / MOB_SPAWN_COUNT_DIV;
        int spawnsLeft = maxcnt - mobcnt;
        if (mobcnt > maxcnt) {
            if (CMSUtils.getEnvironment((World)world).debug) {
                CMSUtils.getEnvironment((World)world).envLog.logger.info("[" + entitySpawnType.name().toUpperCase() + "]Unable to spawn, Total count " + mobcnt + " exceeds limit of " + maxcnt);
            }
            return countTotal;
        }
        Object iterator1 = this.eligibleChunksForSpawning.iterator();
        ArrayList tmp = Lists.newArrayList((Iterable)this.eligibleChunksForSpawning);
        Collections.shuffle(tmp);
        iterator1 = tmp.iterator();
        int moblimit = maxcnt - mobcnt + 1;
        block5: while (iterator1.hasNext() && moblimit > 0) {
            long chunkPos = (Long)iterator1.next();
            int chunkX = CMSUtils.getChunkX(chunkPos);
            int chunkZ = CMSUtils.getChunkZ(chunkPos);
            Chunk chunk = CustomSpawner.getLoadedChunkWithoutMarkingActive(world.func_72863_F(), chunkX, chunkZ);
            if (chunk == null || chunk.field_189550_d) continue;
            BlockPos blockPos = CustomSpawner.getRandomSpawningPointInChunk(chunk, (World)world);
            int posX = blockPos.func_177958_n();
            int posY = blockPos.func_177956_o();
            int posZ = blockPos.func_177952_p();
            if (chunk.func_177435_g(blockPos).func_185915_l() || chunk.func_177435_g(blockPos).func_185904_a() != entitySpawnType.getLivingMaterial()) continue;
            int spawnedMob = 0;
            block6: for (int spawnCount = 0; spawnCount < 3; ++spawnCount) {
                int tempX = posX;
                int tempY = posY;
                int tempZ = posZ;
                int var20 = 6;
                Biome.SpawnListEntry spawnlistentry = null;
                IEntityLivingData entityLivingData = null;
                int spawnAttempt = 0;
                while (spawnAttempt < 4) {
                    float spawnX = (float)(tempX += world.field_73012_v.nextInt(var20) - world.field_73012_v.nextInt(var20)) + 0.5f;
                    float spawnY = tempY += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1);
                    float spawnZ = (float)(tempZ += world.field_73012_v.nextInt(var20) - world.field_73012_v.nextInt(var20)) + 0.5f;
                    BlockPos spawnPos = new BlockPos(tempX, tempY, tempZ);
                    Chunk spawnChunk = CustomSpawner.getLoadedChunkWithoutMarkingActive(world.func_72863_F(), spawnPos.func_177958_n() >> 4, spawnPos.func_177952_p() >> 4);
                    if (spawnChunk == null || spawnChunk.field_189550_d) {
                        ++spawnAttempt;
                        continue;
                    }
                    if (!world.func_175636_b((double)spawnX, (double)spawnY, (double)spawnZ, 24.0) && chunkcoordspawn.func_177954_c((double)spawnX, (double)spawnY, (double)spawnZ) >= 576.0) {
                        if (spawnlistentry == null && (spawnlistentry = this.getRandomCustomMob((World)world, entitySpawnType, tempX, tempY, tempZ)) == null) continue block6;
                        if (CustomSpawner.canCreatureTypeSpawnAtLocation(spawnChunk, entitySpawnType, spawnlistentry, world, spawnPos)) {
                            boolean underGroundSpawn;
                            EntityLiving entityliving;
                            try {
                                entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return countTotal;
                            }
                            EntityData entityData = CMSUtils.getEnvironment((World)world).classToEntityMapping.get(spawnlistentry.field_76300_b);
                            entityliving.func_70012_b((double)spawnX, (double)spawnY, (double)spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)spawnX, (float)spawnY, (float)spawnZ, (boolean)false);
                            boolean validLightLevel = CustomSpawner.isValidLightLevel((Entity)entityliving, world, entityData.getMinLightLevel(), entityData.getMaxLightLevel());
                            boolean canEntitySpawn = canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi();
                            boolean bl = underGroundSpawn = entityData.getLivingSpawnType() == entityData.getEnvironment().LIVINGTYPE_UNDERGROUND && CMSUtils.isValidUndergroundLightLevel(entityliving);
                            if (validLightLevel && (canEntitySpawn || underGroundSpawn)) {
                                ++spawnedMob;
                                world.func_72838_d((Entity)entityliving);
                                entityLivingData = CustomSpawner.creatureSpecificInit(entityliving, (World)world, new BlockPos((double)spawnX, (double)spawnY, (double)spawnZ), entityLivingData);
                                if (debug) {
                                    CMSUtils.getEnvironment((World)world).envLog.logSpawn(CMSUtils.getEnvironment((World)world), entitySpawnType.name(), world.func_180494_b((BlockPos)new BlockPos((int)(chunkX * 16 + 16), (int)0, (int)(chunkZ * 16 + 16))).field_76791_y, entityData.getEntityName(), MathHelper.func_76141_d((float)spawnX), MathHelper.func_76141_d((float)spawnY), MathHelper.func_76141_d((float)spawnZ), spawnsLeft, spawnlistentry);
                                }
                                if (spawnedMob >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving) || --moblimit <= 0) {
                                    continue block5;
                                }
                            } else if (CMSUtils.getEnvironment((World)world).debug) {
                                CMSUtils.getEnvironment((World)world).envLog.logger.info("[Unable to spawn " + entityliving + " at coords " + spawnX + ", " + spawnY + ", " + spawnZ + "][ValidLightLevel ? " + validLightLevel + "][CanSpawn ? " + canEntitySpawn + "]");
                            }
                            countTotal += spawnedMob;
                        }
                    }
                    ++spawnAttempt;
                }
            }
        }
        return countTotal;
    }

    public static boolean isValidLightLevel(Entity entity, WorldServer world, int minLightLevel, int maxLightLevel) {
        if (minLightLevel == -1 && maxLightLevel == -1) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.MONSTER, false)) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.AMBIENT, false)) {
            return true;
        }
        if (!entity.isCreatureType(EnumCreatureType.CREATURE, false)) {
            return true;
        }
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int blockLightLevel = 0;
        if (y >= 0) {
            if (y >= 256) {
                y = 255;
            }
            blockLightLevel = CMSUtils.getLightFromNeighbors(world.func_72964_e(x >> 4, z >> 4), x & 0xF, y, z & 0xF);
        }
        if (blockLightLevel < minLightLevel && minLightLevel != -1) {
            if (debug) {
                CMSUtils.getEnvironment((World)world).envLog.logger.info("Denied spawn! for " + entity.func_70005_c_() + blockLightLevel + " under minimum threshold of " + minLightLevel + " in dimension " + world.field_73011_w.func_186058_p().func_186068_a() + " at coords " + x + ", " + y + ", " + z);
            }
            return false;
        }
        if (blockLightLevel > maxLightLevel && maxLightLevel != -1) {
            if (debug) {
                CMSUtils.getEnvironment((World)world).envLog.logger.info("Denied spawn! for " + entity.func_70005_c_() + blockLightLevel + " over maximum threshold of " + maxLightLevel + " in dimension " + world.field_73011_w.func_186058_p().func_186068_a() + " at coords " + x + ", " + y + ", " + z);
            }
            return false;
        }
        return true;
    }

    public void AddCustomSpawn(Class<? extends EntityLiving> class1, int i, int j, int k, EntitySpawnType entitySpawnType, Biome[] biomes) {
        if (debug) {
            CustomSpawner.globalLog.logger.info("AddCustomSpawn class " + class1 + ", with " + i + ":" + j + ":" + k + "  type = " + entitySpawnType);
        }
        if (class1 == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (entitySpawnType == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomes == null) {
            biomes = new Biome[biomeList.size()];
            biomes = biomeList.toArray(biomes);
        }
        for (Biome biome : biomes) {
            if (biome == null || entitySpawnType.getEnvironment().getWorldProviderClass() == WorldProviderEnd.class && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || entitySpawnType.getEnvironment().getWorldProviderClass() == WorldProviderHell.class && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            ArrayList<Biome.SpawnListEntry> spawnList = entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome));
            if (spawnList != null) {
                boolean flag = false;
                for (Biome.SpawnListEntry spawnEntry : spawnList) {
                    if (spawnEntry.field_76300_b != class1) continue;
                    spawnEntry.field_76292_a = i;
                    spawnEntry.field_76301_c = j;
                    spawnEntry.field_76299_d = k;
                    flag = true;
                    break;
                }
                if (flag) continue;
                spawnList.add(new Biome.SpawnListEntry(class1, i, j, k));
                continue;
            }
            entitySpawnType.addBiomeSpawnList(Biome.func_185362_a((Biome)biome));
            entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome)).add(new Biome.SpawnListEntry(class1, i, j, k));
        }
    }

    public void RemoveCustomSpawn(Class<? extends EntityLiving> class1, EntitySpawnType entitySpawnType, Biome[] biomes) {
        if (class1 == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (biomes == null) {
            biomes = new Biome[biomeList.size()];
            biomes = biomeList.toArray(biomes);
        }
        block0: for (Biome biome : biomes) {
            ArrayList<Biome.SpawnListEntry> spawnList = entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome));
            if (spawnList == null) continue;
            Iterator<Biome.SpawnListEntry> iterator = spawnList.iterator();
            while (iterator.hasNext()) {
                Biome.SpawnListEntry spawnEntry = iterator.next();
                if (spawnEntry.field_76300_b != class1) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void copyVanillaSpawnData() {
        for (Biome biome : Biome.field_185377_q) {
            for (EnumCreatureType enumcreaturetype : entityTypes.values()) {
                if (enumcreaturetype == null) continue;
                Iterator spawnIterator = biome.func_76747_a(enumcreaturetype).iterator();
                while (spawnIterator.hasNext()) {
                    if (spawnIterator == null) continue;
                    Biome.SpawnListEntry spawnlistentry = (Biome.SpawnListEntry)spawnIterator.next();
                    if (entityDefaultSpawnBiomes.containsKey(spawnlistentry.field_76300_b.getName())) {
                        if (!entityDefaultSpawnBiomes.get(spawnlistentry.field_76300_b.getName()).contains(biome)) {
                            entityDefaultSpawnBiomes.get(spawnlistentry.field_76300_b.getName()).add(biome);
                        }
                    } else {
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        biomes.add(biome);
                        entityDefaultSpawnBiomes.put(spawnlistentry.field_76300_b.getName(), biomes);
                        if (!defaultSpawnListEntryMap.containsKey(spawnlistentry.field_76300_b.getName())) {
                            defaultSpawnListEntryMap.put(spawnlistentry.field_76300_b.getName(), spawnlistentry);
                        }
                    }
                    spawnIterator.remove();
                }
            }
        }
    }

    public void updateSpawnListEntry(EntityData entityData) {
        for (int i = 0; i < biomeList.size(); ++i) {
            ArrayList<Biome.SpawnListEntry> spawnList = entityData.getLivingSpawnType().getBiomeSpawnList(Biome.func_185362_a((Biome)biomeList.get(i)));
            if (spawnList == null) continue;
            for (Biome.SpawnListEntry spawnEntry : spawnList) {
                if (spawnEntry.field_76300_b != entityData.getEntityClass()) continue;
                if (debug) {
                    CustomSpawner.globalLog.logger.info("updateSpawnListEntry " + entityData.getEntityClass() + " to " + entityData.getFrequency() + ":" + entityData.getMinSpawn() + ":" + entityData.getMaxSpawn() + " in biome " + CustomSpawner.biomeList.get((int)i).field_76791_y);
                }
                spawnEntry.field_76292_a = entityData.getFrequency();
                spawnEntry.field_76301_c = entityData.getMinSpawn();
                spawnEntry.field_76299_d = entityData.getMaxSpawn();
            }
        }
    }

    public void updateSpawnListBiomes(Class<? extends EntityLiving> clazz, EntitySpawnType entitySpawnType, int freq, int min, int max, List<Biome> biomes) {
        if (biomes != null) {
            if (debug) {
                CustomSpawner.globalLog.logger.info("updateSpawnListBiomes for clazz " + clazz + " with " + freq + ":" + min + ":" + max + " in " + biomes);
            }
            this.RemoveCustomSpawn(clazz, entitySpawnType, null);
            Biome[] allBiomes = new Biome[biomes.size()];
            this.AddCustomSpawn(clazz, freq, min, max, entitySpawnType, biomes.toArray(allBiomes));
        }
    }

    public int getMax(EntitySpawnType entitySpawnType) {
        return entitySpawnType.getSpawnCap();
    }

    public static boolean canCreatureTypeSpawnAtLocation(Chunk chunk, EntitySpawnType entitySpawnType, Biome.SpawnListEntry spawnListEntry, WorldServer world, BlockPos pos) {
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (entitySpawnType.getMinSpawnHeight() != -1 && pos.func_177956_o() < entitySpawnType.getMinSpawnHeight()) {
            return false;
        }
        if (entitySpawnType.getMaxSpawnHeight() != -1 && pos.func_177956_o() > entitySpawnType.getMaxSpawnHeight()) {
            return false;
        }
        EntityLiving.SpawnPlacementType spawnPlacementType = EntitySpawnPlacementRegistry.func_180109_a((Class)spawnListEntry.field_76300_b);
        if (spawnPlacementType != null && spawnPlacementType == EntityLiving.SpawnPlacementType.IN_WATER || entitySpawnType.getLivingMaterial() == Material.field_151586_h) {
            return chunk.func_177435_g(pos).func_185904_a().func_76224_d() && chunk.func_177435_g(pos.func_177977_b()).func_185904_a().func_76224_d() && !chunk.func_177435_g(pos.func_177984_a()).func_185915_l();
        }
        IBlockState blockstate = chunk.func_177435_g(pos);
        BlockPos blockpos = pos.func_177977_b();
        IBlockState blockstate1 = chunk.func_177435_g(blockpos);
        if (!blockstate1.func_177230_c().canCreatureSpawn(blockstate1, (IBlockAccess)world, blockpos, spawnPlacementType)) {
            return false;
        }
        boolean flag = blockstate1.func_177230_c() != Blocks.field_150357_h && blockstate1.func_177230_c() != Blocks.field_180401_cv;
        boolean result = flag && !blockstate.func_185915_l() && !blockstate.func_185904_a().func_76224_d() && !chunk.func_177435_g(pos.func_177984_a()).func_185915_l();
        return result;
    }

    public final int countEntities(Class<? extends EntityLiving> class1, World world) {
        int i = 0;
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public Biome.SpawnListEntry getRandomCustomMob(World world, EntitySpawnType entitySpawnType, int pX, int pY, int pZ) {
        List<Biome.SpawnListEntry> list = this.getPossibleCustomCreatures(world, entitySpawnType, pX, pY, pZ);
        if (list == null || list.isEmpty()) {
            return null;
        }
        try {
            return (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, list);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public List<Biome.SpawnListEntry> getPossibleCustomCreatures(World world, EntitySpawnType entitySpawnType, int pX, int pY, int pZ) {
        Biome biome = world.func_180494_b(new BlockPos(pX, 0, pZ));
        if (biome == null) {
            return null;
        }
        return entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)biome));
    }

    private static IEntityLivingData creatureSpecificInit(EntityLiving entityLiving, World world, BlockPos pos, IEntityLivingData entityLivingData) {
        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p())) {
            entityLivingData = entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), entityLivingData);
        }
        return entityLivingData;
    }

    public static void performWorldGenSpawning(EntitySpawnType entitySpawnType, World world, Biome par1Biome, int par2, int par3, int par4, int par5, Random par6Random, List<Biome.SpawnListEntry> customSpawnList, boolean worldGenCreatureSpawning) {
        if (!worldGenCreatureSpawning || customSpawnList.isEmpty() || entitySpawnType.getSpawnCap() <= 0) {
            return;
        }
        while (par6Random.nextFloat() < entitySpawnType.getChunkSpawnChance()) {
            Biome.SpawnListEntry spawnlistentry = null;
            try {
                spawnlistentry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, customSpawnList);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (spawnlistentry == null) continue;
            int i1 = spawnlistentry.field_76301_c + par6Random.nextInt(1 + spawnlistentry.field_76299_d - spawnlistentry.field_76301_c);
            int j1 = par2 + par6Random.nextInt(par4);
            int k1 = par3 + par6Random.nextInt(par5);
            int l1 = j1;
            int i2 = k1;
            IEntityLivingData entityLivingData = null;
            EntityData entityData = CMSUtils.getEnvironment((World)world).classToEntityMapping.get(spawnlistentry.field_76300_b);
            for (int j2 = 0; j2 < i1; ++j2) {
                boolean flag = false;
                for (int k2 = 0; !flag && k2 < 4; ++k2) {
                    Chunk chunk = CustomSpawner.getLoadedChunkWithoutMarkingActive((ChunkProviderServer)world.func_72863_F(), j1 >> 4, k1 >> 4);
                    if (chunk == null || chunk.field_189550_d) continue;
                    BlockPos blockpos = world.func_175672_r(new BlockPos(j1, 0, k1));
                    if (CustomSpawner.canCreatureTypeSpawnAtLocation(chunk, entityData.getLivingSpawnType(), spawnlistentry, (WorldServer)world, blockpos)) {
                        EntityLiving entityliving;
                        try {
                            entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        BlockPos pos = new BlockPos((double)((float)j1 + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k1 + 0.5f));
                        entityliving.func_70012_b((double)((float)j1 + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k1 + 0.5f), par6Random.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)entityliving.func_180425_c().func_177958_n(), (float)entityliving.func_180425_c().func_177956_o(), (float)entityliving.func_180425_c().func_177952_p(), (boolean)false);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi()) {
                            world.func_72838_d((Entity)entityliving);
                            if (CMSUtils.getEnvironment((World)world).debug) {
                                CMSUtils.getEnvironment((World)world).envLog.logger.info("[WorldGen spawned " + entityliving.func_70005_c_() + " at " + entityliving.func_180425_c() + " with CREATURE:" + spawnlistentry.field_76292_a + ":" + spawnlistentry.field_76301_c + ":" + spawnlistentry.field_76299_d + ":" + ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving) + " in biome " + par1Biome.field_76791_y + "]");
                            }
                            entityLivingData = CustomSpawner.creatureSpecificInit(entityliving, world, pos, entityLivingData);
                            flag = true;
                        }
                    }
                    j1 += par6Random.nextInt(5) - par6Random.nextInt(5);
                    k1 += par6Random.nextInt(5) - par6Random.nextInt(5);
                    while (j1 < par2 || j1 >= par2 + par4 || k1 < par3 || k1 >= par3 + par4) {
                        j1 = l1 + par6Random.nextInt(5) - par6Random.nextInt(5);
                        k1 = i2 + par6Random.nextInt(5) - par6Random.nextInt(5);
                    }
                }
            }
        }
    }

    public static IBlockState getBlockStateWithoutMarkingActive(WorldServer world, BlockPos pos) {
        Chunk chunk = CustomSpawner.getLoadedChunkWithoutMarkingActive(world.func_72863_F(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null || chunk.field_189550_d || pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.func_177435_g(pos);
    }

    public static Chunk getLoadedChunkWithoutMarkingActive(ChunkProviderServer chunkProviderServer, int x, int z) {
        long i = ChunkPos.func_77272_a((int)x, (int)z);
        Chunk chunk = (Chunk)chunkProviderServer.field_73244_f.get(i);
        return chunk;
    }

    private static boolean isInBorderBounds(WorldBorder border, int x, int z) {
        return (double)((x << 4) + 15) > border.func_177726_b() && (double)(x << 4) < border.func_177728_d() && (double)((z << 4) + 15) > border.func_177736_c() && (double)(x << 4) < border.func_177733_e();
    }

    static {
        forceDespawns = false;
        debug = false;
        doMobSpawning = false;
        environmentMap = new HashMap<Class<? extends WorldProvider>, EnvironmentSettings>();
        entityDefaultSpawnBiomes = new TreeMap<String, ArrayList<Biome>>(String.CASE_INSENSITIVE_ORDER);
        defaultSpawnListEntryMap = new TreeMap<String, Biome.SpawnListEntry>(String.CASE_INSENSITIVE_ORDER);
        entityTypes = new HashMap<String, EnumCreatureType>();
        entityTypes.put("UNDEFINED", null);
        entityTypes.put("CREATURE", EnumCreatureType.CREATURE);
        entityTypes.put("MONSTER", EnumCreatureType.MONSTER);
        entityTypes.put("WATER_CREATURE", EnumCreatureType.WATER_CREATURE);
        entityTypes.put("AMBIENT", EnumCreatureType.AMBIENT);
    }
}

