/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.block.BlockSteepBoostRamp;
import com.mrcrayfish.vehicle.client.util.BakedQuadBuilder;
import com.mrcrayfish.vehicle.client.util.TransformationBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelSteepRamp
implements IBakedModel {
    private static final ImmutableMap<ItemCameraTransforms.TransformType, Matrix4f> CAMERA_TRANSFORMATIONS;
    private VertexFormat format;
    private TextureAtlasSprite mainTexture;
    private TextureAtlasSprite rampTexture;

    public BakedModelSteepRamp(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.mainTexture = bakedTextureGetter.apply(new ResourceLocation("minecraft", "blocks/concrete_gray"));
        this.rampTexture = bakedTextureGetter.apply(new ResourceLocation("vehicle", "blocks/boost_pad"));
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList quads = Lists.newArrayList();
        if (side == null) {
            BakedQuadBuilder builder = new BakedQuadBuilder(this.format);
            builder.setFacing(EnumFacing.NORTH);
            EnumFacing facing = EnumFacing.NORTH;
            float startHeight = 0.0f;
            float endHeight = 1.0f;
            boolean left = false;
            boolean right = false;
            if (state != null) {
                if (state.func_177227_a().contains(BlockRotatedObject.FACING)) {
                    facing = (EnumFacing)state.func_177229_b((IProperty)BlockRotatedObject.FACING);
                    builder.setFacing(facing);
                }
                left = state.func_177227_a().contains(BlockSteepBoostRamp.LEFT) && (Boolean)state.func_177229_b((IProperty)BlockSteepBoostRamp.LEFT) != false;
                right = state.func_177227_a().contains(BlockSteepBoostRamp.RIGHT) && (Boolean)state.func_177229_b((IProperty)BlockSteepBoostRamp.RIGHT) != false;
            }
            builder.setTexture(this.rampTexture);
            boolean offsetStart = !left;
            int offsetEnd = right ? 16 : 15;
            builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, (float)offsetStart * 0.0625f, (float)offsetStart, 0.0f), EnumFacing.UP);
            builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, (float)offsetEnd * 0.0625f, offsetEnd, 0.0f), EnumFacing.UP);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, (float)offsetEnd * 0.0625f, offsetEnd, 16.0f), EnumFacing.UP);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, (float)offsetStart * 0.0625f, (float)offsetStart, 16.0f), EnumFacing.UP);
            quads.add(builder.build());
            builder.setTexture(this.mainTexture);
            if (!left) {
                builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 0.0f, 0.0f, 0.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 0.0625f, 1.0f, 0.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 0.0625f, 1.0f, 16.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 0.0f, 0.0f, 16.0f), EnumFacing.UP);
                quads.add(builder.build());
            }
            if (!right) {
                builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 0.9375f, 15.0f, 0.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 1.0f, 16.0f, 0.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 1.0f, 16.0f, 16.0f), EnumFacing.UP);
                builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 0.9375f, 15.0f, 16.0f), EnumFacing.UP);
                quads.add(builder.build());
            }
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 0.0f, 0.0f, 0.0f), facing.func_176735_f());
            builder.put(new BakedQuadBuilder.VertexData(0.0f, 0.0f, 0.0f, 16.0f, 0.0f), facing.func_176735_f());
            builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 0.0f, 16.0f, 16.0f * startHeight), facing.func_176735_f());
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 0.0f, 0.0f, 16.0f * endHeight), facing.func_176735_f());
            quads.add(builder.build());
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 1.0f, 0.0f, 0.0f), facing);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 0.0f, 16.0f, 0.0f), facing);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 0.0f, 16.0f, 16.0f * endHeight), facing);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 1.0f, 0.0f, 16.0f * endHeight), facing);
            quads.add(builder.build());
            builder.put(new BakedQuadBuilder.VertexData(0.0f, 0.0f, 1.0f, 0.0f, 0.0f), facing.func_176746_e());
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 1.0f, 16.0f, 0.0f), facing.func_176746_e());
            builder.put(new BakedQuadBuilder.VertexData(1.0f, endHeight, 1.0f, 16.0f, 16.0f * endHeight), facing.func_176746_e());
            builder.put(new BakedQuadBuilder.VertexData(0.0f, startHeight, 1.0f, 0.0f, 16.0f * startHeight), facing.func_176746_e());
            quads.add(builder.build());
            builder.put(new BakedQuadBuilder.VertexData(0.0f, 0.0f, 1.0f, 0.0f, 0.0f), facing);
            builder.put(new BakedQuadBuilder.VertexData(0.0f, 0.0f, 0.0f, 16.0f, 0.0f), facing);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 0.0f, 16.0f, 16.0f), facing);
            builder.put(new BakedQuadBuilder.VertexData(1.0f, 0.0f, 1.0f, 0.0f, 16.0f), facing);
            quads.add(builder.build());
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.mainTexture;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)Lists.newArrayList());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)CAMERA_TRANSFORMATIONS.get((Object)cameraTransformType));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)new TransformationBuilder().setScale(0.5f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)new TransformationBuilder().setTranslation(0.1f, 0.0f, 0.0f).setRotation(30.0f, 45.0f, 0.0f).setScale(0.625f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)new TransformationBuilder().setTranslation(0.0f, 1.0f, 0.0f).setScale(0.25f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new TransformationBuilder().setTranslation(0.0f, 4.0f, 0.0f).setRotation(0.0f, -45.0f, 0.0f).setScale(0.4f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new TransformationBuilder().setTranslation(0.0f, 4.0f, 0.0f).setRotation(0.0f, 135.0f, 0.0f).setScale(0.4f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TransformationBuilder().setTranslation(0.0f, 2.5f, 3.5f).setRotation(75.0f, 315.0f, 0.0f).setScale(0.375f).build().getMatrix());
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TransformationBuilder().setTranslation(0.0f, 2.5f, 3.5f).setRotation(75.0f, 135.0f, 0.0f).setScale(0.375f).build().getMatrix());
        CAMERA_TRANSFORMATIONS = builder.build();
    }
}

