/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityVehicleCrate
extends TileEntitySynced
implements ITickable {
    private static final Random RAND = new Random();
    private ResourceLocation entityId;
    private int color = EntityVehicle.DYE_TO_COLOR[0];
    private EngineTier engineTier = null;
    private WheelType wheelType = null;
    private int wheelColor = -1;
    private boolean opened = false;
    private int timer;
    private UUID opener;
    @SideOnly(value=Side.CLIENT)
    private Entity entity;

    public void setEntityId(ResourceLocation entityId) {
        this.entityId = entityId;
        this.func_70296_d();
    }

    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    public void open(UUID opener) {
        if (this.entityId != null) {
            this.opened = true;
            this.opener = opener;
            this.syncToClient();
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getTimer() {
        return this.timer;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntity() {
        return this.entity;
    }

    public void func_73660_a() {
        if (this.opened) {
            this.timer += 5;
            if (this.field_145850_b.field_72995_K) {
                if (this.entityId != null && this.entity == null) {
                    this.entity = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)this.field_145850_b);
                    if (this.entity != null) {
                        VehicleMod.proxy.playSound(SoundEvents.field_187635_cQ, this.field_174879_c, 1.0f, 0.5f);
                        List entryList = this.entity.func_184212_Q().func_187231_c();
                        if (entryList != null) {
                            entryList.forEach(dataEntry -> this.entity.func_184206_a(dataEntry.func_187205_a()));
                        }
                        if (this.entity instanceof EntityVehicle) {
                            ((EntityVehicle)this.entity).setColor(this.color);
                        }
                        if (this.entity instanceof EntityPoweredVehicle) {
                            EntityPoweredVehicle entityPoweredVehicle = (EntityPoweredVehicle)this.entity;
                            if (this.engineTier != null) {
                                entityPoweredVehicle.setEngine(true);
                                entityPoweredVehicle.setEngineTier(this.engineTier);
                            }
                            if (this.wheelType != null) {
                                entityPoweredVehicle.setWheels(true);
                                entityPoweredVehicle.setWheelType(this.wheelType);
                                if (this.wheelColor != -1) {
                                    entityPoweredVehicle.setWheelColor(this.wheelColor);
                                }
                            } else {
                                entityPoweredVehicle.setWheels(false);
                            }
                        }
                    } else {
                        this.entityId = null;
                    }
                }
                if (this.timer == 90 || this.timer == 110 || this.timer == 130 || this.timer == 150) {
                    float pitch = (float)((double)0.9f + (double)0.2f * RAND.nextDouble());
                    VehicleMod.proxy.playSound(ModSounds.VEHICLE_CRATE_PANEL_LAND, this.field_174879_c, 1.0f, pitch);
                }
                if (this.timer == 150) {
                    VehicleMod.proxy.playSound(SoundEvents.field_187539_bB, this.field_174879_c, 1.0f, 1.0f);
                    this.field_145850_b.func_175682_a(EnumParticleTypes.EXPLOSION_HUGE, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (!this.field_145850_b.field_72995_K && this.timer > 250) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockVehicleCrate.FACING);
                Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)this.field_145850_b);
                if (entity != null) {
                    if (entity instanceof EntityVehicle) {
                        ((EntityVehicle)entity).setColor(this.color);
                    }
                    if (this.opener != null && entity instanceof EntityPoweredVehicle) {
                        EntityPoweredVehicle poweredVehicle = (EntityPoweredVehicle)entity;
                        poweredVehicle.setOwner(this.opener);
                        if (this.engineTier != null) {
                            poweredVehicle.setEngine(true);
                            poweredVehicle.setEngineTier(this.engineTier);
                        }
                        if (this.wheelType != null) {
                            poweredVehicle.setWheelType(this.wheelType);
                            if (this.wheelColor != -1) {
                                poweredVehicle.setWheelColor(this.wheelColor);
                            }
                        }
                    }
                    entity.func_70080_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, (float)facing.func_176736_b() * 90.0f + 180.0f, 0.0f);
                    entity.func_70034_d((float)facing.func_176736_b() * 90.0f + 180.0f);
                    this.field_145850_b.func_72838_d(entity);
                }
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.entityId != null) {
            compound.func_74778_a("vehicle", this.entityId.toString());
        }
        if (this.opener != null) {
            compound.func_186854_a("opener", this.opener);
        }
        compound.func_74768_a("color", this.color);
        if (this.engineTier != null) {
            compound.func_74768_a("engineTier", this.engineTier.ordinal());
        }
        if (this.wheelType != null) {
            compound.func_74768_a("wheelType", this.wheelType.ordinal());
            if (this.wheelColor != -1) {
                compound.func_74768_a("wheelColor", this.wheelColor);
            }
        }
        compound.func_74757_a("opened", this.opened);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("vehicle", 8)) {
            this.entityId = new ResourceLocation(compound.func_74779_i("vehicle"));
        }
        if (compound.func_150297_b("color", 3)) {
            this.color = compound.func_74762_e("color");
        }
        if (compound.func_150297_b("engineTier", 3)) {
            this.engineTier = EngineTier.getType(compound.func_74762_e("engineTier"));
        }
        if (compound.func_150297_b("wheelType", 3)) {
            this.wheelType = WheelType.getType(compound.func_74762_e("wheelType"));
        }
        if (compound.func_150297_b("wheelColor", 3)) {
            this.wheelColor = compound.func_74762_e("wheelColor");
        }
        if (compound.func_150297_b("opener", 8)) {
            this.opener = compound.func_186857_a("opener");
        }
        if (compound.func_150297_b("opened", 1)) {
            this.opened = compound.func_74767_n("opened");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

