/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.client.render;

import fossilsarcheology.server.entity.prehistoric.EntityArthropleura;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArthropleuraBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 0.01;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityArthropleura entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_70761_aq, entity.field_70760_ar) && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += (entity.field_70760_ar - entity.field_70761_aq) / divisor;
        }
        if (this.yawVariation > 0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -0.7f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityArthropleura entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (entity.field_70125_A != entity.field_70127_C && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += (entity.field_70127_C - entity.field_70125_A) / divisor;
        }
        if (this.pitchVariation > 0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -0.7f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityArthropleura entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityArthropleura entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(boolean reverse, ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78796_g = box.field_78796_g + (reverse ? -rotateAmount : rotateAmount);
        }
    }

    public void applyChainWaveBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevPitchVariation, (float)this.pitchVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f += rotateAmount;
        }
    }
}

