/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import fossilsarcheology.server.block.SifterBlock;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntitySifter
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private static final int[] slots_bottom = new int[]{1, 2, 3, 4, 5};
    private static final int[] slots_top = new int[]{0};
    public int sifterBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int sifterCookTime = 0;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private String customName;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int rawIndex = -1;
    private int spaceIndex = -1;

    private static int getItemBurnTime(ItemStack stack) {
        return 100;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntitySifter.getItemBurnTime(stack) > 0;
    }

    public static boolean isAnalyzable(ItemStack stack) {
        return FAMachineRecipeRegistry.getSifterRecipeForItem(stack) != null;
    }

    public static EnumSiftType getSiftTypeFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            IBlockState block = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P();
            if (block.func_185904_a() == Material.field_151595_p && !(block.func_177230_c() instanceof BlockConcretePowder)) {
                return EnumSiftType.SAND;
            }
            if (block.func_185904_a() == Material.field_151578_c) {
                return EnumSiftType.GROUND;
            }
        }
        return EnumSiftType.NONE;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (!((ItemStack)this.stacks.get(slot)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(slot)).func_190916_E() <= count) {
                ItemStack var3 = (ItemStack)this.stacks.get(slot);
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                return var3;
            }
            ItemStack var3 = ((ItemStack)this.stacks.get(slot)).func_77979_a(count);
            if (((ItemStack)this.stacks.get(slot)).func_190916_E() == 0) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            }
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)var1, this.stacks);
        this.sifterBurnTime = var1.func_74765_d("BurnTime");
        this.sifterCookTime = var1.func_74765_d("CookTime");
        this.currentItemBurnTime = 100;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        super.func_189515_b(var1);
        var1.func_74777_a("BurnTime", (short)this.sifterBurnTime);
        var1.func_74777_a("CookTime", (short)this.sifterCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)var1, this.stacks);
        return var1;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager netManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int getSiftProgressScaled(int var1) {
        return this.sifterCookTime * var1 / 200;
    }

    public int getSiftTimeRemainingScaled(int var1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 100;
        }
        return this.sifterBurnTime * var1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.sifterBurnTime > 0;
    }

    public void func_73660_a() {
        boolean var1 = this.sifterBurnTime > 0;
        boolean var2 = false;
        if (this.sifterBurnTime > 0) {
            --this.sifterBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.sifterBurnTime == 0 && this.canSmelt()) {
                this.sifterBurnTime = 100;
                this.currentItemBurnTime = 100;
                if (this.sifterBurnTime > 0) {
                    var2 = true;
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.sifterCookTime;
                if (this.sifterCookTime == 200) {
                    this.sifterCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.sifterCookTime = 0;
            }
            if (var1 != this.sifterBurnTime > 0) {
                var2 = true;
                SifterBlock.setState(this.sifterBurnTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        int var1;
        this.spaceIndex = -1;
        this.rawIndex = -1;
        for (var1 = 0; var1 < 1; ++var1) {
            if (((ItemStack)this.stacks.get(var1)).func_190926_b() || !TileEntitySifter.isAnalyzable((ItemStack)this.stacks.get(var1))) continue;
            this.rawIndex = var1;
            break;
        }
        if (this.rawIndex == -1) {
            return false;
        }
        for (var1 = 5; var1 > 0; --var1) {
            if (!((ItemStack)this.stacks.get(var1)).func_190926_b()) continue;
            this.spaceIndex = var1;
            break;
        }
        return this.spaceIndex != -1 && this.rawIndex != -1;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack result = ItemStack.field_190927_a;
            result = FAMachineRecipeRegistry.getSifterRecipeForItem((ItemStack)this.stacks.get(this.rawIndex)).generateOutput(new Random());
            for (int slots = 1; slots < 5; ++slots) {
                ItemStack stackInSlot = (ItemStack)this.stacks.get(slots);
                if (!stackInSlot.func_190926_b()) {
                    if (!stackInSlot.func_77969_a(result) || stackInSlot.func_190916_E() + result.func_190916_E() >= 64) continue;
                    stackInSlot.func_190917_f(result.func_190916_E());
                    if (((ItemStack)this.stacks.get(this.rawIndex)).func_190916_E() > 1) {
                        ((ItemStack)this.stacks.get(this.rawIndex)).func_190918_g(1);
                        break;
                    }
                    this.stacks.set(this.rawIndex, (Object)ItemStack.field_190927_a);
                    break;
                }
                if (!stackInSlot.func_190926_b()) continue;
                this.stacks.set(slots, (Object)result);
                ((ItemStack)this.stacks.get(this.rawIndex)).func_190918_g(1);
                break;
            }
        }
    }

    public boolean isStackValidForSlot(int par1, ItemStack par2ItemStack) {
        return par1 <= 8 && (par1 >= 8 || TileEntitySifter.isItemFuel(par2ItemStack));
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 0 && TileEntitySifter.isItemFuel(par2ItemStack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.sifterCookTime;
            }
            case 1: {
                return this.sifterBurnTime;
            }
            case 2: {
                return this.currentItemBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.sifterCookTime = value;
                break;
            }
            case 1: {
                this.sifterBurnTime = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? slots_top : slots_bottom;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.UP || index != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    public String func_70005_c_() {
        return "tile.sifter.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handlerTop;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum EnumSiftType {
        NONE,
        GROUND,
        SAND;

    }
}

