/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.compat.thaumcraft;

import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.entity.prehistoric.MobType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.TimePeriod;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.variant.DinosaurBoneType;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class ThaumcraftCompat {
    static final Aspect TIME = new Aspect("chronos", 11904578, new Aspect[]{Aspect.EXCHANGE, Aspect.MOTION}, new ResourceLocation("fossil", "textures/thaumcraft/chronos.png"), 1);
    static final Aspect RUIN = new Aspect("anteanus", 9083483, new Aspect[]{Aspect.MAN, TIME}, new ResourceLocation("fossil", "textures/thaumcraft/anteanus.png"), 1);
    static final Aspect FOSSIL = new Aspect("priscus", 10453360, new Aspect[]{Aspect.BEAST, TIME}, new ResourceLocation("fossil", "textures/thaumcraft/priscus.png"), 1);
    private static final ThaumcraftCompat INSTANCE = new ThaumcraftCompat();
    private static boolean registered = false;

    @Deprecated
    static void register() {
        if (registered) {
            throw new RuntimeException("You can only call ThaumcraftCompat.register() once");
        }
        registered = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void aspectRegistrationEvent(AspectRegistryEvent evt) {
        int i;
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.BIOFOSSIL), new AspectList().add(Aspect.EARTH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.AMBER), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRYSTAL, 3).add(TIME, 3));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ANCIENT_CLOCK), new AspectList().add(Aspect.METAL, 15).add(TIME, 15).add(RUIN, 35));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ANCIENT_HELMET, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PROTECT, 10).add(TIME, 10).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ANCIENT_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ANCIENT_KEY), new AspectList().add(Aspect.DESIRE, 10).add(Aspect.METAL, 10).add(TIME, 10).add(RUIN, 25));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ANCIENT_SWORD, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(Aspect.METAL, 10).add(TIME, 10).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.AQUATIC_SCARAB_GEM), new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5).add(Aspect.CRYSTAL, 5).add(Aspect.DESIRE, 5).add(TIME, 5).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.DOMINICAN_AMBER), new AspectList().add(Aspect.WATER, 3).add(Aspect.EARTH, 3).add(Aspect.CRYSTAL, 3).add(TIME, 3));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.BROKEN_HELMET), new AspectList().add(Aspect.ENTROPY, 10).add(TIME, 10).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.BROKEN_SWORD), new AspectList().add(Aspect.ENTROPY, 10).add(TIME, 10).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.CHICKEN_ESSENCE), new AspectList().add(Aspect.CRAFT, 5).add(Aspect.BEAST, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.COOKED_CHICKEN_SOUP), new AspectList().add(Aspect.CRAFT, 10).add(Aspect.BEAST, 10).add(Aspect.WATER, 10));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.COOKED_EGG), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(Aspect.CRAFT, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.TOOTH_DAGGER), new AspectList().add(Aspect.DEATH, 10).add(Aspect.BEAST, 10).add(Aspect.CRAFT, 10).add(Aspect.AVERSION, 10).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SKULL_HELMET, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.RIBCAGE_CHESTPLATE, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 7).add(TIME, 5).add(FOSSIL, 7));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SHIN_LEGGINGS, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 7).add(TIME, 5).add(FOSSIL, 7));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FEET_BOOTS, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
        for (i = 0; i < DinosaurBoneType.values().length; ++i) {
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOOT, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.LEG_BONE, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.UNIQUE_ITEM, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(Aspect.DESIRE, 2).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.RIBCAGE, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SKULL, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.VERTEBRAE, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ARM_BONE, 1, i), new AspectList().add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 5));
        }
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.PALAE_SAPLING_FOSSIL), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.CALAMITES_SAPLING_FOSSIL), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.PLANT_FOSSIL), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 7));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.TAR_FOSSIL), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ALCHEMY, 5).add(Aspect.BEAST, 5).add(TIME, 5).add(FOSSIL, 10));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.TARDROP), new AspectList().add(Aspect.EARTH, 3).add(Aspect.WATER, 3).add(Aspect.DARKNESS, 3).add(Aspect.ALCHEMY, 3).add(Aspect.ENTROPY, 3).add(FOSSIL, 4));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.TOY_BALL, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 8).add(Aspect.SENSES, 8));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.POTTERY_SHARD), new AspectList().add(Aspect.EARTH, 2).add(Aspect.ENTROPY, 2).add(TIME, 2).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SCARAB_GEM), new AspectList().add(Aspect.CRYSTAL, 6).add(Aspect.DESIRE, 6).add(TIME, 6).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.WHIP), new AspectList().add(Aspect.BEAST, 10).add(Aspect.DESIRE, 10).add(Aspect.AVERSION, 10));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.ICED_MEAT), new AspectList().add(Aspect.BEAST, 5).add(Aspect.COLD, 5).add(Aspect.DEATH, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.STONE_TABLET), new AspectList().add(Aspect.EARTH, 5).add(RUIN, 5).add(TIME, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_RECORD_NANO_ANU), new AspectList().add(Aspect.SENSES, 5).add(Aspect.DESIRE, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_RECORD_BONES), new AspectList().add(Aspect.SENSES, 5).add(Aspect.DESIRE, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_RECORD_NANO_DISCOVERING), new AspectList().add(Aspect.SENSES, 5).add(Aspect.DESIRE, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_RECORD_NANO_SCARAB), new AspectList().add(Aspect.SENSES, 5).add(Aspect.DESIRE, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SHELL), new AspectList().add(Aspect.WATER, 5).add(Aspect.PROTECT, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.MAGIC_CONCH), new AspectList().add(Aspect.WATER, 5).add(Aspect.PROTECT, 5).add(Aspect.MAGIC, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.RELIC_SCRAP), new AspectList().add(Aspect.EARTH, 5).add(Aspect.CRAFT, 5).add(TIME, 5).add(RUIN, 5));
        for (i = 0; i < 15; ++i) {
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.SEED, 1, i), new AspectList().add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
            evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED, 1, i), new AspectList().add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
        }
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED_FERN), new AspectList().add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.FERN_SEED), new AspectList().add(Aspect.PLANT, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.DIAMOND_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.GOLD_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.IRON_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.STONE_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 5));
        evt.register.registerObjectTag(new ItemStack((Item)FAItemRegistry.WOODEN_JAVELIN, 1, Short.MAX_VALUE), new AspectList().add(Aspect.AVERSION, 10).add(TIME, 10).add(RUIN, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.FOSSIL), new AspectList().add(Aspect.EARTH, 5).add(TIME, 5).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.AMPHORA_VASE), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.AMPHORA_VASE, 1, 1), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.AMPHORA_VASE, 1, 2), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.AMPHORA_VASE, 1, 3), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.KYLIX_VASE), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.KYLIX_VASE, 1, 1), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.KYLIX_VASE, 1, 2), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.KYLIX_VASE, 1, 3), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLUTE_VASE), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLUTE_VASE, 1, 1), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLUTE_VASE, 1, 2), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLUTE_VASE, 1, 3), new AspectList().add(Aspect.CRAFT, 15).add(Aspect.SENSES, 15).add(Aspect.DESIRE, 15).add(TIME, 8).add(RUIN, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.TIME_MACHINE), new AspectList().add(Aspect.CRAFT, 25).add(Aspect.MOTION, 15).add(Aspect.DESIRE, 15).add(TIME, 25).add(RUIN, 50));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ICED_STONE), new AspectList().add(Aspect.EARTH, 4).add(Aspect.COLD, 4));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.DENSE_SAND), new AspectList().add(Aspect.EARTH, 4).add(Aspect.CRYSTAL, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SKULL_BLOCK), new AspectList().add(Aspect.DEATH, 4).add(RUIN, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SKULL_LANTERN), new AspectList().add(Aspect.DEATH, 4).add(Aspect.LIGHT, 2).add(RUIN, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_ROCK), new AspectList().add(Aspect.FIRE, 4).add(Aspect.EARTH, 4));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_BRICK), new AspectList().add(Aspect.FIRE, 4).add(Aspect.EARTH, 4).add(Aspect.CRAFT, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_SINGLESLAB), new AspectList().add(Aspect.FIRE, 4).add(Aspect.EARTH, 4).add(Aspect.CRAFT, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_DOUBLESLAB), new AspectList().add(Aspect.FIRE, 4).add(Aspect.EARTH, 4).add(Aspect.CRAFT, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_STAIRS), new AspectList().add(Aspect.FIRE, 4).add(Aspect.EARTH, 4).add(Aspect.CRAFT, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VOLCANIC_ASH), new AspectList().add(Aspect.FIRE, 4).add(Aspect.DARKNESS, 4));
        for (i = 0; i < 16; ++i) {
            evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.FIGURINE, 1, i), new AspectList().add(Aspect.MAN, 10).add(TIME, 10).add(RUIN, 10));
        }
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.PALM_LOG), new AspectList().add(Aspect.PLANT, 10).add(TIME, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_GLASS), new AspectList().add(Aspect.CRYSTAL, 5).add(TIME, 5).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.STRONG_GLASS), new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.PROTECT, 4));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD_PLATE), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD_STAIRS), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD_DOUBLESLAB), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD_SINGLESLAB), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_WOOD_PILLAR), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANALYZER), new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.METAL, 25).add(TIME, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANALYZER_ACTIVE), new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.METAL, 25).add(TIME, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.FEEDER), new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.METAL, 25).add(Aspect.BEAST, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.CULTIVATE_IDLE), new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.WATER, 25).add(Aspect.ALCHEMY, 25).add(Aspect.LIFE, 25).add(TIME, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.CULTIVATE_ACTIVEE), new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.WATER, 25).add(Aspect.ALCHEMY, 25).add(Aspect.LIFE, 25).add(TIME, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SIFTER_IDLE), new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.CRAFT, 5).add(Aspect.MOTION, 5).add(Aspect.EARTH, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SIFTER_ACTIVE), new AspectList().add(Aspect.MECHANISM, 10).add(Aspect.CRAFT, 5).add(Aspect.MOTION, 5).add(Aspect.EARTH, 20));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_STONE), new AspectList().add(Aspect.EARTH, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_STONE_BRICK), new AspectList().add(Aspect.EARTH, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_STONE_DOUBLESLAB), new AspectList().add(Aspect.EARTH, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_STONE_SINGLESLAB), new AspectList().add(Aspect.EARTH, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_STONE_STAIRS), new AspectList().add(Aspect.EARTH, 4).add(TIME, 4).add(RUIN, 3));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.DILLHOFFIA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.FOOZIA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.HORSETAIL_LARGE_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.HORSETAIL_SMALL_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.PERMAFROST), new AspectList().add(Aspect.EARTH, 4).add(Aspect.COLD, 4).add(FOSSIL, 2));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SARRACENIA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.FLORISSANTIA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.BENNETTITALES_LARGE_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.BENNETTITALES_SMALL_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.CEPHALOTAXUS_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.CRATAEGUS_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.EPENDRA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.LICOPODIOPHYTA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.OSMUNDA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.TEMPSKYA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.VACCINIUM_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.WELWITSCHIA_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ZAMITES_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.MUTANT_FLOWER), new AspectList().add(Aspect.PLANT, 4).add(Aspect.UNDEAD, 4));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.PALM_SAPLING), new AspectList().add(Aspect.PLANT, 4).add(TIME, 4).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.PALM_LEAVES), new AspectList().add(Aspect.PLANT, 3).add(TIME, 2).add(FOSSIL, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SLIME_TRAIL), new AspectList().add(Aspect.ALCHEMY, 4).add(Aspect.WATER, 4).add(Aspect.UNDEAD, 4));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANCIENT_CHEST), new AspectList().add(Aspect.DESIRE, 20).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANU_STATUE), new AspectList().add(Aspect.DESIRE, 20).add(RUIN, 25));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.OBSIDIAN_SPIKES), new AspectList().add(Aspect.DEATH, 5).add(Aspect.EARTH, 5).add(Aspect.FIRE, 5).add(Aspect.WATER, 5));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANUBITE_STATUE), new AspectList().add(Aspect.DESIRE, 20).add(RUIN, 15));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.SARCOPHAGUS), new AspectList().add(Aspect.DESIRE, 20).add(RUIN, 25));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.ANU_PORTAL), new AspectList().add(Aspect.VOID, 10).add(RUIN, 25).add(Aspect.DARKNESS, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.HOME_PORTAL), new AspectList().add(Aspect.LIFE, 10).add(RUIN, 25).add(Aspect.LIGHT, 10));
        evt.register.registerObjectTag(new ItemStack((Block)FABlockRegistry.DRUM), new AspectList().add(Aspect.MECHANISM, 5).add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(Aspect.BEAST, 10));
        ThaumcraftApi.registerEntityTag((String)"fossil.tyrannosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.AIR, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.triceratops", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.PROTECT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.henodus", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 15).add(Aspect.PROTECT, 20).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.dodo", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.AIR, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.allosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 30).add(Aspect.AIR, 20).add(Aspect.ENERGY, 20).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.ankylosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.PROTECT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.brachiosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.EARTH, 35).add(Aspect.PROTECT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.ceratosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.AVERSION, 20).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.compsognathus", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.AVERSION, 5).add(Aspect.DARKNESS, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.confuciusornis", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.FLIGHT, 5).add(Aspect.AIR, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.kelenken", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 10).add(Aspect.AIR, 5).add(Aspect.AVERSION, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.titanis", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 10).add(Aspect.AIR, 5).add(Aspect.AVERSION, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.gastornis", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 10).add(Aspect.AIR, 5).add(Aspect.AVERSION, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.phorusrhacos", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 10).add(Aspect.AIR, 5).add(Aspect.AVERSION, 5).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.quagga", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.MOTION, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.smilodon", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.COLD, 15).add(Aspect.AVERSION, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.mammoth", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.COLD, 15).add(Aspect.PROTECT, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.coelacanth", (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 5).add(Aspect.DARKNESS, 5).add(TIME, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.alligator_gar", (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 5).add(Aspect.AVERSION, 5).add(TIME, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.sturgeon", (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 5).add(Aspect.DESIRE, 5).add(TIME, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.nautilus", (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.WATER, 5).add(Aspect.PROTECT, 5).add(TIME, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.velociraptor", (AspectList)new AspectList().add(Aspect.BEAST, 13).add(Aspect.AIR, 13).add(Aspect.MOTION, 13).add(TIME, 13), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.dilophosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 13).add(Aspect.AIR, 13).add(Aspect.MOTION, 13).add(TIME, 13), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.elasmotherium", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.COLD, 15).add(Aspect.PROTECT, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.dryosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.AIR, 10).add(Aspect.MOTION, 10).add(TIME, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.gallimimus", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.AIR, 10).add(Aspect.MOTION, 15).add(TIME, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.ichthyosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 15).add(Aspect.SENSES, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.liopleurodon", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 15).add(Aspect.AVERSION, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.mosasaurus", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.WATER, 15).add(Aspect.AVERSION, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.pachycephalosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.AVERSION, 20).add(Aspect.PROTECT, 20).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.pteranodon", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.AIR, 15).add(Aspect.FLIGHT, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.spinosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.WATER, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.parasaurolophus", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 15).add(Aspect.SENSES, 15).add(TIME, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.stegosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.PROTECT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.therizinosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.AIR, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.sarcosuchus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.WATER, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.failuresaurus", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.UNDEAD, 20).add(Aspect.WATER, 20).add(Aspect.ALCHEMY, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.dinoegg", (AspectList)new AspectList().add(Aspect.LIFE, 4).add(Aspect.PROTECT, 4), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.birdegg", (AspectList)new AspectList().add(Aspect.LIFE, 4).add(Aspect.PROTECT, 4), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.anu", (AspectList)new AspectList().add(Aspect.SOUL, 50).add(Aspect.DESIRE, 50).add(Aspect.UNDEAD, 50).add(Aspect.FIRE, 50).add(Aspect.FLIGHT, 50).add(Aspect.DARKNESS, 50), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.tarslime", (AspectList)new AspectList().add(Aspect.LIFE, 10).add(Aspect.ALCHEMY, 10).add(Aspect.WATER, 10).add(Aspect.DARKNESS, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.anubite", (AspectList)new AspectList().add(Aspect.SOUL, 30).add(Aspect.DESIRE, 30).add(Aspect.UNDEAD, 30).add(Aspect.FIRE, 30).add(Aspect.DARKNESS, 30), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.sentrypigman", (AspectList)new AspectList().add(Aspect.SOUL, 30).add(Aspect.DESIRE, 30).add(Aspect.UNDEAD, 30).add(Aspect.FIRE, 30).add(Aspect.DARKNESS, 30), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.friendlypigman", (AspectList)new AspectList().add(Aspect.SOUL, 30).add(Aspect.DESIRE, 30).add(Aspect.UNDEAD, 30).add(Aspect.FIRE, 30).add(Aspect.DARKNESS, 30), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.tikaalik", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.EARTH, 25).add(Aspect.WATER, 25).add(Aspect.EXCHANGE, 15).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.platybelodon", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.WATER, 35).add(Aspect.TOOL, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.diplocaulus", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.WATER, 25).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.crassigyrinus", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.WATER, 25).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.megalania", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.ALCHEMY, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.meganeura", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.WATER, 35).add(Aspect.FLIGHT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.megaloceros", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.EARTH, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.megalograptus", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.WATER, 35).add(Aspect.PROTECT, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.megalodon", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.AVERSION, 35).add(Aspect.WATER, 35).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.edaphosaurus", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.FIRE, 25).add(Aspect.EARTH, 25).add(TIME, 10).add(FOSSIL, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.arthropleura", (AspectList)new AspectList().add(Aspect.BEAST, 45).add(Aspect.PROTECT, 45).add(Aspect.EARTH, 45).add(TIME, 20).add(FOSSIL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.citipati", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(Aspect.ENERGY, 25).add(Aspect.AIR, 25).add(TIME, 10).add(FOSSIL, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.ornitholestes", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.AIR, 15).add(TIME, 10).add(FOSSIL, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.diplodocus", (AspectList)new AspectList().add(Aspect.BEAST, 45).add(Aspect.EARTH, 45).add(TIME, 25).add(FOSSIL, 25), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"fossil.stone_tablet", (AspectList)new AspectList().add(Aspect.EARTH, 10).add(TIME, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        for (PrehistoricEntityType type : PrehistoricEntityType.values()) {
            if (type.timePeriod != TimePeriod.CURRENT) {
                if (type.mobType == MobType.FISH) {
                    evt.register.registerObjectTag(new ItemStack(type.eggItem), new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.PROTECT, 2).add(Aspect.WATER, 2));
                    evt.register.registerObjectTag(new ItemStack(type.fishItem), new AspectList().add(Aspect.BEAST, 15).add(Aspect.LIFE, 5).add(Aspect.WATER, 10));
                }
                if (type.mobType == MobType.DINOSAUR || type.mobType == MobType.DINOSAUR_AQUATIC) {
                    evt.register.registerObjectTag(new ItemStack(type.eggItem), new AspectList().add(Aspect.BEAST, 10).add(Aspect.PROTECT, 5));
                }
                if (type.mobType != MobType.FISH) {
                    evt.register.registerObjectTag(new ItemStack(type.foodItem), new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 5));
                }
                if (type != PrehistoricEntityType.NAUTILUS) {
                    evt.register.registerObjectTag(new ItemStack(type.cookedFoodItem), new AspectList().add(Aspect.BEAST, 5).add(Aspect.FIRE, 2));
                }
            }
            if (type.mobType == MobType.BIRD || type.mobType == MobType.CHICKEN) {
                if (type.mobType == MobType.BIRD) {
                    evt.register.registerObjectTag(new ItemStack(type.birdEggItem), new AspectList().add(Aspect.BEAST, 5).add(Aspect.PROTECT, 2).add(Aspect.AIR, 2));
                }
                evt.register.registerObjectTag(new ItemStack(type.bestBirdEggItem), new AspectList().add(Aspect.BEAST, 10).add(Aspect.PROTECT, 2).add(Aspect.AIR, 2));
            }
            if (type.mobType == MobType.MAMMAL || type.mobType == MobType.VANILLA) {
                evt.register.registerObjectTag(new ItemStack(type.embryoItem), new AspectList().add(Aspect.BEAST, 5).add(Aspect.DESIRE, 5).add(Aspect.LIFE, 3).add(Aspect.CRYSTAL, 3));
            }
            evt.register.registerObjectTag(new ItemStack(type.dnaItem), new AspectList().add(Aspect.BEAST, 15).add(Aspect.LIFE, 5).add(Aspect.DESIRE, 10));
        }
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.FERNS, (ItemStack)new ItemStack((Item)FAItemRegistry.FERN_SEED));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.DILLHOFFIA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 0));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.SARRACENIA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 1));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.CEPHALOTAXUS_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 2));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.LICOPODIOPHYTA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 3));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.FOOZIA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 4));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.ZAMITES_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 5));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.BENNETTITALES_SMALL_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 6));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.WELWITSCHIA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 7));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.HORSETAIL_SMALL_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 8));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.TEMPSKYA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 9));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.VACCINIUM_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 10));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.OSMUNDA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 11));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.CRATAEGUS_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 12));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.FLORISSANTIA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 13));
        ThaumcraftApi.registerSeed((Block)FABlockRegistry.EPENDRA_FLOWER, (ItemStack)new ItemStack((Item)FAItemRegistry.SEED, 1, 14));
    }
}

