/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.compat.tinkers;

import com.google.common.collect.ImmutableList;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.compat.tinkers.TinkersCompat;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.variant.DinosaurBoneType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ModifierArcheology
extends ModifierTrait {
    private boolean fossils;

    public ModifierArcheology(boolean fossils) {
        super(fossils ? "paleontologist" : "archeologist", 11968628, 3, 50);
        this.fossils = fossils;
        this.addAspects(new ModifierAspect[]{new ModifierAspect.MultiAspect((IModifier)this, 3, 50, 1), ModifierAspect.harvestOnly});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void blockDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)event.getHarvester(), (IBlockState)event.getState());
        if (tool != null && tool.func_77973_b() instanceof ToolCore && !ToolHelper.isBroken((ItemStack)tool)) {
            NBTTagList list = TagUtil.getTagListSafe((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)"Modifiers", (int)TagUtil.TAG_TYPE_COMPOUND);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String identity = list.func_150307_f(i);
                String identifier = identity.substring(13, identity.indexOf("\","));
                ITrait trait = TinkerRegistry.getTrait((String)identifier);
                if (trait == null) continue;
                trait.blockHarvestDrops(tool, event);
            }
        }
    }

    private int getLevel(ItemStack tool) {
        return ModifierNBT.readInteger((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)tool, (String)this.getModifierIdentifier())).level;
    }

    public boolean canApplyTogether(IToolMod toolmod) {
        String id = toolmod.getIdentifier();
        return !id.equals(this.fossils ? TinkersCompat.archeologistModifier.getIdentifier() : TinkersCompat.fossilModifier.getIdentifier());
    }

    public boolean hasTexturePerMaterial() {
        return false;
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == FABlockRegistry.FOSSIL) {
            event.getDrops().clear();
            int i = 0;
            while ((double)i < Math.max(Math.ceil((double)this.getLevel(tool) / 2.0), 1.0)) {
                if (this.fossils) {
                    event.getDrops().add(this.getRandomFossilDrop(tool, random));
                } else {
                    event.getDrops().add(this.getRandomRelicDrop(tool, random));
                }
                ++i;
            }
        }
    }

    private ItemStack getRandomFossilDrop(ItemStack tool, Random rand) {
        int i = rand.nextInt(100);
        if (i < 2) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.LEG_BONE, 1, dropRandom);
        }
        if (i < 4) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.SKULL, 1, dropRandom);
        }
        if (i < 6) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.UNIQUE_ITEM, 1, dropRandom);
        }
        if (i < 8) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.FOOT, 1, dropRandom);
        }
        if (i < 10) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.VERTEBRAE, 1, dropRandom);
        }
        if (i < 12) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.ARM_BONE, 1, dropRandom);
        }
        if (i < 14) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.RIBCAGE, 1, dropRandom);
        }
        if (i < 30) {
            return new ItemStack((Block)FABlockRegistry.SKULL_BLOCK);
        }
        if (i < 60) {
            return new ItemStack((Item)FAItemRegistry.PLANT_FOSSIL);
        }
        return new ItemStack((Item)FAItemRegistry.BIOFOSSIL);
    }

    private ItemStack getRandomRelicDrop(ItemStack tool, Random rand) {
        int i = rand.nextInt(1000);
        if (i < this.getLevel(tool) * 5) {
            return new ItemStack((Item)FAItemRegistry.SCARAB_GEM);
        }
        if (i < 900) {
            return new ItemStack((Item)FAItemRegistry.RELIC_SCRAP);
        }
        if (i < 950) {
            return new ItemStack((Item)FAItemRegistry.BROKEN_SWORD);
        }
        return new ItemStack((Item)FAItemRegistry.BROKEN_HELMET);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
    }

    public int getColor() {
        return this.color;
    }

    public List<List<ItemStack>> getItems() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecipeMatch rm : this.items) {
            List in = rm.getInputs();
            if (in.isEmpty()) continue;
            builder.add((Object)in);
        }
        return builder.build();
    }
}

