/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.OrderType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class EntityPrehistoricFlocking
extends EntityPrehistoric {
    private int groupSize = 1;
    private EntityPrehistoricFlocking groupLeader;

    public EntityPrehistoricFlocking(World world, PrehistoricEntityType type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed, double baseArmor, double maxArmor) {
        super(world, type, baseDamage, maxDamage, baseHealth, maxHealth, baseSpeed, maxSpeed, baseArmor, maxArmor);
    }

    @Override
    public boolean doesFlock() {
        return true;
    }

    public void leaveGroup() {
        this.groupLeader.decreaseGroupSize();
        this.groupLeader = null;
    }

    protected boolean hasNoLeader() {
        return !this.hasGroupLeader();
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null && this.groupLeader.func_70089_S();
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.func_70068_e((Entity)this.groupLeader) <= 121.0;
    }

    public void moveToGroupLeader() {
        if (this.hasGroupLeader()) {
            Vec3d vec = RandomPositionGenerator.func_191377_b((EntityCreature)this.groupLeader, (int)5, (int)7);
            if (this.func_70068_e((Entity)this.groupLeader) <= 44.0) {
                vec = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)6, (int)7);
            }
            if (vec != null) {
                this.func_70661_as().func_75492_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0);
            }
        }
    }

    public EntityPrehistoricFlocking createAndSetLeader(EntityPrehistoricFlocking leader) {
        this.groupLeader = leader;
        leader.increaseGroupSize();
        return leader;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) == null) {
            livingdata = new GroupData(this);
        } else {
            this.createAndSetLeader(((GroupData)livingdata).groupLeader);
        }
        return livingdata;
    }

    public void createFromStream(Stream<EntityPrehistoricFlocking> stream) {
        stream.limit(this.getMaxGroupSize() - this.groupSize).filter(fishe -> fishe != this).forEach(fishe -> fishe.createAndSetLeader(this));
    }

    protected abstract int getMaxGroupSize();

    @Override
    public void func_70636_d() {
        List lvt_1_1_;
        super.func_70636_d();
        if (this.isGroupLeader() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (lvt_1_1_ = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_72314_b(this.getGroupDist(), this.getGroupDist(), this.getGroupDist()))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    protected double getGroupDist() {
        return 32.0;
    }

    public boolean shouldFollowFlock() {
        return !this.isSleeping() && !this.func_70906_o() && this.getOrderType() != OrderType.FOLLOW;
    }

    public boolean shouldWanderInFlock() {
        return this.shouldFollowFlock() && this.func_70638_az() == null;
    }

    public static class GroupData
    implements IEntityLivingData {
        public final EntityPrehistoricFlocking groupLeader;

        public GroupData(EntityPrehistoricFlocking groupLeaderIn) {
            this.groupLeader = groupLeaderIn;
        }
    }
}

