/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.server.entity.prehistoric.Diet;
import fossilsarcheology.server.entity.prehistoric.EntityAlligatorGar;
import fossilsarcheology.server.entity.prehistoric.EntityAllosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityAnkylosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityArthropleura;
import fossilsarcheology.server.entity.prehistoric.EntityBrachiosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityCeratosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityCitipati;
import fossilsarcheology.server.entity.prehistoric.EntityCoelacanth;
import fossilsarcheology.server.entity.prehistoric.EntityCompsognathus;
import fossilsarcheology.server.entity.prehistoric.EntityConfuciusornis;
import fossilsarcheology.server.entity.prehistoric.EntityCrassigyrinus;
import fossilsarcheology.server.entity.prehistoric.EntityDeinonychus;
import fossilsarcheology.server.entity.prehistoric.EntityDilophosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityDiplocaulus;
import fossilsarcheology.server.entity.prehistoric.EntityDiplodocus;
import fossilsarcheology.server.entity.prehistoric.EntityDodo;
import fossilsarcheology.server.entity.prehistoric.EntityDryosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityEdaphosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityElasmotherium;
import fossilsarcheology.server.entity.prehistoric.EntityGallimimus;
import fossilsarcheology.server.entity.prehistoric.EntityGastornis;
import fossilsarcheology.server.entity.prehistoric.EntityHenodus;
import fossilsarcheology.server.entity.prehistoric.EntityIcthyosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityKelenken;
import fossilsarcheology.server.entity.prehistoric.EntityLiopleurodon;
import fossilsarcheology.server.entity.prehistoric.EntityMammoth;
import fossilsarcheology.server.entity.prehistoric.EntityMegalania;
import fossilsarcheology.server.entity.prehistoric.EntityMegaloceros;
import fossilsarcheology.server.entity.prehistoric.EntityMegalodon;
import fossilsarcheology.server.entity.prehistoric.EntityMegalograptus;
import fossilsarcheology.server.entity.prehistoric.EntityMeganeura;
import fossilsarcheology.server.entity.prehistoric.EntityMosasaurus;
import fossilsarcheology.server.entity.prehistoric.EntityNautilus;
import fossilsarcheology.server.entity.prehistoric.EntityOrnitholestes;
import fossilsarcheology.server.entity.prehistoric.EntityPachycephalosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityParasaurolophus;
import fossilsarcheology.server.entity.prehistoric.EntityPhorusrhacos;
import fossilsarcheology.server.entity.prehistoric.EntityPlatybelodon;
import fossilsarcheology.server.entity.prehistoric.EntityPlesiosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityPteranodon;
import fossilsarcheology.server.entity.prehistoric.EntityQuagga;
import fossilsarcheology.server.entity.prehistoric.EntitySarcosuchus;
import fossilsarcheology.server.entity.prehistoric.EntitySmilodon;
import fossilsarcheology.server.entity.prehistoric.EntitySpinosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityStegosaurus;
import fossilsarcheology.server.entity.prehistoric.EntitySturgeon;
import fossilsarcheology.server.entity.prehistoric.EntityTherizinosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityTiktaalik;
import fossilsarcheology.server.entity.prehistoric.EntityTitanis;
import fossilsarcheology.server.entity.prehistoric.EntityTriceratops;
import fossilsarcheology.server.entity.prehistoric.EntityTyrannosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityVelociraptor;
import fossilsarcheology.server.entity.prehistoric.MobType;
import fossilsarcheology.server.entity.prehistoric.TimePeriod;
import fossilsarcheology.server.item.BirdEggItem;
import fossilsarcheology.server.item.DNAItem;
import fossilsarcheology.server.item.DinoEggItem;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.FishItem;
import fossilsarcheology.server.item.ItemDinoMeat;
import fossilsarcheology.server.item.MammalEmbryoItem;
import fossilsarcheology.server.item.PrehistoricEntityItem;
import fossilsarcheology.server.tab.FATabRegistry;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;

public enum PrehistoricEntityType {
    PIG(EntityPig.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.OMNIVORE, 0, 0, 0),
    COW(EntityCow.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    SHEEP(EntitySheep.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    HORSE(EntityHorse.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    DONKEY(EntityDonkey.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    CHICKEN(EntityChicken.class, MobType.CHICKEN, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    PARROT(EntityParrot.class, MobType.CHICKEN, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    POLARBEAR(EntityPolarBear.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    RABBIT(EntityRabbit.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    LLAMA(EntityLlama.class, MobType.VANILLA, TimePeriod.CURRENT, Diet.HERBIVORE, 0, 0, 0),
    NAUTILUS(EntityNautilus.class, MobType.FISH, TimePeriod.MESOZOIC, Diet.NONE, 0, 12934983, 0xF5F5F5),
    COELACANTH(EntityCoelacanth.class, MobType.FISH, TimePeriod.MESOZOIC, Diet.NONE, 0, 3553601, 10199465),
    ALLIGATOR_GAR(EntityAlligatorGar.class, MobType.FISH, TimePeriod.MESOZOIC, Diet.NONE, 0, 4408874, 11485745),
    STURGEON(EntitySturgeon.class, MobType.FISH, TimePeriod.MESOZOIC, Diet.NONE, 0, 6643035, 0xE6E3E3),
    TRICERATOPS(EntityTriceratops.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 29, 6567213, 2431511, 0.8f, 128),
    VELOCIRAPTOR(EntityVelociraptor.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE_EGG, 10, 4852996, 0xC9C9C9, 0.5f),
    TYRANNOSAURUS(EntityTyrannosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE, 30, 10324596, 4993302, 0.9f, 128),
    PTEROSAUR(EntityPteranodon.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.PISCIVORE, 14, 0xD6D6D6, 0x3B3B3B, 0.4f),
    PLESIOSAUR(EntityPlesiosaurus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.PISCIVORE, 30, 14985326, 14776608),
    MOSASAURUS(EntityMosasaurus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.PISCCARNIVORE, 6, 8949136, 3820626, 1.0f, 128),
    STEGOSAURUS(EntityStegosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 13, 10256696, 6625303, 0.7f, 128),
    DILOPHOSAURUS(EntityDilophosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE, 10, 5134641, 15880980, 0.5f),
    BRACHIOSAURUS(EntityBrachiosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 29, 5395006, 0x222114, 1.0f, 128),
    SPINOSAURUS(EntitySpinosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.PISCCARNIVORE, 6, 8671530, 5648160, 0.8f, 128),
    COMPSOGNATHUS(EntityCompsognathus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE, 14, 13354948, 3813676, 0.2f),
    ANKYLOSAURUS(EntityAnkylosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 29, 9067337, 2169619, 0.7f, 128),
    PACHYCEPHALOSAURUS(EntityPachycephalosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 9, 11970953, 8216122, 0.6f, 128),
    DEINONYCHUS(EntityDeinonychus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE_EGG, 14, 0x2B2424, 0xC8C8C8, 0.6f),
    GALLIMIMUS(EntityGallimimus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.OMNIVORE, 31, 6701355, 6169880, 0.5f),
    LIOPLEURODON(EntityLiopleurodon.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.PISCCARNIVORE, 6, 12568514, 1909022),
    ALLOSAURUS(EntityAllosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE, 30, 9468780, 6242861, 0.8f, 128),
    SARCOSUCHUS(EntitySarcosuchus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.PISCCARNIVORE, 10, 4933929, 9276517, 0.7f, 128),
    CERATOSAURUS(EntityCeratosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE, 30, 11842727, 0x776446, 0.6f),
    DRYOSAURUS(EntityDryosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 13, 7359526, 12959898, 0.6f),
    THERIZINOSAURUS(EntityTherizinosaurus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 13, 0x322212, 13278322, 0.8f, 128),
    PARASAUROLOPHUS(EntityParasaurolophus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 13, 8293936, 5002296, 1.0f, 128),
    CITIPATI(EntityCitipati.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.OMNIVORE, 13, 6179390, 0x667373, 0.6f),
    DIPLODOCUS(EntityDiplodocus.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.HERBIVORE, 29, 0x937373, 14342343, 1.0f, 128),
    ORNITHOLESTES(EntityOrnitholestes.class, MobType.DINOSAUR, TimePeriod.MESOZOIC, Diet.CARNIVORE_EGG, 30, 3088922, 12859428, 0.5f),
    HENODUS(EntityHenodus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.HERBIVORE, 9, 6372391, 10256480),
    ICTHYOSAURUS(EntityIcthyosaurus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, Diet.PISCIVORE, 10, 2762290, 13550230),
    MEGANEURA(EntityMeganeura.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.PISCCARNIVORE, 14, 6966335, 14726234),
    MEGALOGRAPTUS(EntityMegalograptus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.PISCIVORE, 14, 11693893, 7419673),
    CONFUCIUSORNIS(EntityConfuciusornis.class, MobType.BIRD, TimePeriod.MESOZOIC, Diet.HERBIVORE, 9, 14345705, 0x8B8B8D),
    DODO(EntityDodo.class, MobType.BIRD, TimePeriod.CENOZOIC, Diet.HERBIVORE, 9, 6641489, 12493947),
    GASTORNIS(EntityGastornis.class, MobType.BIRD, TimePeriod.CENOZOIC, Diet.HERBIVORE, 8, 3435614, 0xC8C8C8),
    KELENKEN(EntityKelenken.class, MobType.BIRD, TimePeriod.CENOZOIC, Diet.CARNIVORE, 8, 3747620, 15920085),
    PHORUSRHACOS(EntityPhorusrhacos.class, MobType.BIRD, TimePeriod.CENOZOIC, Diet.CARNIVORE, 8, 6245950, 0xD4D4D4),
    TITANIS(EntityTitanis.class, MobType.BIRD, TimePeriod.CENOZOIC, Diet.CARNIVORE, 8, 0x484848, 0xEFEFEF),
    MAMMOTH(EntityMammoth.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.HERBIVORE, 25, 4009497, 2365195, 1.0f, 128),
    SMILODON(EntitySmilodon.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.CARNIVORE, 10, 12094564, 15523790),
    QUAGGA(EntityQuagga.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.HERBIVORE, 25, 7748644, 13875627),
    ELASMOTHERIUM(EntityElasmotherium.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.HERBIVORE, 25, 7025179, 0x666666, 1.0f, 128),
    MEGALOCEROS(EntityMegaloceros.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.HERBIVORE, 25, 6041114, 9329211),
    MEGALANIA(EntityMegalania.class, MobType.DINOSAUR, TimePeriod.CENOZOIC, Diet.CARNIVORE_EGG, 26, 7164989, 14462579),
    MEGALODON(EntityMegalodon.class, MobType.DINOSAUR_AQUATIC, TimePeriod.CENOZOIC, Diet.PISCCARNIVORE, 6, 6912894, 0xD0D5D5),
    PLATYBELODON(EntityPlatybelodon.class, MobType.MAMMAL, TimePeriod.CENOZOIC, Diet.HERBIVORE, 25, 9135441, 6440762),
    TIKTAALIK(EntityTiktaalik.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.PISCCARNIVORE, 14, 6969882, 14143385),
    CRASSIGYRINUS(EntityCrassigyrinus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.PISCIVORE, 14, 13268794, 9390893),
    DIPLOCAULUS(EntityDiplocaulus.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.PISCIVORE, 14, 11576192, 8165012),
    EDAPHOSAURUS(EntityEdaphosaurus.class, MobType.DINOSAUR, TimePeriod.PALEOZOIC, Diet.HERBIVORE, 13, 6580029, 11898435),
    ARTHROPLEURA(EntityArthropleura.class, MobType.DINOSAUR_AQUATIC, TimePeriod.PALEOZOIC, Diet.HERBIVORE, 13, 2763052, 9917215);

    public static final ResourceLocation DINOSAUR_LOOT;
    public static final ResourceLocation FISH_LOOT;
    public static final ResourceLocation BONELESS_LOOT;
    public static final ResourceLocation MAMMOTH_LOOT;
    public static final ResourceLocation NAUTILUS_LOOT;
    public final MobType mobType;
    public final Diet diet;
    public final TimePeriod timePeriod;
    public final int primaryEggColor;
    public final int secondaryEggColor;
    public final float eggScale;
    public final String friendlyName;
    public final String resourceName;
    private final Class<? extends Entity> entity;
    public int maximimAge = 999;
    public int adultAge = 6;
    public int teenAge = 3;
    public double minHealth = 20.0;
    public double maxHealth = 20.0;
    public double minStrength = 2.0;
    public double maxStrength = 2.0;
    public double minSpeed = 0.25;
    public double maxSpeed = 0.3;
    public int breedTicks = 3000;
    public int ageTicks = 12000;
    public int maxHunger = 100;
    public float hungerLevel = 0.8f;
    public float experience = 1.0f;
    public float experienceIncrement = 0.2f;
    public int parameters = 0;
    public Item orderItem;
    public Item fishItem;
    public Item foodItem;
    public Item cookedFoodItem;
    public Item dnaItem;
    public Item eggItem;
    public Item embryoItem;
    public Item birdEggItem;
    public Item bestBirdEggItem;
    public int maxRenderDistance = 64;

    private PrehistoricEntityType(Class<? extends Entity> entity, MobType mobType, TimePeriod period, Diet diet, int parameters, int primaryEggColor, int secondaryEggColor) {
        this.entity = entity;
        this.mobType = mobType;
        this.timePeriod = period;
        this.diet = diet;
        this.parameters = parameters;
        this.primaryEggColor = primaryEggColor;
        this.secondaryEggColor = secondaryEggColor;
        this.eggScale = 1.0f;
        this.resourceName = this.name().toLowerCase(Locale.ENGLISH);
        this.friendlyName = this.name().toUpperCase(Locale.ENGLISH).substring(0, 1) + this.resourceName.substring(1);
    }

    private PrehistoricEntityType(Class<? extends Entity> entity, MobType mobType, TimePeriod period, Diet diet, int parameters, int primaryEggColor, int secondaryEggColor, float eggScale) {
        this.entity = entity;
        this.mobType = mobType;
        this.timePeriod = period;
        this.diet = diet;
        this.parameters = parameters;
        this.primaryEggColor = primaryEggColor;
        this.secondaryEggColor = secondaryEggColor;
        this.eggScale = eggScale;
        this.resourceName = this.name().toLowerCase(Locale.ENGLISH);
        this.friendlyName = this.name().toUpperCase(Locale.ENGLISH).substring(0, 1) + this.resourceName.substring(1);
    }

    private PrehistoricEntityType(Class<? extends Entity> entity, MobType mobType, TimePeriod period, Diet diet, int parameters, int primaryEggColor, int secondaryEggColor, float eggScale, int trackingRange) {
        this(entity, mobType, period, diet, parameters, primaryEggColor, secondaryEggColor, eggScale);
        this.maxRenderDistance = trackingRange;
    }

    public static void register(RegistryEvent.Register<Item> event) {
        for (PrehistoricEntityType type : PrehistoricEntityType.values()) {
            MobType mobType = type.mobType;
            String resourceName = type.resourceName;
            type.dnaItem = new DNAItem(type);
            FAItemRegistry.registerItem(event, type.dnaItem, ((PrehistoricEntityItem)type.dnaItem).resourceName);
            if (mobType == MobType.FISH) {
                type.eggItem = new FishItem(type, true);
                type.fishItem = new FishItem(type, false);
                FAItemRegistry.registerItem(event, type.eggItem, ((PrehistoricEntityItem)type.eggItem).resourceName);
                FAItemRegistry.registerItem(event, type.fishItem, ((PrehistoricEntityItem)type.fishItem).resourceName);
            } else if (mobType == MobType.DINOSAUR || mobType == MobType.DINOSAUR_AQUATIC) {
                type.eggItem = new DinoEggItem(type);
                FAItemRegistry.registerItem(event, type.eggItem, ((PrehistoricEntityItem)type.eggItem).resourceName);
            }
            if (mobType == MobType.MAMMAL || mobType == MobType.VANILLA) {
                type.embryoItem = new MammalEmbryoItem(type);
                FAItemRegistry.registerItem(event, type.embryoItem, ((PrehistoricEntityItem)type.embryoItem).resourceName);
            }
            if (mobType == MobType.BIRD || mobType == MobType.CHICKEN) {
                if (mobType == MobType.BIRD) {
                    type.birdEggItem = new BirdEggItem(type, false);
                    FAItemRegistry.registerItem(event, type.birdEggItem, ((PrehistoricEntityItem)type.birdEggItem).resourceName);
                }
                type.bestBirdEggItem = new BirdEggItem(type, true);
                FAItemRegistry.registerItem(event, type.bestBirdEggItem, ((PrehistoricEntityItem)type.bestBirdEggItem).resourceName);
            }
            if (type.timePeriod == TimePeriod.CURRENT) continue;
            if (type.mobType != MobType.FISH) {
                type.foodItem = new ItemDinoMeat(3, 0.3f, true, "meat", type).func_77655_b("raw" + type.friendlyName).func_77637_a(FATabRegistry.ITEMS);
                FAItemRegistry.registerItem(event, type.foodItem, resourceName + "_meat");
            }
            if (type == NAUTILUS) continue;
            type.cookedFoodItem = new ItemDinoMeat(8, 0.8f, true, "cooked", type).func_77655_b("cooked" + type.friendlyName).func_77637_a(FATabRegistry.ITEMS);
            FAItemRegistry.registerItem(event, type.cookedFoodItem, resourceName + "_cooked");
        }
    }

    public static boolean isDNA(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.dnaItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isDinoEgg(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.DINOSAUR && entity.mobType != MobType.DINOSAUR_AQUATIC || entity.eggItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isFoodItem(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.foodItem != item) continue;
            return true;
        }
        return false;
    }

    public static Item getDNA(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.bestBirdEggItem != item && entity.birdEggItem != item && entity.embryoItem != item && entity.foodItem != item && entity.eggItem != item) continue;
            return entity.dnaItem;
        }
        return null;
    }

    public static boolean isEmbryo(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.MAMMAL && entity.mobType != MobType.VANILLA || entity.embryoItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBirdEgg(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.BIRD || entity.birdEggItem != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isBestBirdEgg(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.BIRD && entity.mobType != MobType.CHICKEN || entity.bestBirdEggItem != item) continue;
            return true;
        }
        return false;
    }

    public static Item getFoodItem(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.bestBirdEggItem != item && entity.birdEggItem != item && entity.embryoItem != item && entity.dnaItem != item && entity.eggItem != item) continue;
            return entity.foodItem;
        }
        return null;
    }

    public static Item getEgg(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (!(entity.mobType != MobType.DINOSAUR && entity.mobType != MobType.DINOSAUR_AQUATIC || entity.foodItem != item && entity.dnaItem != item)) {
                return entity.eggItem;
            }
            if (entity.mobType != MobType.FISH || entity.dnaItem != item) continue;
            return entity.eggItem;
        }
        return null;
    }

    public static Item getEmbryo(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.MAMMAL && entity.mobType != MobType.VANILLA || entity.dnaItem != item && entity.foodItem != item) continue;
            return entity.embryoItem;
        }
        return null;
    }

    public static Item getBirdEgg(Item item) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.BIRD || entity.bestBirdEggItem != item && entity.dnaItem != item && entity.foodItem != item) continue;
            return entity.birdEggItem;
        }
        return null;
    }

    public static Item getBestBirdEgg(Item i0) {
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.mobType != MobType.BIRD && entity.mobType != MobType.CHICKEN || entity.birdEggItem != i0 && entity.dnaItem != i0 && entity.foodItem != i0) continue;
            return entity.bestBirdEggItem;
        }
        return null;
    }

    public static int getIndex(Item item) {
        for (int index = 0; index < PrehistoricEntityType.values().length; ++index) {
            PrehistoricEntityType entity = PrehistoricEntityType.values()[index];
            if (entity.bestBirdEggItem != item && entity.embryoItem != item && entity.birdEggItem != item && entity.dnaItem != item && entity.foodItem != item && entity.eggItem != item) continue;
            return index;
        }
        return -1;
    }

    public static PrehistoricEntityType getRandomTimePeriod(Random random, TimePeriod ... periods) {
        ArrayList<PrehistoricEntityType> mesozoic = new ArrayList<PrehistoricEntityType>();
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            for (TimePeriod period : periods) {
                if (entity.timePeriod != period) continue;
                mesozoic.add(entity);
            }
        }
        int index = mesozoic.size() < 1 ? 0 : random.nextInt(mesozoic.size());
        return (PrehistoricEntityType)((Object)mesozoic.get(index));
    }

    public static List<PrehistoricEntityType> getTimePeriodList(TimePeriod ... periods) {
        ArrayList<PrehistoricEntityType> mesozoic = new ArrayList<PrehistoricEntityType>();
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            for (TimePeriod period : periods) {
                if (entity.timePeriod != period) continue;
                mesozoic.add(entity);
            }
        }
        return mesozoic;
    }

    public static Item getRandomDNA(Random random, TimePeriod period) {
        return PrehistoricEntityType.getRandomTimePeriod((Random)random, (TimePeriod[])new TimePeriod[]{period}).dnaItem;
    }

    public static PrehistoricEntityType getRandomBioFossil(Random random, boolean tar) {
        ArrayList<PrehistoricEntityType> entities = new ArrayList<PrehistoricEntityType>();
        for (int i = 0; i < PrehistoricEntityType.values().length; ++i) {
            PrehistoricEntityType type = PrehistoricEntityType.values()[i];
            if (type.mobType == MobType.VANILLA || type.mobType == MobType.CHICKEN || type.mobType == MobType.FISH || type == QUAGGA) continue;
            if (tar) {
                if (type.timePeriod != TimePeriod.CENOZOIC || !EntityPrehistoric.class.isAssignableFrom(type.entity)) continue;
                entities.add(type);
                continue;
            }
            if (type.timePeriod != TimePeriod.MESOZOIC && type.timePeriod != TimePeriod.PALEOZOIC) continue;
            entities.add(type);
        }
        int index = random.nextInt(entities.size());
        return (PrehistoricEntityType)((Object)entities.get(index));
    }

    public static PrehistoricEntityType getRandom() {
        int index = ThreadLocalRandom.current().nextInt(PrehistoricEntityType.values().length);
        return PrehistoricEntityType.values()[index];
    }

    public static int getBones() {
        ArrayList<PrehistoricEntityType> bones = new ArrayList<PrehistoricEntityType>();
        for (PrehistoricEntityType entity : PrehistoricEntityType.values()) {
            if (entity.timePeriod == TimePeriod.CURRENT && entity.mobType == MobType.FISH) continue;
            bones.add(entity);
        }
        return bones.size();
    }

    public static boolean isMammal(Entity entity) {
        String className = entity.getClass().getSimpleName();
        return entity instanceof AbstractHorse || entity instanceof EntityCow || entity instanceof EntityPig || entity instanceof EntitySheep || entity instanceof EntityRabbit || entity instanceof EntityPrehistoric && ((EntityPrehistoric)entity).type.mobType == MobType.MAMMAL || entity instanceof EntityPolarBear || entity instanceof EntityWolf || entity instanceof EntityOcelot || entity instanceof EntityBat || className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") || className.contains("Rabbit") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Sow") || className.contains("Hog");
    }

    public static boolean isMale(Entity entity) {
        return entity instanceof EntityPrehistoric && ((EntityPrehistoric)entity).getGender() == 1;
    }

    public Entity invokeClass(World world) {
        EntityPig entity = null;
        if (Entity.class.isAssignableFrom(this.entity)) {
            try {
                entity = this.entity.getDeclaredConstructor(World.class).newInstance(world);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        if (entity == null) {
            entity = new EntityPig(world);
        }
        return entity;
    }

    private void setOrderItem(Item order) {
        this.orderItem = order;
    }

    private void setAges(int teenAge, int adultAge, int maxAge) {
        if (teenAge > 0) {
            this.teenAge = teenAge;
        }
        if (adultAge > 0) {
            this.adultAge = adultAge;
        }
        if (maxAge > 0) {
            this.maximimAge = maxAge;
        }
    }

    private void setDinoSize(float sizeBaby, float sizeTeen, float sizeAdult) {
    }

    private void setProperties(double minHealth, double maxHealth, double minStrength, double maxStrength, double minSpeed, double maxSpeed, int maxHunger) {
        if (minHealth > 0.0) {
            this.minHealth = minHealth;
        }
        if (minStrength > 0.0) {
            this.minStrength = minStrength;
        }
        if (minSpeed > 0.0) {
            this.minSpeed = minSpeed;
        }
        if (maxHealth > 0.0) {
            this.maxHealth = maxHealth;
        }
        if (maxStrength > 0.0) {
            this.maxStrength = maxStrength;
        }
        if (maxSpeed > 0.0) {
            this.maxSpeed = maxSpeed;
        }
        if (maxHunger > 0) {
            this.maxHunger = maxHunger;
        }
    }

    private void setProperties(int breedTicks, int ageTicks, float hungerLevel) {
        if (breedTicks > 0) {
            this.breedTicks = breedTicks;
        }
        if (ageTicks > 0) {
            this.ageTicks = ageTicks;
        }
        if (hungerLevel > 0.0f) {
            this.hungerLevel = hungerLevel;
        }
    }

    public boolean isVivariousAquatic() {
        return this.mobType == MobType.DINOSAUR_AQUATIC && this != SARCOSUCHUS;
    }

    private void setExperience(float experience, float experienceIncrement) {
        if (experience > 0.0f) {
            this.experience = experience;
        }
        if (experienceIncrement > 0.0f) {
            this.experienceIncrement = experienceIncrement;
        }
    }

    public Class<? extends Entity> getEntity() {
        return this.entity;
    }

    public boolean isModelable() {
        return (this.parameters & 4) != 0;
    }

    public boolean isTameable() {
        return (this.parameters & 8) != 0;
    }

    public boolean isRideable() {
        return (this.parameters & 0x10) != 0;
    }

    public boolean canCarryItems() {
        return (this.parameters & 0x20) != 0;
    }

    public boolean useFeeder() {
        return this.diet != Diet.NONE && this.diet != Diet.INSECTIVORE && this.diet != Diet.PISCIVORE;
    }

    public boolean isHerbivore() {
        return (this.parameters & 1) != 0;
    }

    public boolean isCarnivore() {
        return (this.parameters & 2) != 0;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    static {
        DINOSAUR_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "prehistoric/dinosaur"));
        FISH_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "prehistoric/fish"));
        BONELESS_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "prehistoric/dinosaur_boneless"));
        MAMMOTH_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "prehistoric/mammoth"));
        NAUTILUS_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "prehistoric/nautilus"));
    }

    static interface Parameter {
        public static final int NOTHING = 0;
        public static final int NO_FEEDER = 0;
        public static final int HERBIVORE = 1;
        public static final int CARNIVORE = 2;
        public static final int HERB_CARN = 3;
        public static final int MODEL = 4;
        public static final int TAME = 8;
        public static final int RIDE = 16;
        public static final int CARRY = 32;
    }
}

