/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.projectile;

import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.MobType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBirdEgg
extends EntityThrowable {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityBirdEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    final boolean cultivated;

    public EntityBirdEgg(World par1World) {
        super(par1World);
        this.cultivated = false;
    }

    public EntityBirdEgg(boolean cultivated, World par1World) {
        super(par1World);
        this.cultivated = cultivated;
    }

    public EntityBirdEgg(boolean cultivated, World par1World, double posX, double posY, double posZ) {
        super(par1World);
        this.cultivated = cultivated;
        this.field_70165_t = posX;
        this.field_70163_u = posY;
        this.field_70161_v = posZ;
    }

    public EntityBirdEgg(World par1World, EntityLivingBase par2EntityLivingBase, boolean cultivated) {
        super(par1World, par2EntityLivingBase);
        this.cultivated = cultivated;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)PrehistoricEntityType.CHICKEN.ordinal());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Type", this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74762_e("Type"));
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(int ordinal) {
        this.field_70180_af.func_187227_b(TYPE, (Object)ordinal);
    }

    public PrehistoricEntityType getEnumType() {
        return PrehistoricEntityType.values()[MathHelper.func_76125_a((int)this.getType(), (int)0, (int)(PrehistoricEntityType.values().length - 1))];
    }

    public void setEnumType(PrehistoricEntityType type) {
        this.setType(type.ordinal());
    }

    public String getTexture() {
        return this.cultivated ? "fossil/items/prehistoric/birdEggs/Egg_" + this.getEnumType().toString() + ".png" : "fossil/items/prehistoric/birdEggs/Egg_Cultivated" + this.getEnumType().toString() + ".png";
    }

    protected void func_70184_a(RayTraceResult par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null) {
            par1MovingObjectPosition.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        if (this.cultivated) {
            this.spawnAnimal();
        } else if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(8) == 0) {
            int b0 = 1;
            if (this.field_70146_Z.nextInt(32) == 0) {
                b0 = 4;
            }
            for (int i = 0; i < b0; ++i) {
                this.spawnAnimal();
            }
            for (int j = 0; j < 8; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    private void spawnAnimal() {
        if (this.getEnumType().mobType != MobType.CHICKEN) {
            EntityPrehistoric mob = (EntityPrehistoric)this.getEnumType().invokeClass(this.field_70170_p);
            if (!this.field_70170_p.field_72995_K && mob != null) {
                mob.setAgeInDays(0);
                mob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)mob);
                mob.func_70903_f(true);
                if (this.field_70170_p.func_72890_a((Entity)mob, 5.0) != null) {
                    mob.func_184754_b(this.field_70170_p.func_72890_a((Entity)mob, 5.0).func_110124_au());
                }
                mob.setGender(new Random().nextBoolean() ? 0 : 1);
            }
        } else {
            EntityParrot mob = null;
            switch (this.getEnumType()) {
                case PARROT: {
                    mob = new EntityParrot(this.field_70170_p);
                    mob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
                    break;
                }
                default: {
                    mob = new EntityChicken(this.field_70170_p);
                }
            }
            if (!this.field_70170_p.field_72995_K && mob != null) {
                mob.func_70873_a(-24000);
                mob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)mob);
            }
        }
    }
}

