/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world.village;

import fossilsarcheology.server.entity.FAVillagerRegistry;
import fossilsarcheology.server.structure.FABlockProcessorVillage;
import fossilsarcheology.server.world.village.VillageComponentArcheologistHouse;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenArcheologistHouse
extends WorldGenerator {
    private static final ResourceLocation HOUSE = new ResourceLocation("fossil", "archeologist_villager_house");
    private static final ResourceLocation CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("fossil", "archeologist_house"));
    private VillageComponentArcheologistHouse component;
    private Rotation rotation;
    private EnumFacing facing;

    public WorldGenArcheologistHouse(VillageComponentArcheologistHouse component, EnumFacing facing) {
        this.component = component;
        this.facing = facing;
        switch (facing) {
            case SOUTH: {
                this.rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                this.rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                this.rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                this.rotation = Rotation.NONE;
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn == null) {
            return false;
        }
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
        Template template = templateManager.func_186237_a(server, HOUSE);
        Biome biome = worldIn.func_180494_b(position);
        int xSize = template.func_186259_a().func_177958_n() / 2;
        int zSize = template.func_186259_a().func_177952_p() / 2;
        template.func_189960_a(worldIn, position.func_177981_b(3).func_177967_a(EnumFacing.NORTH, xSize).func_177967_a(EnumFacing.SOUTH, zSize), (ITemplateProcessor)new FABlockProcessorVillage(position.func_177981_b(3), settings, CHEST, biome, this.facing.func_176734_d()), settings, 2);
        if (this.component.villagerCount < 1) {
            EntityVillager villager = new EntityVillager(worldIn);
            villager.setProfession(FAVillagerRegistry.ARCHEOLOGIST_PROFESSION);
            BlockPos center = position.func_177982_a(template.func_186259_a().func_177958_n() / 2, 4, template.func_186259_a().func_177952_p() / 2);
            BlockPos villagerPos = center.func_177981_b(4);
            villager.func_70012_b((double)villagerPos.func_177958_n() + 0.5, (double)villagerPos.func_177956_o() + 0.5, (double)villagerPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)villager);
            ++this.component.villagerCount;
        }
        return true;
    }
}

