/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;

public class ItemStackHelper {
    private static boolean initialized;
    private static Field itemField;
    private static Field itemDamageField;
    private static Field stackTagCompoundField;
    private static Field capabilitiesField;

    public static Item getTrueItem(@Nonnull ItemStack stack) {
        if (!initialized) {
            return stack.func_77973_b();
        }
        try {
            return (Item)itemField.get(stack);
        }
        catch (IllegalAccessException e) {
            return stack.func_77973_b();
        }
    }

    @Nonnull
    public static ItemStack getItemPrototype(@Nonnull ItemStack stack) {
        if (!initialized) {
            return stack.func_77946_l();
        }
        try {
            CapabilityDispatcher capabilities = (CapabilityDispatcher)capabilitiesField.get(stack);
            Item item = (Item)itemField.get(stack);
            int itemDamage = itemDamageField.getInt(stack);
            NBTTagCompound stackTagCompound = (NBTTagCompound)stackTagCompoundField.get(stack);
            ItemStack proto = new ItemStack(item, 1, itemDamage, capabilities != null ? capabilities.serializeNBT() : null);
            if (stackTagCompound != null) {
                proto.func_77982_d(stackTagCompound);
            }
            return proto;
        }
        catch (IllegalAccessException e) {
            return stack.func_77946_l();
        }
    }

    @Nonnull
    public static ItemStack encodeItemStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            return stack;
        }
        ItemStack proto = ItemStackHelper.getItemPrototype(stack);
        if (proto.func_190926_b()) {
            return stack;
        }
        NBTTagCompound tag = proto.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            proto.func_77982_d(tag);
        }
        tag.func_74768_a("__storagedrawers_count", stack.func_190916_E());
        return proto;
    }

    public static ItemStack encodeItemStack(@Nonnull ItemStack proto, int count) {
        if (!proto.func_190926_b() && count > 0 && count < 128) {
            ItemStack stack = proto.func_77946_l();
            stack.func_190920_e(count);
            return stack;
        }
        if (count == 0 || count >= 128) {
            ItemStack stack = proto.func_77946_l();
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            tag.func_74768_a("__storagedrawers_count", count);
            return stack;
        }
        return proto.func_77946_l();
    }

    public static ItemStack decodeItemStack(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return stack;
        }
        if (tag.func_74764_b("__storagedrawers_count")) {
            ItemStack decode = stack.func_77946_l();
            decode.func_190920_e(tag.func_74762_e("__storagedrawers_count"));
            tag = decode.func_77978_p();
            if (tag != null) {
                decode.func_77978_p().func_82580_o("__storagedrawers_count");
                if (tag.func_186856_d() == 0) {
                    decode.func_77982_d(null);
                }
            }
            return decode;
        }
        return stack;
    }

    public static boolean isStackEncoded(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        return tag.func_74764_b("__storagedrawers_count");
    }

    static {
        try {
            itemField = ItemStack.class.getDeclaredField("item");
            itemDamageField = ItemStack.class.getDeclaredField("itemDamage");
            stackTagCompoundField = ItemStack.class.getDeclaredField("stackTagCompound");
            capabilitiesField = ItemStack.class.getDeclaredField("capabilities");
            itemField.setAccessible(true);
            itemDamageField.setAccessible(true);
            stackTagCompoundField.setAccessible(true);
            capabilitiesField.setAccessible(true);
            initialized = true;
        }
        catch (NoSuchFieldException e) {
            initialized = false;
        }
    }
}

