/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="vehicle")
@Config.LangKey(value="vehicle.config.title")
@Mod.EventBusSubscriber(modid="vehicle")
public class VehicleConfig {
    @Config.Name(value="Client")
    @Config.Comment(value={"Client-only configs"})
    @Config.LangKey(value="vehicle.config.client")
    public static final Client CLIENT = new Client();
    @Config.Name(value="Server")
    @Config.Comment(value={"Server-only configs"})
    @Config.LangKey(value="vehicle.config.server")
    public static final Server SERVER = new Server();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("vehicle")) {
            ConfigManager.sync((String)"vehicle", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Debug {
        @Config.Name(value="Render Vehicle Outlines")
        @Config.Comment(value={"If true, renders an outline of all the elements on a vehicle's model. Useful for debugging interactions."})
        @Config.LangKey(value="vehicle.config.client.debug.render_outlines")
        public boolean renderOutlines = false;
        @Config.Name(value="Reload Raytracer Each Tick")
        @Config.Comment(value={"If true, the raytracer will be reloaded each tick."})
        @Config.LangKey(value="vehicle.config.client.debug.raytracer.continuous_reload")
        public boolean reloadRaytracerEachTick = false;
        @Config.Name(value="Reload Vehicle Properties Each Tick")
        @Config.Comment(value={"If true, the vehicle properties will be reloaded each tick."})
        @Config.LangKey(value="vehicle.config.client.debug.raytracer.vehicle_properties_reload")
        public boolean reloadVehiclePropertiesEachTick = false;
    }

    public static class Controller {
        @Config.Name(value="Use Triggers")
        @Config.Comment(value={"If true, will use the triggers on controller to control the acceleration of the vehicle."})
        @Config.LangKey(value="vehicle.config.client.controller.use_triggers")
        public boolean useTriggers = false;
    }

    public static class Display {
        @Config.Name(value="Show Speedometer")
        @Config.Comment(value={"If true, displays a speedometer on the HUD when driving a vehicle"})
        @Config.LangKey(value="vehicle.config.client.display.speedometer")
        public boolean enabledSpeedometer = true;
        @Config.Name(value="Auto Perspective")
        @Config.Comment(value={"If true, automatically switches to third person when mounting vehicles"})
        @Config.LangKey(value="vehicle.config.client.display.auto_perspective")
        public boolean autoPerspective = true;
        @Config.Name(value="Workstation Animation")
        @Config.Comment(value={"If true, an animation is performed while cycling vehicles in the workstation"})
        @Config.LangKey(value="vehicle.config.client.display.workstation_animation")
        public boolean workstationAnimation = true;
        @Config.Name(value="Hose Segments")
        @Config.Comment(value={"The amount of segments to use to render the hose on a gas pump. The lower the value, the better the performance but renders a less realistically looking hose"})
        @Config.LangKey(value="vehicle.config.client.display.hose_segments")
        @Config.RangeInt(min=1, max=100)
        public int hoseSegments = 10;
    }

    public static class Interaction {
        @Config.Name(value="Left-Click Enabled")
        @Config.Comment(value={"If true, raytraces will be performed on nearby vehicles when left-clicking the mouse, rather than just right-clicking it. This allows one to be damaged/broken when clicking anywhere on it, rather than just on its bounding box."})
        @Config.LangKey(value="vehicle.config.client.interaction.left_click")
        public boolean enabledLeftClick = true;
    }

    public static class Client {
        @Config.Name(value="Debug")
        @Config.Comment(value={"Configuration options for debugging vehicles"})
        @Config.LangKey(value="vehicle.config.client.debug")
        public Debug debug = new Debug();
        @Config.Name(value="Interaction")
        @Config.Comment(value={"Configuration options for vehicle interaction"})
        @Config.LangKey(value="vehicle.config.client.interaction")
        public Interaction interaction = new Interaction();
        @Config.Name(value="Display")
        @Config.Comment(value={"Configuration for display related options"})
        @Config.LangKey(value="vehicle.config.client.display")
        public Display display = new Display();
        @Config.Name(value="Controller")
        @Config.Comment(value={"Configuration options for controller support (Must have Controllable install)"})
        @Config.LangKey(value="vehicle.config.client.controller")
        public Controller controller = new Controller();
    }

    public static class Server {
        @Config.Name(value="Fuel Enabled")
        @Config.Comment(value={"If true, vehicles will require fuel for them to be driven."})
        @Config.LangKey(value="vehicle.config.server.fuel_enabled")
        public boolean fuelEnabled = true;
        @Config.Name(value="Vehicle Damage")
        @Config.Comment(value={"If true, vehicles will take damage."})
        @Config.LangKey(value="vehicle.config.server.vehicle_damage")
        public boolean vehicleDamage = true;
        @Config.Name(value="Trailer Detach Distance")
        @Config.Comment(value={"The distance threshold before the trailer detaches from a vehicle"})
        @Config.LangKey(value="vehicle.config.server.trailer_detach_threshold")
        public double trailerDetachThreshold = 6.0;
        @Config.Name(value="Trailer Sync Cooldown")
        @Config.Comment(value={"The amount of ticks to wait before syncing data to clients about the trailer connection. This is important for smooth trailer movement on client side."})
        @Config.LangKey(value="vehicle.config.server.trailer_sync_cooldown")
        public int trailerSyncCooldown = 100;
        @Config.Name(value="Trailer Inventory Sync Cooldown")
        @Config.Comment(value={"The amount of ticks to wait before syncing trailer inventory to tracking clients. If the value is set to 0 or less, the inventory will not sync and will save on network usage."})
        @Config.LangKey(value="vehicle.config.server.trailer_inventory_sync_cooldown")
        public int trailerInventorySyncCooldown = 20;
        @Config.Name(value="Pickup Vehicles")
        @Config.Comment(value={"Allows players to pick up vehicles by crouching and right clicking"})
        @Config.LangKey(value="vehicle.config.server.pick_up_vehicles")
        public boolean pickUpVehicles = true;
        @Config.Name(value="Max Hose Distance")
        @Config.Comment(value={"The maximum distance before the hose from the gas pump or fluid hose breaks"})
        @Config.LangKey(value="vehicle.config.server.max_hose_distance")
        public double maxHoseDistance = 6.0;
        @Config.Name(value="Pipe Transfer Amount")
        @Config.Comment(value={"The amount of fluid a pipe will transfer each tick"})
        @Config.LangKey(value="vehicle.config.server.pipe_transfer_amount")
        @Config.RangeInt(min=1)
        public int pipeTransferAmount = 50;
        @Config.Name(value="Pump Transfer Amount")
        @Config.Comment(value={"The amount of fluid a pump will transfer each tick"})
        @Config.LangKey(value="vehicle.config.server.pump_transfer_amount")
        @Config.RangeInt(min=1)
        public int pumpTransferAmount = 50;
        @Config.Name(value="Fuel Consumption Factor")
        @Config.Comment(value={"Change the amount of fuel vehicles consumes by multiplying the consumption rate by this factor"})
        @Config.LangKey(value="vehicle.config.erver.fuel_consumption_modifier")
        @Config.RangeDouble(min=0.0)
        public double fuelConsumptionFactor = 1.0;
    }
}

