/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySportsPlane;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class RenderSportsPlane
extends AbstractRenderVehicle<EntitySportsPlane> {
    @Override
    public void render(EntitySportsPlane entity, float partialTicks) {
        this.renderDamagedPart(entity, SpecialModels.SPORTS_PLANE_BODY.getModel());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)-0.1875, (double)0.5);
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.0);
        GlStateManager.func_179137_b((double)0.375, (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDamagedPart(entity, SpecialModels.SPORTS_PLANE_WING.getModel());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)-0.1875, (double)0.5);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.5, (double)0.0625, (double)0.0);
        GlStateManager.func_179137_b((double)0.375, (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDamagedPart(entity, SpecialModels.SPORTS_PLANE_WING.getModel());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)0.85);
        this.renderWheel(entity, 0.0f, -0.1875f, 1.5f, 0.0f, partialTicks);
        this.renderWheel(entity, 0.46875f, -0.1875f, 0.125f, 100.0f, partialTicks);
        this.renderWheel(entity, -0.46875f, -0.1875f, 0.125f, -100.0f, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float propellerRotation = entity.prevPropellerRotation + (entity.propellerRotation - entity.prevPropellerRotation) * partialTicks;
        GlStateManager.func_179137_b((double)0.0, (double)-0.09375, (double)1.3875);
        GlStateManager.func_179114_b((float)propellerRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderDamagedPart(entity, SpecialModels.SPORTS_PLANE_PROPELLER.getModel());
        GlStateManager.func_179121_F();
    }

    private void renderWheel(EntitySportsPlane vehicle, float offsetX, float offsetY, float offsetZ, float legRotation, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)offsetZ);
        this.renderDamagedPart(vehicle, SpecialModels.SPORTS_PLANE_WHEEL_COVER.getModel());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-0.140625f, (float)0.0f);
        GlStateManager.func_179094_E();
        if (vehicle.isMoving()) {
            float wheelRotation = vehicle.prevWheelRotation + (vehicle.wheelRotation - vehicle.prevWheelRotation) * partialTicks;
            GlStateManager.func_179114_b((float)(-wheelRotation), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        IBakedModel model = RenderUtil.getWheelModel(vehicle);
        if (model != null) {
            RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, vehicle.getWheelColor());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179114_b((float)legRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderDamagedPart(vehicle, SpecialModels.SPORTS_PLANE_LEG.getModel());
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyPlayerModel(EntitySportsPlane entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(10.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-10.0);
    }

    @Override
    public void applyPlayerRender(EntitySportsPlane entity, EntityPlayer player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale());
            seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
            seatVec = seatVec.func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W() - 0.5) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
            float bodyPitch = entity.prevBodyRotationX + (entity.bodyRotationX - entity.prevBodyRotationX) * partialTicks;
            float bodyRoll = entity.prevBodyRotationZ + (entity.bodyRotationZ - entity.prevBodyRotationZ) * partialTicks;
            GlStateManager.func_179114_b((float)bodyRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-bodyPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetX));
        }
    }
}

