/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.vehicle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IAttachableChest;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityMotorcycle;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachChest;
import com.mrcrayfish.vehicle.network.message.MessageOpenStorage;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMoped
extends EntityMotorcycle
implements EntityRaytracer.IEntityRaytraceable,
IAttachableChest {
    private static final DataParameter<Boolean> CHEST = EntityDataManager.func_187226_a(EntityMoped.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final EntityRaytracer.RayTracePart CHEST_BOX = new EntityRaytracer.RayTracePart(new AxisAlignedBB(-0.31875, 0.7945, -0.978125, 0.31875, 1.4195, -0.34375));
    private static final EntityRaytracer.RayTracePart TRAY_BOX = new EntityRaytracer.RayTracePart(EntityMoped.createScaledBoundingBox(-0.25, 0.6, -0.28125, 0.25, 0.6625, -0.78125, 1.2));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();
    private StorageInventory inventory;

    public EntityMoped(World worldIn) {
        super(worldIn);
        this.setMaxSpeed(12.0f);
        this.setTurnSensitivity(15);
        this.setMaxTurnAngle(45);
        this.setFuelCapacity(12000.0f);
        this.setFuelConsumption(0.225f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHEST, (Object)false);
    }

    @Override
    public SoundEvent getMovingSound() {
        return ModSounds.MOPED_ENGINE_MONO;
    }

    @Override
    public SoundEvent getRidingSound() {
        return ModSounds.MOPED_ENGINE_STEREO;
    }

    @Override
    public EngineType getEngineType() {
        return EngineType.SMALL_MOTOR;
    }

    @Override
    public float getMinEnginePitch() {
        return 0.5f;
    }

    @Override
    public float getMaxEnginePitch() {
        return 1.2f;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("chest", 1)) {
            this.setChest(compound.func_74767_n("chest"));
            if (compound.func_150297_b("inventory", 9)) {
                this.initInventory();
                InventoryUtil.readInventoryToNBT(compound, "inventory", this.inventory);
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        boolean hasChest = this.hasChest();
        compound.func_74757_a("chest", hasChest);
        if (hasChest && this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "inventory", (IInventory)this.inventory);
        }
    }

    @Override
    public boolean hasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(CHEST);
    }

    public void setChest(boolean chest) {
        this.field_70180_af.func_187227_b(CHEST, (Object)chest);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick) {
            EntityRaytracer.RayTracePart partHit = result.getPartHit();
            if (partHit == CHEST_BOX && this.hasChest()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageOpenStorage(this.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
                return true;
            }
            if (partHit == TRAY_BOX && !this.hasChest()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachChest(this.func_145782_y()));
                return true;
            }
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        ArrayList boxes = Lists.newArrayList();
        if (this.hasChest()) {
            boxes.add(CHEST_BOX);
        } else {
            boxes.add(TRAY_BOX);
        }
        return boxes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        if (this.hasChest()) {
            RenderGlobal.func_189697_a((AxisAlignedBB)CHEST_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        } else {
            RenderGlobal.func_189697_a((AxisAlignedBB)TRAY_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this.func_70005_c_(), false, 27, this);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(EntityLivingBase entity) {
        super.onVehicleDestroyed(entity);
        if (this.hasChest() && this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    @Nullable
    public StorageInventory getInventory() {
        if (this.hasChest() && this.inventory == null) {
            this.initInventory();
        }
        return this.inventory;
    }

    @Override
    public void attachChest(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            NBTTagCompound blockEntityTag;
            this.setChest(true);
            this.initInventory();
            NBTTagCompound itemTag = stack.func_77978_p();
            if (itemTag != null && !(blockEntityTag = itemTag.func_74775_l("BlockEntityTag")).func_82582_d() && blockEntityTag.func_150297_b("Items", 9)) {
                NonNullList chestInventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((NBTTagCompound)blockEntityTag, (NonNullList)chestInventory);
                for (int i = 0; i < chestInventory.size(); ++i) {
                    this.inventory.func_70299_a(i, (ItemStack)chestInventory.get(i));
                }
            }
        }
    }

    @Override
    public void removeChest() {
        if (this.inventory != null) {
            Vec3d target = new Vec3d(0.0, 0.75, -0.75).func_178785_b(-(this.field_70177_z - this.additionalYaw) * ((float)Math.PI / 180)).func_178787_e(this.func_174791_d());
            InventoryUtil.dropInventoryItems(this.field_70170_p, target.field_72450_a, target.field_72448_b, target.field_72449_c, (IInventory)this.inventory);
            this.inventory = null;
            this.setChest(false);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, target.field_72450_a, target.field_72448_b, target.field_72449_c, new ItemStack((Block)Blocks.field_150486_ae)));
        }
    }

    @Override
    public boolean isLockable() {
        return false;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CHEST_BOX, EntityRaytracer.boxToTriangles(CHEST_BOX.getBox(), null));
            interactionBoxMapStatic.put(TRAY_BOX, EntityRaytracer.boxToTriangles(TRAY_BOX.getBox(), null));
        }
    }
}

