/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(World world, BlockPos pos, IDrawerGroup group) {
        block0: for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            while (drawer.getStoredItemCount() > 0) {
                ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
                stack.func_190920_e(drawer.getStoredItemCount());
                if (stack.func_190926_b()) continue block0;
                DrawerInventoryHelper.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
                drawer.setStoredItemCount(0);
            }
        }
    }

    private static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            float velocity = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)velocity;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)velocity + (double)0.2f;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)velocity;
            world.func_72838_d((Entity)entityitem);
        }
    }
}

