/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.EntityPlayerMP;

public class ImageTools {
    public static byte[] toBytes(BufferedImage image) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage fromBytes(byte[] data) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(bais);
        bais.close();
        return image;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public static File getImageFile(EntityPlayerMP playerMP, UUID uuid) {
        File imageFolder = new File(playerMP.func_71121_q().func_72860_G().func_75765_b(), "camera_images");
        return new File(imageFolder, uuid.toString() + ".png");
    }

    public static void saveImage(EntityPlayerMP playerMP, UUID uuid, BufferedImage bufferedImage) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        image.mkdirs();
        ImageIO.write((RenderedImage)bufferedImage, "png", image);
    }

    public static BufferedImage loadImage(EntityPlayerMP playerMP, UUID uuid) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        FileInputStream fis = new FileInputStream(image);
        BufferedImage bufferedImage = ImageIO.read(fis);
        if (bufferedImage == null) {
            throw new IOException("BufferedImage is null");
        }
        return bufferedImage;
    }
}

