/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.entities.EntityImage;
import de.maxhenkel.camera.net.MessageToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageResizeFrame
extends MessageToServer<MessageResizeFrame> {
    private UUID uuid;
    private Direction direction;
    private boolean larger;

    public MessageResizeFrame() {
    }

    public MessageResizeFrame(UUID uuid, Direction direction, boolean larger) {
        this.uuid = uuid;
        this.direction = direction;
        this.larger = larger;
    }

    @Override
    public void execute(EntityPlayerMP player, MessageResizeFrame message) {
        if (player.field_71075_bZ.field_75099_e) {
            player.field_70170_p.func_175644_a(EntityImage.class, entityImage -> entityImage.func_110124_au().equals(message.uuid)).forEach(image -> image.resize(message.direction, message.larger));
        }
    }

    public void fromBytes(ByteBuf buf) {
        long most = buf.readLong();
        long least = buf.readLong();
        this.uuid = new UUID(most, least);
        this.direction = Direction.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.larger = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.direction.name());
        buf.writeBoolean(this.larger);
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

