/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.ModItems;
import de.maxhenkel.camera.items.ItemImage;
import de.maxhenkel.camera.proxy.CommonProxy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketManager {
    private Map<UUID, byte[]> clientDataMap = new HashMap<UUID, byte[]>();
    private Map<UUID, BufferedImage> imageCache = new HashMap<UUID, BufferedImage>();
    private Map<UUID, Long> times = new HashMap<UUID, Long>();

    public void addBytes(final EntityPlayerMP playerMP, final UUID imgUUID, int offset, int length, byte[] bytes) {
        byte[] data = !this.clientDataMap.containsKey(imgUUID) ? new byte[length] : this.clientDataMap.get(imgUUID);
        System.arraycopy(bytes, 0, data, offset, bytes.length);
        this.clientDataMap.put(imgUUID, data);
        if (offset + bytes.length >= data.length) {
            try {
                final BufferedImage image = this.completeImage(imgUUID);
                if (image == null) {
                    throw new IOException("Image incomplete");
                }
                this.imageCache.put(imgUUID, image);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImageTools.saveImage(playerMP, imgUUID, image);
                            playerMP.func_184102_h().func_152344_a(() -> {
                                ItemStack stack = new ItemStack((Item)ModItems.IMAGE);
                                ItemImage.setUUID(stack, imgUUID);
                                ItemImage.setTime(stack, System.currentTimeMillis());
                                ItemImage.setOwner(stack, playerMP.func_70005_c_());
                                if (!playerMP.func_191521_c(stack)) {
                                    InventoryHelper.func_180173_a((World)playerMP2.field_70170_p, (double)playerMP2.field_70165_t, (double)playerMP2.field_70163_u, (double)playerMP2.field_70161_v, (ItemStack)stack);
                                }
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }, "SaveImageThread").start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BufferedImage getExistingImage(EntityPlayerMP playerMP, UUID uuid) throws IOException {
        if (this.imageCache.containsKey(uuid)) {
            return this.imageCache.get(uuid);
        }
        BufferedImage image = ImageTools.loadImage(playerMP, uuid);
        this.imageCache.put(uuid, image);
        return image;
    }

    public BufferedImage completeImage(UUID imgUUID) {
        byte[] data = this.clientDataMap.get(imgUUID);
        if (data == null) {
            return null;
        }
        try {
            BufferedImage image = ImageTools.fromBytes(data);
            this.clientDataMap.remove(imgUUID);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canTakeImage(UUID player) {
        if (this.times.containsKey(player)) {
            if (System.currentTimeMillis() - this.times.get(player) < (long)CommonProxy.imageCooldown) {
                return false;
            }
            this.times.put(player, System.currentTimeMillis());
            return true;
        }
        this.times.put(player, System.currentTimeMillis());
        return true;
    }
}

