/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.VariableCommandSuggestionsPacketMessage;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class VariableCommand
implements ICommand {
    protected static GuiScreen lastScreen = null;
    protected static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            MinecraftForge.EVENT_BUS.register((Object)new VariableCommand());
            initialized = true;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        GuiScreen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof GuiChat && (lastScreen == null || lastScreen != s)) {
            VariableCommandSuggestionsPacketMessage msg = new VariableCommandSuggestionsPacketMessage();
            msg.direction = "server";
            msg.variableNameSuggestions.addAll(VariableCommand.getVariableNameSuggestions());
            PacketHandler.sendToServer(msg);
        }
        lastScreen = s;
    }

    public String func_71517_b() {
        return "fmvariable";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public List<String> func_71514_a() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("/fmvariable");
        return l;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("get") && args.length >= 2) {
                VariableCommand.getVariable(sender, "get", args[1]);
            }
            if (args[0].equalsIgnoreCase("set") && args.length >= 4) {
                boolean feedback = false;
                if (args[3].equalsIgnoreCase("true")) {
                    feedback = true;
                }
                VariableCommand.setVariable(sender, "set", args[1], args[2], feedback);
            }
        }
    }

    private static int getVariable(ICommandSender sender, String getOrSet, String variableName) {
        try {
            if (getOrSet.equalsIgnoreCase("get")) {
                String s = VariableHandler.getVariable(variableName);
                if (s != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Locals.localize((String)"fancymenu.commands.variable.get.success", (String[])new String[]{s})));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Locals.localize((String)"fancymenu.commands.variable.not_found", (String[])new String[0])));
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(ICommandSender sender, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (getOrSet.equalsIgnoreCase("set")) {
                VariableHandler.setVariable(variableName, setToValue);
                if (sendFeedback) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Locals.localize((String)"fancymenu.commands.variable.set.success", (String[])new String[]{setToValue})));
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error while executing command!"));
            e.printStackTrace();
        }
        return 1;
    }

    private static List<String> getVariableNameSuggestions() {
        List<String> l = VariableHandler.getVariableNames();
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 1) {
            l.add("get");
            l.add("set");
        } else if (args.length == 2) {
            l.addAll(VariableCommand.getVariableNameSuggestions());
        } else if (args.length == 3) {
            l.add("<set_to_value>");
        } else if (args.length == 4) {
            l.add("<send_chat_feedback>");
            l.add("true");
            l.add("false");
        }
        return l;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }
}

