/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.slider;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.slider.AdvancedSliderButton;
import java.util.function.Consumer;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RangeSliderButton
extends AdvancedSliderButton {
    private static final Logger LOGGER = LogManager.getLogger((String)"fancymenu/RangeSliderButton");
    public double minValue;
    public double maxValue;

    public RangeSliderButton(int x, int y, int width, int height, boolean handleClick, double minRangeValue, double maxRangeValue, double selectedRangeValue, Consumer<AdvancedSliderButton> applyValueCallback) {
        super(x, y, width, height, handleClick, 0.0, applyValueCallback);
        this.minValue = minRangeValue;
        this.maxValue = maxRangeValue;
        this.setSelectedRangeValue(selectedRangeValue);
        this.updateMessage();
    }

    @Override
    public String getSliderMessageWithoutPrefixSuffix() {
        return "" + this.getSelectedRangeValue();
    }

    public int getSelectedRangeValue() {
        return (int)RangeSliderButton.lerp(MathHelper.func_151237_a((double)this.value, (double)0.0, (double)1.0), this.minValue, this.maxValue);
    }

    protected static double lerp(double p_14140_, double p_14141_, double p_14142_) {
        return p_14141_ + p_14140_ * (p_14142_ - p_14141_);
    }

    public void setSelectedRangeValue(double rangeValue) {
        this.setValue((MathHelper.func_151237_a((double)rangeValue, (double)this.minValue, (double)this.maxValue) - this.minValue) / (this.maxValue - this.minValue));
    }
}

