/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public static Map<String, WebTexture> cachedWebImages = new HashMap<String, WebTexture>();
    public volatile ResourceLocation texture;
    public volatile WebTexture webTexture;
    public String rawURL = "";
    public volatile boolean ready = false;
    public static volatile Map<String, WebTexture> textureCache = new HashMap<String, WebTexture>();

    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = DynamicValueHelper.convertFromRaw(this.value);
                if (this.width <= 0 && this.height <= 0) {
                    this.setWidth(100);
                }
                if (cachedWebImages.containsKey(this.actionId)) {
                    this.webTexture = cachedWebImages.get(this.actionId);
                    if (this.webTexture.getLocation() != null && this.webTexture.textureURL.equals(this.value)) {
                        this.calculateAspectRatio();
                        this.ready = true;
                    } else {
                        this.webTexture = null;
                        this.texture = null;
                    }
                }
                if (this.webTexture == null) {
                    new Thread(() -> {
                        try {
                            if (WebTextureCustomizationItem.isValidUrl(this.value)) {
                                this.webTexture = WebTextureCustomizationItem.getWebTexture(this.value);
                                cachedWebImages.put(this.actionId, this.webTexture);
                                this.calculateAspectRatio();
                            }
                            this.ready = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        }
    }

    protected void calculateAspectRatio() {
        if (this.webTexture == null) {
            if (this.width <= 0) {
                this.setWidth(100);
            }
            if (this.height <= 0) {
                this.setHeight(100);
            }
            this.ready = true;
            return;
        }
        int w = this.webTexture.width;
        int h = this.webTexture.height;
        double ratio = (double)w / (double)h;
        if (this.getWidth() < 0 && this.getHeight() >= 0) {
            this.setWidth((int)((double)this.getHeight() * ratio));
        }
        if (this.getHeight() < 0 && this.getWidth() >= 0) {
            this.setHeight((int)((double)this.getWidth() / ratio));
        }
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        if (this.shouldRender() || WebTextureCustomizationItem.isEditorActive()) {
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            if (this.webTexture != null) {
                this.texture = this.webTexture.getLocation();
            }
            if (this.isTextureReady()) {
                RenderUtils.bindTexture((ResourceLocation)this.texture);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                WebTextureCustomizationItem.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (float)this.getWidth(), (float)this.getHeight());
                GlStateManager.func_179084_k();
            } else if (WebTextureCustomizationItem.isEditorActive()) {
                WebTextureCustomizationItem.func_73734_a((int)this.getPosX(menu), (int)this.getPosY(menu), (int)(this.getPosX(menu) + this.getWidth()), (int)(this.getPosY(menu) + this.getHeight()), (int)Color.MAGENTA.getRGB());
                if (this.ready) {
                    this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "\u00a7lMISSING", this.getPosX(menu) + this.width / 2, this.getPosY(menu) + this.height / 2 - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2, -1);
                }
            }
            if (!this.ready && WebTextureCustomizationItem.isEditorActive()) {
                this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "\u00a7lLOADING TEXTURE..", this.getPosX(menu) + this.width / 2, this.getPosY(menu) + this.height / 2 - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2, -1);
            }
        }
    }

    public boolean isTextureReady() {
        return this.texture != null && this.ready;
    }

    @Override
    public boolean shouldRender() {
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return false;
        }
        return super.shouldRender();
    }

    public static boolean isValidUrl(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e1) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }

    public static WebTexture getWebTexture(String url) {
        WebTexture wt = null;
        try {
            if (!textureCache.containsKey(url)) {
                URL u = new URL(url);
                HttpURLConnection httpcon = (HttpURLConnection)u.openConnection();
                httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
                InputStream s = httpcon.getInputStream();
                if (s != null) {
                    BufferedImage i = ImageIO.read(s);
                    wt = new WebTexture(i, url);
                    textureCache.put(url, wt);
                    s.close();
                }
            } else {
                wt = textureCache.get(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wt;
    }

    public static class WebTexture {
        public int width;
        public int height;
        public ResourceLocation location = null;
        public BufferedImage image;
        public String textureURL;

        public WebTexture(BufferedImage image, String url) {
            this.image = image;
            if (image != null) {
                this.width = image.getWidth();
                this.height = image.getHeight();
            }
            this.textureURL = url;
        }

        public ResourceLocation getLocation() {
            try {
                if (this.location == null && this.image != null) {
                    this.location = Minecraft.func_71410_x().func_110434_K().func_110578_a("webtexture", (DynamicTexture)new SelfcleaningDynamicTexture(this.image));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.image = null;
            return this.location;
        }
    }
}

