/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network.message;

import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncPlayerData
implements IMessage,
IMessageHandler<MessageSyncPlayerData, IMessage> {
    private int entityId;
    private List<SyncedPlayerData.DataEntry<?>> entries;

    public MessageSyncPlayerData() {
    }

    public MessageSyncPlayerData(int entityId, List<SyncedPlayerData.DataEntry<?>> entries) {
        this.entityId = entityId;
        this.entries = entries;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entries.size(), (int)4);
        this.entries.forEach(entry -> entry.write(buf));
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        int size = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        ArrayList entries = new ArrayList();
        for (int i = 0; i < size; ++i) {
            entries.add(SyncedPlayerData.DataEntry.read(buf));
        }
        this.entries = entries;
    }

    public IMessage onMessage(MessageSyncPlayerData message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> Obfuscate.proxy.updatePlayerData(message.entityId, message.entries));
        return null;
    }
}

