/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.configuration;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import drzhark.customspawner.configuration.CMSConfiguration;
import drzhark.customspawner.configuration.CMSProperty;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CMSConfigCategory
implements Map<String, CMSProperty> {
    private String name;
    private String comment;
    private ArrayList<CMSConfigCategory> children = new ArrayList();
    private Map<String, CMSProperty> properties = new TreeMap<String, CMSProperty>();
    public final CMSConfigCategory parent;
    private boolean changed = false;

    public CMSConfigCategory(String name) {
        this(name, null, true);
    }

    public CMSConfigCategory(String name, CMSConfigCategory parent) {
        this(name, parent, true);
    }

    public CMSConfigCategory(String name, boolean newline) {
        this(name, null, newline);
    }

    public CMSConfigCategory(String name, CMSConfigCategory parent, boolean newline) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CMSConfigCategory) {
            CMSConfigCategory cat = (CMSConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getQualifiedName() {
        return CMSConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, CMSConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public CMSConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map<String, CMSProperty> getValues() {
        return this.properties;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public CMSProperty get(String key) {
        return this.properties.get(key);
    }

    public void set(String key, CMSProperty value) {
        this.properties.put(key, value);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (int x = 0; x < data.length; ++x) {
            if (data[x] == null) continue;
            out.write(data[x]);
        }
        if (new_line) {
            out.write(CMSConfiguration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        this.write(out, pad0, "####################");
        this.write(out, pad0, "# ", this.name);
        if (this.comment != null) {
            this.write(out, pad0, "#===================");
            Splitter splitter = Splitter.onPattern((String)"\r?\n");
            for (String line : splitter.split((CharSequence)this.comment)) {
                this.write(out, pad0, "# ", line);
            }
        }
        this.write(out, pad0, "####################", CMSConfiguration.NEW_LINE);
        if (!CMSConfiguration.allowedProperties.matchesAllOf((CharSequence)this.name) && this.name.charAt(0) != '\"') {
            this.name = '\"' + this.name + '\"';
        }
        this.write(out, pad0, this.name, " {");
        CMSProperty[] props = this.properties.values().toArray(new CMSProperty[this.properties.size()]);
        for (int x = 0; x < props.length; ++x) {
            String propName;
            CMSProperty prop = props[x];
            if (prop.comment != null) {
                if (x != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)prop.comment)) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!CMSConfiguration.allowedProperties.matchesAllOf((CharSequence)(propName = prop.getName()))) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                char type = prop.getType().getID();
                this.write(out, false, pad1 + String.valueOf(type), ":", propName, " <");
                for (int i = 0; i < prop.valueList.size(); ++i) {
                    String line = prop.valueList.get(i);
                    if (prop.valueList.size() == i + 1) {
                        this.write(out, false, line);
                        continue;
                    }
                    this.write(out, false, line + ":");
                }
                this.write(out, false, ">", CMSConfiguration.NEW_LINE);
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, false, propName, "=", prop.getString());
                continue;
            }
            char type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getString());
        }
        for (CMSConfigCategory child : this.children) {
            child.write(out, indent + 1);
        }
        this.write(out, pad0, "}", CMSConfiguration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < indent; ++x) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (CMSProperty prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (CMSProperty prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public CMSProperty get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public CMSProperty put(String key, CMSProperty value) {
        this.changed = true;
        return this.properties.put(key, value);
    }

    @Override
    public CMSProperty remove(Object key) {
        this.changed = true;
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends CMSProperty> m) {
        this.changed = true;
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<CMSProperty> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, CMSProperty>> entrySet() {
        return ImmutableSet.copyOf(this.properties.entrySet());
    }

    public Set<CMSConfigCategory> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    public void removeChild(CMSConfigCategory child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.changed = true;
        }
    }
}

