/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.registry;

import drzhark.customspawner.configuration.CMSConfigCategory;
import drzhark.customspawner.configuration.CMSProperty;
import drzhark.customspawner.entity.EntityData;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.utils.CMSUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class StructureRegistry {
    public void registerStructure(EnvironmentSettings environment, InitMapGenEvent.EventType type, MapGenBase base) {
        if (type != null && base != null) {
            String structKey = "";
            switch (type) {
                case NETHER_BRIDGE: {
                    structKey = type.name();
                    this.addStructToConfig(environment, base, structKey);
                    break;
                }
                case SCATTERED_FEATURE: {
                    structKey = type.name();
                    this.addStructToConfig(environment, base, structKey);
                    break;
                }
            }
        }
    }

    public void addStructToConfig(EnvironmentSettings environment, MapGenBase base, String structKey) {
        block24: {
            block26: {
                String structCategoryName;
                List spawnList;
                block25: {
                    spawnList = null;
                    structCategoryName = "";
                    if (structKey.equalsIgnoreCase("NETHER_BRIDGE") && base instanceof MapGenNetherBridge) {
                        structCategoryName = "netherbridge";
                        spawnList = ((MapGenNetherBridge)base).func_75059_a();
                    } else if (structKey.equalsIgnoreCase("SCATTERED_FEATURE") && base instanceof MapGenScatteredFeature) {
                        structCategoryName = "witchhut";
                        spawnList = ((MapGenScatteredFeature)base).func_82667_a();
                    }
                    environment.CMSStructureConfig.load();
                    if (spawnList == null) break block24;
                    if (environment.CMSStructureConfig.hasCategory(structCategoryName)) break block25;
                    if (environment.debug) {
                        environment.envLog.logger.info("Creating new category for STRUCTURE " + structCategoryName + " in environment " + environment.name());
                    }
                    CMSConfigCategory spawnListCat = environment.CMSStructureConfig.getCategory("spawnlist");
                    spawnListCat.setComment("To add entities to a specific structure, add the entity in the format of TAG|ENTITYNAME to list./nExample: <MC|Witch:MOC|Horse:MC|Sheep");
                    CMSConfigCategory structCat = environment.CMSStructureConfig.getCategory(structCategoryName);
                    CMSConfigCategory spawnEntryCat = new CMSConfigCategory("spawnentries", structCat);
                    spawnListCat.put(structCategoryName, new CMSProperty(structCategoryName, new ArrayList<String>(), CMSProperty.Type.STRING));
                    CMSProperty spawnListProp = spawnListCat.get(structCategoryName);
                    for (int i = 0; i < spawnList.size(); ++i) {
                        Biome.SpawnListEntry spawnlistentry = (Biome.SpawnListEntry)spawnList.get(i);
                        EntityData entityData = environment.classToEntityMapping.get(spawnlistentry.field_76300_b);
                        if (entityData == null) {
                            entityData = environment.registerEntity(spawnlistentry.field_76300_b);
                        }
                        if (!entityData.getCanSpawn() || entityData.getFrequency() <= 0 || entityData.getMaxSpawn() <= 0 || entityData.getMaxInChunk() <= 0) {
                            spawnList.remove(i);
                            continue;
                        }
                        String tag = entityData.getEntityMod().getModTag();
                        String entityName = tag + "|" + entityData.getEntityName();
                        CMSConfigCategory entityCategory = new CMSConfigCategory(entityName, spawnEntryCat);
                        entityCategory.put("frequency", new CMSProperty("frequency", Integer.toString(spawnlistentry.field_76292_a), CMSProperty.Type.INTEGER));
                        entityCategory.put("minSpawn", new CMSProperty("minSpawn", Integer.toString(spawnlistentry.field_76301_c), CMSProperty.Type.INTEGER));
                        entityCategory.put("maxSpawn", new CMSProperty("maxSpawn", Integer.toString(spawnlistentry.field_76299_d), CMSProperty.Type.INTEGER));
                        if (environment.debug) {
                            environment.envLog.logger.info("Adding default spawnentry " + entityData.getEntityName() + " to STRUCTURE " + structCategoryName + " with frequency " + spawnlistentry.field_76292_a + ", minSpawn " + spawnlistentry.field_76301_c + ", maxSpawn " + spawnlistentry.field_76299_d);
                        }
                        spawnListProp.valueList.add(entityName);
                    }
                    environment.CMSStructureConfig.save();
                    break block24;
                }
                CMSConfigCategory spawnListCat = environment.CMSStructureConfig.getCategory("spawnlist");
                environment.initializeEntities();
                CMSProperty spawnListProperty = spawnListCat.get(structCategoryName);
                if (spawnListProperty == null) break block26;
                CMSConfigCategory spawnEntries = environment.CMSStructureConfig.getCategory(structCategoryName + ".spawnentries");
                if (spawnListProperty.valueList.size() == 0) {
                    for (CMSConfigCategory cat : spawnEntries.getChildren()) {
                        spawnEntries.removeChild(cat);
                    }
                } else {
                    Iterator<String> iterator = spawnEntries.keySet().iterator();
                    while (iterator.hasNext()) {
                        if (spawnListProperty.valueList.contains(iterator.next())) continue;
                        if (environment.debug) {
                            environment.envLog.logger.info("SpawnList " + structCategoryName + " does NOT contain spawn entry " + iterator.next() + ", REMOVING!!");
                        }
                        iterator.remove();
                    }
                }
                for (int i = 0; i < spawnListProperty.valueList.size(); ++i) {
                    Object spawnListEntry;
                    EntityData entityData = environment.entityMap.get(spawnListProperty.valueList.get(i));
                    if (entityData == null) continue;
                    CMSConfigCategory spawnEntryCat = null;
                    int frequency = entityData.getFrequency();
                    int minSpawn = entityData.getMinSpawn();
                    int maxSpawn = entityData.getMaxSpawn();
                    if (!environment.CMSStructureConfig.hasCategory(structCategoryName + ".spawnentries." + spawnListProperty.valueList.get(i))) {
                        spawnListEntry = CMSUtils.getSpawnListEntry(entityData.getEntityClass(), spawnList);
                        if (spawnListEntry != null) {
                            frequency = ((Biome.SpawnListEntry)spawnListEntry).field_76292_a;
                            minSpawn = ((Biome.SpawnListEntry)spawnListEntry).field_76301_c;
                            maxSpawn = ((Biome.SpawnListEntry)spawnListEntry).field_76299_d;
                        }
                        spawnEntryCat = environment.CMSStructureConfig.getCategory(structCategoryName + ".spawnentries." + spawnListProperty.valueList.get(i));
                        spawnEntryCat.put("frequency", new CMSProperty("frequency", Integer.toString(frequency), CMSProperty.Type.INTEGER));
                        spawnEntryCat.put("minSpawn", new CMSProperty("minSpawn", Integer.toString(minSpawn), CMSProperty.Type.INTEGER));
                        spawnEntryCat.put("maxSpawn", new CMSProperty("maxSpawn", Integer.toString(maxSpawn), CMSProperty.Type.INTEGER));
                    } else {
                        spawnEntryCat = environment.CMSStructureConfig.getCategory(structCategoryName + ".spawnentries." + spawnListProperty.valueList.get(i));
                        for (Map.Entry entry : spawnEntryCat.entrySet()) {
                            if (((String)entry.getKey()).equals("frequency")) {
                                frequency = Integer.parseInt(((CMSProperty)entry.getValue()).value);
                            } else if (((String)entry.getKey()).equals("minSpawn")) {
                                minSpawn = Integer.parseInt(((CMSProperty)entry.getValue()).value);
                            }
                            if (!((String)entry.getKey()).equals("maxSpawn")) continue;
                            maxSpawn = Integer.parseInt(((CMSProperty)entry.getValue()).value);
                        }
                    }
                    spawnListEntry = new Biome.SpawnListEntry(entityData.getEntityClass(), frequency, minSpawn, maxSpawn);
                    if (CMSUtils.getSpawnListEntry(entityData.getEntityClass(), spawnList) == null) {
                        if (environment.debug) {
                            environment.envLog.logger.info("Adding spawnentry " + entityData.getEntityName() + " to STRUCTURE " + structCategoryName + " with frequency " + frequency + ", minSpawn " + minSpawn + ", maxSpawn " + maxSpawn);
                        }
                        spawnList.add(new Biome.SpawnListEntry(entityData.getEntityClass(), frequency, minSpawn, maxSpawn));
                        continue;
                    }
                    if (environment.debug) {
                        environment.envLog.logger.info("Updating existing entity in " + structCategoryName + " with settings " + ((Biome.SpawnListEntry)spawnListEntry).field_76292_a + ":" + ((Biome.SpawnListEntry)spawnListEntry).field_76301_c + ":" + ((Biome.SpawnListEntry)spawnListEntry).field_76299_d);
                    }
                    Biome.SpawnListEntry spawnListEntry2 = CMSUtils.getSpawnListEntry(entityData.getEntityClass(), spawnList);
                    spawnListEntry2.field_76292_a = ((Biome.SpawnListEntry)spawnListEntry).field_76292_a;
                    spawnListEntry2.field_76301_c = ((Biome.SpawnListEntry)spawnListEntry).field_76301_c;
                    spawnListEntry2.field_76299_d = ((Biome.SpawnListEntry)spawnListEntry).field_76299_d;
                }
            }
            environment.CMSStructureConfig.save();
        }
    }
}

