/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.blocks;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.TorchRegistry;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.blocks.BlockBase;
import net.xalcon.torchmaster.common.items.ItemBlockMegaTorch;
import net.xalcon.torchmaster.common.tiles.IAutoRegisterTileEntity;
import net.xalcon.torchmaster.common.tiles.TileEntityMegaTorch;

public class BlockMegaTorch
extends BlockBase
implements ITileEntityProvider,
IAutoRegisterTileEntity {
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.35, 0.0, 0.35, 0.65, 1.0, 0.65);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    public static final String INTERNAL_NAME = "mega_torch";

    public BlockMegaTorch() {
        super(Material.field_151575_d, INTERNAL_NAME);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.0f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.getTorchState(true));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.getTorchState(true))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.getTorchState(false))));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMegaTorch();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityMegaTorch.class;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING);
    }

    @Override
    public String getTileEntityRegistryName() {
        return this.getRegistryName().toString();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STANDING_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        TorchRegistry.getMegaTorchRegistry().registerTorch(worldIn, pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        TorchRegistry.getMegaTorchRegistry().unregisterTorch(worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (!stack.func_77942_o()) {
                return;
            }
            TileEntity tile = worldIn.func_175625_s(pos);
            if (!(tile instanceof TileEntityMegaTorch)) {
                return;
            }
            NBTTagCompound compound = stack.func_179543_a("tm_tile");
            if (compound != null) {
                ((TileEntityMegaTorch)tile).readSyncNbt(compound);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".already_lit", new Object[0]), true);
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return true;
        }
        String itemId = itemStack.func_77973_b().getRegistryName().toString();
        if (Arrays.stream(TorchmasterConfig.MegaTorchLighterItems).noneMatch(s -> s.equals(itemId))) {
            return false;
        }
        NBTTagCompound nbt = itemStack.func_179543_a("tm_lighter");
        int amount = 1;
        float chance = 1.0f;
        if (nbt != null) {
            amount = nbt.func_74762_e("amount");
        }
        if (itemStack.func_77984_f()) {
            int remainingDamage = 1 + itemStack.func_77958_k() - itemStack.func_77952_i();
            chance = (float)remainingDamage / (float)amount;
            itemStack.func_77972_a(amount, (EntityLivingBase)playerIn);
        } else {
            if (amount > itemStack.func_190916_E()) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".light_failed_itemcount", new Object[0]), true);
                return false;
            }
            itemStack.func_190918_g(amount);
        }
        if (worldIn.field_73012_v.nextFloat() > chance) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_149739_a() + ".light_failed_itemtoodamaged", new Object[0]), false);
            return false;
        }
        worldIn.func_175656_a(pos, this.getTorchState(true));
        TileEntity torchTe = worldIn.func_175625_s(pos);
        if (torchTe instanceof TileEntityMegaTorch) {
            ((TileEntityMegaTorch)torchTe).relightTorch(TorchmasterConfig.MegaTorchBurnoutValue);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
        } else {
            TorchMasterMod.Log.error("There is an error whith the MegaTorch @ " + pos + ". Please replace the block!");
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return;
        }
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 1.1;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BURNING});
    }

    public IBlockState getTorchState(boolean isLit) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(isLit));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.getTorchState(meta == 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)this.func_176201_c(this.getTorchState(true)), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "burning=true"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)this.func_176201_c(this.getTorchState(false)), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "burning=false"));
    }

    public ItemBlock createItemBlock() {
        return (ItemBlock)new ItemBlockMegaTorch(this).setRegistryName(this.getRegistryName());
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 15 : 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(TorchmasterConfig.MegaTorchExtinguishOnHarvest ? this.getTorchState(false) : state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return TorchmasterConfig.MegaTorchAllowSilkTouch;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityMegaTorch) {
            ItemStack itemStack;
            if (worldIn.field_72995_K) {
                return;
            }
            if ((!TorchmasterConfig.MegaTorchExtinguishOnHarvest || this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) && !(itemStack = this.func_180643_i(state)).func_190926_b()) {
                player.func_71029_a(StatList.func_188055_a((Block)this));
                player.func_71020_j(0.005f);
                NBTTagCompound compound = itemStack.func_190925_c("tm_tile");
                ((TileEntityMegaTorch)te).writeSyncNbt(compound);
                BlockMegaTorch.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                return;
            }
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }
}

